import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class BlankLabel(BasicComicModule):
    imageUrl = 'd/%s.html'
    imageSearch = re.compile(r'"(/comic[s|/].+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'(?:"((?:/d/[^"\r\n]*)|(?:/strip/.+?))")(?:(?:.{43}starshift_back.gif)|(?:.+?cxn_previous)|(?:.{43}previous)|(?:.{58}previous)|(?:.*?back_button)|(?:.*?comicnav-previous))', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    submodules = {
       'CheckerboardNightmare': 'http://www.checkerboardnightmare.com/',
       'CourtingDisaster': 'http://www.courting-disaster.com/',
       'EvilInc': 'http://www.evil-comic.com/',
       'GreystoneInn': 'http://www.greystoneinn.net/',
       'ItsWalky': 'http://www.itswalky.com/',
#       'KrazyLarry':'http://www.krazylarry.com/', one strip name starts with %20
       'Melonpool':'http://www.melonpool.com/',
#       'RealLife':'http://www.reallifecomics.com/', strip names = index.php
       'SchlockMercenary': 'http://www.schlockmercenary.com/',
#       'Sheldon':'http://www.sheldoncomics.com/', hosted on ComicsDotCom
       'Shortpacked': 'http://www.shortpacked.com/',
       'StarslipCrisis': 'http://www.starslipcrisis.com/',
       'UglyHill': 'http://www.uglyhill.com/',
       'WapsiSquare': 'http://www.wapsisquare.com/',
    }

    latestUrls = {
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = self.latestUrls.get(submodule, baseUrl)
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'BlankLabel' + '/' + submodule
