import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, IndirectLatestMixin

class SGVY(BasicComicModule, IndirectLatestMixin):
    baseUrl = 'http://www.sgvy.com/'
    imageUrl = 'http://www.sgvy.com/Edda%s/Issue%s/Page%s.html'
    imageSearch = re.compile(r'<img src="((?:\.\./)+images/sgvy/sgvy-[-\w\d]+\.\w+)"')
    prevSearch = re.compile(r'<a href="((?:\.\./)+(?:Edda\d+|Holiday)/(?:Issue\d+/Page\d+|Cover)\.html)">Prev</a>')
    nextSearch = re.compile(r'<a href="((?:\.\./)+(?:Edda\d+|Holiday)/(?:Issue\d+/Page\d+|Cover)\.html)">Next</a>')
    latestSearch = re.compile(r'<a href="(archives/(?:Edda\d+|Holiday)/(?:Issue\d+/Page\d+|Cover)\.html)">')
    help = 'Index format: edda-issue-page'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))

