import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.io.IOException;


/**
 * Page for handing projects. This has two different appearances: 
 * <dl>
 * <dt>No project loaded
 * <dt>This displays buttons for creating a new project, loading an existing
 * project, and also a recent files list to allow recent projects to be loaded
 * quickly.
 * <dt>Project Loaded
 * <dd>This gives options to save the project, save the project  under a
 * different name, close the project and to revert to the saved version. This
 * may also include some statistical information at some stage.
 */
public class ProjectPage extends WizardPage{

	/**
	 * Construct a new project page
	 */
	public ProjectPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, "Project");
	}

	/**
	 * No customisation is done here. We construct the page in the {@link
	 * #preShow()} method.
	 */
	protected void customise(){
		// We'll do all the work in the preShow method this time...
	}

	/**
	 * Constructs the contents of the page.
	 */
	protected void preShow(){
		System.out.println("project page preshow.");
		(new Exception()).printStackTrace();

		/** Stores the content of the page, to be displayed on the output. */
		VBox mainVBox = new VBox(false, 5);

		if (DomesdayGUI.project != null){
			// A project is loaded
			Label loaded = new Label(  DomesdayGUI.messages.getString("projloaded"));
			loaded.setLineWrap(true);
			mainVBox.add(loaded);

			Button save = new Button( DomesdayGUI.messages.getString("SaveProj") );
			mainVBox.add(save);
			Button saveAs = new Button( DomesdayGUI.messages.getString("SaveProjAs") );
			mainVBox.add(saveAs);
			
			Button closeProj = new Button( "_Close" );
			mainVBox.add(closeProj);
			closeProj.addListener(new ButtonListener() {
				public void buttonEvent(ButtonEvent event){
					if (event.isOfType(ButtonEvent.Type.CLICK)){
						DomesdayGUI.project = null;
						System.out.println("Project Closed");
						((DomesdayGUI) wizard).changeProject();
						preShow();
					}
				}
			});			
			setButtonVisibility(true, true);
		}else{
			// There is no project loaded
			Label noProj = new Label( DomesdayGUI.messages.getString("NoProj") );
			noProj.setLineWrap(true);
			mainVBox.add(noProj);
			
			HButtonBox bbox = new HButtonBox();
			
			Button newProj = new Button(  DomesdayGUI.messages.getString("NewProj") );
			//todo
			wizard.addHint(newProj, new Hint("Click to create a new proj"));
			bbox.add(newProj);
			newProj.addListener( new ButtonListener() {
				public void buttonEvent(ButtonEvent event){
					if (event.isOfType(ButtonEvent.Type.CLICK)){
						DomesdayGUI.project = new Project(DomesdayGUI.log);
						
						System.out.println("TODO: Loading default project...");
						try{
						DomesdayGUI.project.load("testconfig.ig");
						}catch(IllegalVariableException e){
							//todo
							System.out.println(e.toString());
						}catch(IOException e){
							//todo
							System.out.println(e.toString());
						}
						((DomesdayGUI) wizard).changeProject();
						wizard.goNext();
					}
				}
			});			
			
			Button loadProj = new Button( DomesdayGUI.messages.getString("LoadProj") );
			wizard.addHint(loadProj, new Hint("Click to select a previously saved domesday project file") );
			bbox.add(loadProj);
			bbox.setLayout( ButtonBoxStyle.SPREAD );
			bbox.showAll();
			mainVBox.add(bbox);
			loadProj.addListener( new ButtonListener() {
				public void buttonEvent(ButtonEvent event){
					if (event.isOfType(ButtonEvent.Type.CLICK)){
						startLoad();
					}
				}
			});
				
			Frame recentFrame = new Frame( DomesdayGUI.messages.getString("RecentProjects") );
			mainVBox.packEnd(recentFrame);
			VBox recentBox = new VBox(false, 2);
			Label recentLbl = new Label( DomesdayGUI.messages.getString("RecentProjHead") );
			recentLbl.setLineWrap(true);
			//todo recent list
			recentBox.add(recentLbl);
			recentBox.showAll();
			recentFrame.add(recentBox);
			
			setButtonVisibility(true, false);
		}
		
		mainVBox.showAll();
		content = (mainVBox);
	}

	/** 
	 * Loads a project file the given file
	 * @param filename The name of the project to load.
	 */
	private void loadProject(String filename){
		//todo
		DomesdayGUI.project = new Project(DomesdayGUI.log);
		try{
			DomesdayGUI.project.load(filename);
		}catch(Exception e){
			System.out.println("proj load err: "+e);
			e.printStackTrace();
			//todo
		}
		((DomesdayGUI) wizard).changeProject();
		wizard.goNext();
		System.out.println("Load Project: "+filename);
	}

	/** Selection dialog for the load button */
	private FileSelection loadFile = null;
	/**
	 * constructs a file selection dialog and sets up handlers.
	 */	
	private void startLoad(){
		System.out.println("start load");
		loadFile = new FileSelection( DomesdayGUI.messages.getString("LoadTitle"));
		//todo: loadFile.setFileName( directory of file at top of MRU list );
		loadFile.getOKButton().addListener( new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK))
					fileLoadOK();
			}
		});
		loadFile.getCancelButton().addListener( new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK))
					fileLoadCancel();
			}
		});				
		loadFile.present();
	}

	/**
	 * This is called after OK is pressed in the file load dialog.
	 */
	private void fileLoadOK(){
		loadProject(loadFile.getFilename());
		loadFile.destroy();
	}
	/**
	 * This is called after cancel is pressed in the load dialog.
	 */
	private void fileLoadCancel(){
		loadFile.destroy();
	}

}
