import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * Template page. Allows users to load a template for their index.
 * This page contains a little text and a button. The button will launch a
 * customised file selection dialog - this will be similar to image selection
 * dialogs except that the preview will be replaced with template information
 */
public class TemplatePage extends WizardPage{

	/**
	 * Constructs a new page
	 */
	public TemplatePage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("TemplateTitle"));
	}

	/**
	 * Adds the widgets to the page.
	 */
	protected void customise(){		
		System.out.println("template page customise");
		VBox mainVBox = new VBox(false, 5);

		Label intro = new Label( DomesdayGUI.messages.getString("TemplateHead"));
		intro.setLineWrap(true);
		mainVBox.add(intro);

		Button loadBtn = new Button( DomesdayGUI.messages.getString("TemplateLoad"));
		HButtonBox bbox = new HButtonBox();
		bbox.add(loadBtn);
		mainVBox.add(bbox);

		// 
		// TODO:
		// add handler to that button
		// show a dialog for loading templates - give title, description for
		// each one
		// Possibly use a modified fileSelection for this.
		//
		// TODO: decide on a format for template files.

		mainVBox.showAll();
		content =  mainVBox;
	}

}
