import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * A page to determine whether the source of the index is a local filesystem or
 * a remote server. This is a simple radiogroup option. 
 * 
 * <p>When the setting is changed, methods will be called to update the tree.
 */
public class IndexSourcePage extends WizardPage{

	/**
	 * Constructs a new IndexSourcePage
	 */
	public IndexSourcePage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("IndexSource"));
	}


	/**	Radio button for File System source */
	private static RadioButton fileSys = null;
	/** Radio button for server source */
	private static RadioButton server = null;
	/** If true, server method is being used. */
	private boolean useServer = false;

	private static ToggleListener changeListener;
	
	/**
	 * Sets up the widgets of the screen.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 5);

		Label head = new Label(  DomesdayGUI.messages.getString("IndexSourceHead") );
		head.setLineWrap(true);
		mainVBox.add(head);		
		
		fileSys = new RadioButton(null, DomesdayGUI.messages.getString("FileSystem"), true );
		mainVBox.add(fileSys);
		Label desc = new Label( DomesdayGUI.messages.getString("FileSystemDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);
		server = new RadioButton(fileSys,  DomesdayGUI.messages.getString("Server"), true );
		mainVBox.add(server);						
		desc = new Label( DomesdayGUI.messages.getString("ServerDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);

		changeListener = (ToggleListener) new sourceChangeHandler();
		fileSys.addListener( changeListener);

		mainVBox.showAll();
		content =  mainVBox;
		System.out.println("Customised IndexSourcePage");
	}
	
	/**
	 * Load the setting from the project file before displaying the page.
	 */
	protected void preShow(){
		try{
			useServer = DomesdayGUI.project.getEnumSetting("GET_METHOD").equals("GET_METHOD_SERVER");
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
		}
		server.setState(useServer);
	}

	/**
	 * Listener for changes to the setting
	 */
	public class sourceChangeHandler implements ToggleListener{
		/**
		 * If the setting has changed, the index source will be updated, as will
		 * the project
		 */
		public void toggleEvent(ToggleEvent event){
			System.out.println("source toggle "+event);
			if (useServer != server.getState()){
				useServer = server.getState();
				try{
					DomesdayGUI.project.storeSettingByVar("GET_METHOD", useServer ? "GET_METHOD_SERVER" : "GET_METHOD_FILESYSTEM" );
					}catch(IllegalVariableException e){
						DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
					}
				((DomesdayGUI) wizard).changeIndexSource();
			}
		}
	}

}
