# -*- coding: utf-8 -*-
# Copyright (C) 2012 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2012-09-29
# Last changed: 2012-09-29

import dolfin.cpp as cpp

#--- Deprecation of down_cast ---

def _down_cast(self):
    cpp.warning("foo.down_cast() is deprecated, please use as_backend_type(foo).")
    return cpp.as_backend_type(self)

cpp.Matrix.down_cast = _down_cast
cpp.Vector.down_cast = _down_cast

def down_cast(foo):
    cpp.warning("down_cast(foo) is deprecated, please use as_backend_type(foo).")
    return cpp.as_backend_type(foo)

#--- Deprecation of ... etc. ---
