// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=io, header=GenericFile.h)
%feature("docstring")  dolfin::GenericFile::GenericFile "
Constructor
";

// Documentation extracted from: (module=io, header=File.h)
%feature("docstring")  dolfin::File "
A File represents a data file for reading and writing objects.
Unless specified explicitly, the format is determined by the
file name suffix.
A list of objects that can be read/written to file can be found in
GenericFile.h. Compatible file formats include:
    * Binary (.bin)
    * RAW    (.raw)
    * SVG    (.svg)
    * XD3    (.xd3)
    * XML    (.xml)
    * XYZ    (.xyz)
    * VTK    (.pvd)
";

%feature("docstring")  dolfin::File::Type "
File formats
";

%feature("docstring")  dolfin::File::File "
**Overloaded versions**

* File\ (filename, encoding=\"ascii\")

  Create a file with given name
  
  *Arguments*
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ASCII is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (comm, filename, encoding=\"ascii\")

  Create a file with given name with MPI communicator
  
  *Arguments*
      communicator (:py:class:`MPI`)
          The MPI communicator.
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (filename, type, encoding=\"ascii\")

  Create a file with given name and type (format)
  
  *Arguments*
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (comm, filename, type, encoding=\"ascii\")

  Create a file with given name and type (format) with MPI communicator
  
  *Arguments*
      communicator (:py:class:`MPI`)
          The MPI communicator.
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (outstream)

  Create an outfile object writing to stream
  
  *Arguments*
      outstream (std::ostream)
          The stream.
";

%feature("docstring")  dolfin::File::operator>> "
Read from file
";

%feature("docstring")  dolfin::File::operator<< "
**Overloaded versions**

* operator<<\ (Mesh*, mesh)

  Write Mesh to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<int>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<double>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<bool>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (Function*, u)

  Write Function to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (t)

  Write object to file
";

%feature("docstring")  dolfin::File::exists "
Check if file exists

*Arguments*
    filename (str)
        Name of file.

*Returns*
    bool
        True if the file exists.
";

%feature("docstring")  dolfin::File::create_parent_path "

*Arguments*
    filename (str)
        Name of file / path.
";

// Documentation extracted from: (module=io, header=XDMFFile.h)
%feature("docstring")  dolfin::XDMFFile "
This class supports the output of meshes and functions in XDMF
(http://www.xdmf.org) format. It creates an XML file that
describes the data and points to a HDF5 file that stores the
actual problem data. Output of data in parallel is supported.

XDMF is not suitable for checkpointing as it may decimate some
data.
";

%feature("docstring")  dolfin::XDMFFile::Encoding "
File encoding type
";

%feature("docstring")  dolfin::XDMFFile::UseFilePartition "
Re-use any partition stored in file
";

%feature("docstring")  dolfin::XDMFFile::XDMFFile "
**Overloaded versions**

* XDMFFile\ (filename)

  Constructor

* XDMFFile\ (comm, filename)

  Constructor
";

%feature("docstring")  dolfin::XDMFFile::write "
**Overloaded versions**

* write\ (mesh)

  Save a mesh to XDMF format, either using an associated HDF5
  file, or storing the data inline as XML Create function on
  given function space
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          A mesh to save.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (u)

  Save a Function to XDMF file for visualisation, using an
  associated HDF5 file, or storing the data inline as XML.
  
  *Arguments*
      u (:py:class:`Function`)
          A function to save.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (u, t)

  Save a Function with timestamp to XDMF file for visualisation,
  using an associated HDF5 file, or storing the data inline as
  XML.
  
  *Arguments*
      u (:py:class:`Function`)
          A function to save.
      t (_double_)
          Timestep
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (meshfunction)

  Save MeshFunction to file using an associated HDF5 file, or
  storing the data inline as XML.
  
  *Arguments*
      meshfunction (:py:class:`MeshFunction`)
          A meshfunction to save.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (mvc)

  Write out mesh value collection (subset) using an associated
  HDF5 file, or storing the data inline as XML.
  
  *Arguments*
      mvc (_MeshValueCollection<std::size_t>_)
          A list of points to save.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (points)

  Save a cloud of points to file using an associated HDF5 file,
  or storing the data inline as XML.
  
  *Arguments*
      points (_std::vector<Point>_)
          A list of points to save.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  

* write\ (points, values)

  Save a cloud of points, with scalar values using an associated
  HDF5 file, or storing the data inline as XML.
  
  *Arguments*
      points (_std::vector<Point>_)
          A list of points to save.
      values (numpy.array(float))
          A list of values at each point.
      encoding (_Encoding_)
          Encoding to use: HDF5 or ASCII
  
";

%feature("docstring")  dolfin::XDMFFile::read "
**Overloaded versions**

* read\ (mesh)

  Read in a mesh from the associated HDF5 file, optionally using
  stored partitioning, if possible when the same number of
  processes are being used.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
  
      use_partition_from_file (_UseFilePartition_)
          Use the existing partition information in HDF5 file
  

* read\ (meshfunction)

  Read first MeshFunction from file
";

// Documentation extracted from: (module=io, header=HDF5File.h)
%feature("docstring")  dolfin::HDF5File::HDF5File "
Constructor. file_mode should \"a\" (append), \"w\" (write) or \"r\"
(read).
";

%feature("docstring")  dolfin::HDF5File::close "
Close file
";

%feature("docstring")  dolfin::HDF5File::flush "
Flush buffered I/O to disk
";

%feature("docstring")  dolfin::HDF5File::write "
**Overloaded versions**

* write\ (points, name)

  Write points to file

* write\ (values, name)

  Write simple vector of double to file

* write\ (x, name)

  Write Vector to file in a format suitable for re-reading

* write\ (mesh, name)

  Write Mesh to file in a format suitable for re-reading

* write\ (mesh, cell_dim, name)

  Write Mesh of given cell dimension to file in a format
  suitable for re-reading

* write\ (u, name)

  Write Function to file in a format suitable for re-reading

* write\ (u, name, timestamp)

  Write Function to file with a timestamp

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (mesh_values, name)

  Write MeshValueCollection to file

* write\ (mesh_values, name)

  Write MeshValueCollection to file

* write\ (mesh_values, name)

  Write MeshValueCollection to file
";

%feature("docstring")  dolfin::HDF5File::read "
**Overloaded versions**

* read\ (x, dataset_name, use_partition_from_file)

  Read vector from file and optionally re-use any partitioning
  that is available in the file

* read\ (u, name)

  Read Function from file and distribute data according to the
  Mesh and dofmap associated with the Function.  If the 'name'
  refers to a HDF5 group, then it is assumed that the Function
  data is stored in the datasets within that group.  If the
  'name' refers to a HDF5 dataset within a group, then it is
  assumed that it is a Vector, and the Function will be filled
  from that Vector

* read\ (mesh, data_path, use_partition_from_file)

  Read Mesh from file, using attribute data (e.g., cell type) stored
  in the HDF5 file. Optionally re-use any partition data
  in the file. This function requires all necessary data for
  constructing a Mesh to be present in the HDF5 file.

* read\ (input_mesh, topology_path, geometry_path, gdim, cell_type, expected_num_global_cells, expected_num_global_points, use_partition_from_file)

  Construct Mesh with paths to topology and geometry datasets, and
  providing essential meta-data, e.g. geometric dimension and
  cell type. If this data is available in the HDF5 file, it will
  be checked for consistency. Set expected_num_global_cells to a
  negative value if not known.
  
  This function is typically called when using the XDMF format,
  in which case the meta data has alreayd been read from an XML
  file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file
";

%feature("docstring")  dolfin::HDF5File::has_dataset "
Check if dataset exists in HDF5 file
";

// Documentation extracted from: (module=io, header=HDF5Attribute.h)
%feature("docstring")  dolfin::HDF5Attribute "
HDF5Attribute gives access to the attributes of a dataset
via set() and get() methods
";

%feature("docstring")  dolfin::HDF5Attribute::HDF5Attribute "
Constructor
";

%feature("docstring")  dolfin::HDF5Attribute::exists "
Check for the existence of an attribute on a dataset
";

%feature("docstring")  dolfin::HDF5Attribute::set "
**Overloaded versions**

* set\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of an array of float attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of an array of float attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of a string attribute in the HDF5 file
";

%feature("docstring")  dolfin::HDF5Attribute::get "
**Overloaded versions**

* get\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of a vector double attribute in the HDF5 file

* get\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of a vector double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of an attribute in the HDF5 file as a string
";

%feature("docstring")  dolfin::HDF5Attribute::str "
**Overloaded versions**

* str\ (attribute_name)

  Get the value of the attribute in the HDF5 file
  as a string representation

* str\ ()

  Get the names of all the attributes on this dataset
";

%feature("docstring")  dolfin::HDF5Attribute::type_str "
Get the type of the attribute \"string\", \"float\", \"int\"
\"vectorfloat\", \"vectorint\" or \"unsupported\"
";

%feature("docstring")  dolfin::HDF5Attribute::list_attributes "
Get the names of all the attributes on this dataset as a
std::vector<std::string>
";

// Documentation extracted from: (module=io, header=X3DOM.h)
%feature("docstring")  dolfin::X3DOMParameters "
Class data to store X3DOM view parameters.
";

%feature("docstring")  dolfin::X3DOMParameters::Representation "
X3DOM representation type
";

%feature("docstring")  dolfin::X3DOMParameters::X3DOMParameters "
Constructor (with default parameter settings)
";

%feature("docstring")  dolfin::X3DOMParameters::set_representation "
Set representation of object (wireframe, surface or
surface_with_edges)
";

%feature("docstring")  dolfin::X3DOMParameters::get_representation "
Get the current representation of the object (wireframe, surface or
surface_with_edges)
";

%feature("docstring")  dolfin::X3DOMParameters::get_viewport_size "
Get the size of the viewport
";

%feature("docstring")  dolfin::X3DOMParameters::set_diffuse_color "
Set the RGB color of the object
";

%feature("docstring")  dolfin::X3DOMParameters::get_diffuse_color "
Get the RGB diffuse color of the object
";

%feature("docstring")  dolfin::X3DOMParameters::set_emissive_color "
Set the RGB emissive color
";

%feature("docstring")  dolfin::X3DOMParameters::get_emissive_color "
Get the RGB emissive color
";

%feature("docstring")  dolfin::X3DOMParameters::set_specular_color "
Set the RGB specular color
";

%feature("docstring")  dolfin::X3DOMParameters::set_background_color "
Set background RGB color
";

%feature("docstring")  dolfin::X3DOMParameters::get_background_color "
Get background RGB color
";

%feature("docstring")  dolfin::X3DOMParameters::set_ambient_intensity "
Set the ambient lighting intensity
";

%feature("docstring")  dolfin::X3DOMParameters::get_ambient_intensity "
Get the ambient lighting intensity
";

%feature("docstring")  dolfin::X3DOMParameters::set_shininess "
Set the surface shininess of the object
";

%feature("docstring")  dolfin::X3DOMParameters::get_shininess "
Set the surface shininess of the object
";

%feature("docstring")  dolfin::X3DOMParameters::set_transparency "
Set the transparency (0-1)
";

%feature("docstring")  dolfin::X3DOMParameters::get_transparency "
Get the transparency (0-1)
";

%feature("docstring")  dolfin::X3DOMParameters::set_color_map "
Set the color map by supplying a vector of 768 values
(256*RGB) (using std::vector for Python compatibility via
SWIG)
";

%feature("docstring")  dolfin::X3DOMParameters::get_color_map "
Get the color map as a vector of 768 values (256*RGB) (using
std::vector for Python compatibility via SWIG)
";

%feature("docstring")  dolfin::X3DOMParameters::get_color_map_array "
Get the color map as a boost::multi_array (256x3)
";

%feature("docstring")  dolfin::X3DOMParameters::set_viewpoint_buttons "
Toggle viewpoint buttons
";

%feature("docstring")  dolfin::X3DOMParameters::get_viewpoint_buttons "
Get the viewpoint button state
";

%feature("docstring")  dolfin::X3DOMParameters::set_x3d_stats "
Turn X3D 'statistics' window on/off
";

%feature("docstring")  dolfin::X3DOM "
This class implements output of meshes to X3DOM XML or HTML5
with X3DOM strings. The latter can be used for interactive visualisation

Developer note: pugixml is used to created X3DOM and HTML5. By
using pugixml, we produce valid XML, but care must be taken that
the XML is also valid HTML. This includes not letting pugixml
create self-closing elements, in cases. E.g., <foo
bar=\"foobar\"></foo> is fine, but the self-closing syntax <foo
bar=\"foobar\" /> while being valid XML is is not valid HTML5. See
https://github.com/x3dom/x3dom/issues/600.
";

%feature("docstring")  dolfin::X3DOM::str "
**Overloaded versions**

* str\ ()

  Return X3D string for a Mesh

* str\ ()

  Return X3D string for a Function
";

%feature("docstring")  dolfin::X3DOM::html "
**Overloaded versions**

* html\ ()

  Return HTML5 string with embedded X3D for a Mesh

* html\ ()

  Return HTML5 string with embedded X3D for a Function
";

