// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=geometry, header=Point.h)
%feature("docstring")  dolfin::Point "
A Point represents a point in :math:`\mathbb{R}^3` with
coordinates :math:`x, y, z,` or alternatively, a vector in
:math:`\mathbb{R}^3`, supporting standard operations like the
norm, distances, scalar and vector products etc.
";

%feature("docstring")  dolfin::Point::Point "
**Overloaded versions**

* Point\ (x=0.0, y=0.0, z=0.0)

  Create a point at (x, y, z). Default value (0, 0, 0).
  
  *Arguments*
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
      z (float)
          The z-coordinate.

* Point\ (dim, x)

  Create point from array
  
  *Arguments*
      dim (int)
          Dimension of the array.
      x (float)
          The array to create a Point from.

* Point\ (x)

  Create point from Array
  
  *Arguments*
      x (Array<double>)
          Array of coordinates.

* Point\ (p)

  Copy constructor
  
  *Arguments*
      p (:py:class:`Point`)
          The object to be copied.
";

%feature("docstring")  dolfin::Point::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Return address of coordinate in direction i
  
  *Arguments*
      i (int)
          Direction.
  
  *Returns*
      float
          Address of coordinate in the given direction.

* operator[]\ (i)

  Return coordinate in direction i
  
  *Arguments*
      i (int)
          Direction.
  
  *Returns*
      float
          The coordinate in the given direction.
";

%feature("docstring")  dolfin::Point::x "
Return x-coordinate

*Returns*
    float
        The x-coordinate.
";

%feature("docstring")  dolfin::Point::y "
Return y-coordinate

*Returns*
    float
        The y-coordinate.
";

%feature("docstring")  dolfin::Point::z "
Return z-coordinate

*Returns*
    float
        The z-coordinate.
";

%feature("docstring")  dolfin::Point::coordinates "
**Overloaded versions**

* coordinates\ ()

  Return coordinate array
  
  *Returns*
      list of doubles
          The coordinates.

* coordinates\ ()

  Return coordinate array (const. version)
  
  *Returns*
      list of doubles
          The coordinates.
";

%feature("docstring")  dolfin::Point::operator+ "
Compute sum of two points
";

%feature("docstring")  dolfin::Point::operator- "
**Overloaded versions**

* operator-\ (p)

  Compute difference of two points

* operator-\ ()

  Unary minus
";

%feature("docstring")  dolfin::Point::operator+= "
Add given point
";

%feature("docstring")  dolfin::Point::operator-= "
Subtract given point
";

%feature("docstring")  dolfin::Point::operator* "
**Overloaded versions**

* operator*\ (a)

  Multiplication with scalar

* operator*\ (a, p)

  Multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator*= "
Incremental multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator/ "
Division by scalar
";

%feature("docstring")  dolfin::Point::operator/= "
Incremental division by scalar
";

%feature("docstring")  dolfin::Point::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Point::squared_distance "
Compute squared distance to given point

*Arguments*
    p (:py:class:`Point`)
        The point to compute distance to.

*Returns*
    float
        The squared distance.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::distance "
Compute distance to given point

*Arguments*
    p (:py:class:`Point`)
        The point to compute distance to.

*Returns*
    float
        The distance.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::norm "
Compute norm of point representing a vector from the origin

*Returns*
    float
        The (Euclidean) norm of the vector from the origin to
        the point.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::squared_norm "
Compute norm of point representing a vector from the origin

*Returns*
    float
        The squared (Euclidean) norm of the vector from the
        origin of the point.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::cross "
Compute cross product with given vector

*Arguments*
    p (:py:class:`Point`)
        Another point.

*Returns*
    Point
        The cross product.
";

%feature("docstring")  dolfin::Point::dot "
Compute dot product with given vector

*Arguments*
    p (:py:class:`Point`)
        Another point.

*Returns*
    float
        The dot product.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::rotate "
Rotate around a given axis

*Arguments*
    a (:py:class:`Point`)
        The axis to rotate around. Must be unit length.
    theta (_double_)
        The rotation angle.

*Returns*
    Point
        The rotated point.
";

%feature("docstring")  dolfin::Point::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=geometry, header=BoundingBoxTree.h)
%feature("docstring")  dolfin::BoundingBoxTree "
This class implements a (distributed) axis aligned bounding box
tree (AABB tree). Bounding box trees can be created from meshes
and [other data structures, to be filled in].
";

%feature("docstring")  dolfin::BoundingBoxTree::BoundingBoxTree "
Create empty bounding box tree
";

%feature("docstring")  dolfin::BoundingBoxTree::build "
**Overloaded versions**

* build\ (mesh)

  Build bounding box tree for cells of mesh.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh for which to compute the bounding box tree.

* build\ (mesh, tdim)

  Build bounding box tree for mesh entities of given dimension.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh for which to compute the bounding box tree.
      dimension (int)
          The entity dimension (topological dimension) for which
          to compute the bounding box tree.

* build\ (points, gdim)

  Build bounding box tree for point cloud.
  
  *Arguments*
      points (list of :py:class:`Point`)
          The list of points.
      gdim (int)
          The geometric dimension.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_collisions "
**Overloaded versions**

* compute_collisions\ (point)

  Compute all collisions between bounding boxes and :py:class:`Point`.
  
  *Returns*
      numpy.array(int)
          A list of local indices for entities contained in
          (leaf) bounding boxes that collide with (intersect)
          the given point.
  
  *Arguments*
      point (:py:class:`Point`)
          The point.

* compute_collisions\ (tree)

  Compute all collisions between bounding boxes and :py:class:`BoundingBoxTree`.
  
  *Returns*
      numpy.array(int)
          A list of local indices for entities in this tree that
          collide with (intersect) entities in other tree.
      std::vector<unsigned int>
          A list of local indices for entities in other tree that
          collide with (intersect) entities in this tree.
  
  The two lists have equal length and contain matching entities,
  such that entity `i` in the first list collides with entity
  `i` in the second list.
  
  Note that this means that the entity lists may contain
  duplicate entities since a single entity may collide with
  several different entities.
  
  *Arguments*
      tree (:py:class:`BoundingBoxTree`)
          The bounding box tree.
  
  Note that this function only checks collisions between bounding
  boxes of entities. It does not check that the entities
  themselves actually collide. To compute entity collisions, use
  the function compute_entity_collisions.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_entity_collisions "
**Overloaded versions**

* compute_entity_collisions\ (point)

  Compute all collisions between entities and :py:class:`Point`.
  
  *Returns*
      numpy.array(int)
          A list of local indices for entities that collide with
          (intersect) the given point.
  
  *Arguments*
      point (:py:class:`Point`)
          The point.

* compute_entity_collisions\ (tree)

  Compute all collisions between entities and :py:class:`BoundingBoxTree`.
  
  *Returns*
      numpy.array(int)
          A list of local indices for entities in this tree that
          collide with (intersect) entities in other tree.
      std::vector<unsigned int>
          A list of local indices for entities in other tree that
          collide with (intersect) entities in this tree.
  
  The two lists have equal length and contain matching entities,
  such that entity `i` in the first list collides with entity
  `i` in the second list.
  
  Note that this means that the entity lists may contain
  duplicate entities since a single entity may collide with
  several different entities.
  
  *Arguments*
      tree (:py:class:`BoundingBoxTree`)
          The bounding box tree.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_process_collisions "
Compute all collisions between process bounding boxes
and :py:class:`Point`. Effectively a list of processes which may
contain the :py:class:`Point`.

*Returns*
    numpy.array(int)
        A list of process numbers where the :py:class:`Mesh`
        may collide with (intersect) the given point.

*Arguments*
    point (:py:class:`Point`)
        The point.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_first_collision "
Compute first collision between bounding boxes and :py:class:`Point`.

*Returns*
    int
        The local index for the first found entity contained
        in a (leaf) bounding box that collides with
        (intersects) the given point. If not found,
        std::numeric_limits<unsigned int>::max() is returned.

*Arguments*
    point (:py:class:`Point`)
        The point.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_first_entity_collision "
Compute first collision between entities and :py:class:`Point`.

*Returns*
    int
        The local index for the first found entity that
        collides with (intersects) the given point. If not
        found, std::numeric_limits<unsigned int>::max() is
        returned.

*Arguments*
    point (:py:class:`Point`)
        The point.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_closest_entity "
Compute closest entity to :py:class:`Point`.

*Returns*
    int
        The local index for the entity that is closest to the
        point. If more than one entity is at the same distance
        (or point contained in entity), then the first entity
        is returned.
    double
        The distance to the closest entity.

*Arguments*
    point (:py:class:`Point`)
        The point.
";

%feature("docstring")  dolfin::BoundingBoxTree::compute_closest_point "
Compute closest point to :py:class:`Point`. This function assumes
that the tree has been built for a point cloud.

Developer note: This function should not be confused with
computing the closest point in all entities of a mesh. That
function could be added with relative ease since we actually
compute the closest points to get the distance in the above
function (compute_closest_entity) inside the specialized
implementations in TetrahedronCell.cpp etc.

*Returns*
    int
        The local index for the point that is closest to the
        point. If more than one point is at the same distance
        (or point contained in entity), then the first point
        is returned.
    double
        The distance to the closest point.

*Arguments*
    point (:py:class:`Point`)
        The point.
";

%feature("docstring")  dolfin::BoundingBoxTree::collides "
Check whether given point collides with the bounding box tree.
This is equivalent to calling compute_first_collision and
checking whether any collision was detected.

*Returns*
    bool
        True iff the point is inside the tree.
";

%feature("docstring")  dolfin::BoundingBoxTree::collides_entity "
Check whether given point collides with any entity contained
in the bounding box tree. This is equivalent to calling
compute_first_entity_collision and checking whether any
collision was detected.

*Returns*
    bool
        True iff the point is inside the tree.
";

// Documentation extracted from: (module=geometry, header=GenericBoundingBoxTree.h)
%feature("docstring")  dolfin::GenericBoundingBoxTree "
Base class for bounding box implementations (envelope-letter
design)
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::GenericBoundingBoxTree "
Constructor
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::create "
Factory function returning (empty) tree of appropriate dimension
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::build "
**Overloaded versions**

* build\ (mesh, tdim)

  Build bounding box tree for mesh entities of given dimension

* build\ (points)

  Build bounding box tree for point cloud
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_collisions "
**Overloaded versions**

* compute_collisions\ (point)

  Compute all collisions between bounding boxes and :py:class:`Point`

* compute_collisions\ (tree)

  Compute all collisions between bounding boxes and :py:class:`BoundingBoxTree`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_entity_collisions "
**Overloaded versions**

* compute_entity_collisions\ (point, mesh)

  Compute all collisions between entities and :py:class:`Point`

* compute_entity_collisions\ (tree, mesh_A, mesh_B)

  Compute all collisions between entities and :py:class:`BoundingBoxTree`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_process_collisions "
Compute all collisions between processes and :py:class:`Point`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_first_collision "
Compute first collision between bounding boxes and :py:class:`Point`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_first_entity_collision "
Compute first collision between entities and :py:class:`Point`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_closest_entity "
Compute closest entity and distance to :py:class:`Point`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::compute_closest_point "
Compute closest point and distance to :py:class:`Point`
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::str "
Print out for debugging
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::_compute_collisions "
**Overloaded versions**

* _compute_collisions\ (tree, point, node, entities, mesh)

  Compute collisions with point (recursive)

* _compute_collisions\ (A, B, node_A, node_B, entities_A, entities_B, mesh_A, mesh_B)

  Compute collisions with tree (recursive)
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::_compute_first_collision "
Compute first collision (recursive)
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::_compute_first_entity_collision "
Compute first entity collision (recursive)
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::_compute_closest_entity "
Compute closest entity (recursive)
";

%feature("docstring")  dolfin::GenericBoundingBoxTree::_compute_closest_point "
Compute closest point (recursive)
";

// Documentation extracted from: (module=geometry, header=BoundingBoxTree3D.h)
// Documentation extracted from: (module=geometry, header=MeshPointIntersection.h)
%feature("docstring")  dolfin::MeshPointIntersection "
This class represents an intersection between a :py:class:`Mesh` and a
:py:class:`Point`. The resulting intersection is stored as a list of zero
or more cells.
";

%feature("docstring")  dolfin::MeshPointIntersection::MeshPointIntersection "
Compute intersection between mesh and point
";

%feature("docstring")  dolfin::MeshPointIntersection::intersected_cells "
Return the list of (local) indices for intersected cells
";

// Documentation extracted from: (module=geometry, header=intersect.h)
%feature("docstring")  dolfin::intersect "
Compute and return intersection between :py:class:`Mesh` and :py:class:`Point`.

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh to be intersected.
    point (:py:class:`Point`)
        The point to be intersected.

*Returns*
    :py:class:`MeshPointIntersection`
        The intersection data.
";

