// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          True

#include "CahnHilliard3D.h"

cahnhilliard3d_finite_element_0::cahnhilliard3d_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_0::~cahnhilliard3d_finite_element_0()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', tetrahedron, 1)";
}

ufc::shape cahnhilliard3d_finite_element_0::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_0::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_0::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_0::space_dimension() const
{
    return 4;
}

std::size_t cahnhilliard3d_finite_element_0::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_0::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_0::family() const
{
    return "Lagrange";
}

void cahnhilliard3d_finite_element_0::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_0::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
}

void cahnhilliard3d_finite_element_0::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

void cahnhilliard3d_finite_element_0::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_0::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_0::create() const
{
    return new cahnhilliard3d_finite_element_0();
}


cahnhilliard3d_finite_element_1::cahnhilliard3d_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_1::~cahnhilliard3d_finite_element_1()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_1::signature() const
{
    return "VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
}

ufc::shape cahnhilliard3d_finite_element_1::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_1::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::space_dimension() const
{
    return 12;
}

std::size_t cahnhilliard3d_finite_element_1::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_1::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_1::value_size() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_1::reference_value_size() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_1::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_1::family() const
{
    return "Lagrange";
}

void cahnhilliard3d_finite_element_1::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_1::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_1::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_1::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
}

void cahnhilliard3d_finite_element_1::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
}

void cahnhilliard3d_finite_element_1::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
    dof_coordinates[24] = coordinate_dofs[0];
    dof_coordinates[25] = coordinate_dofs[1];
    dof_coordinates[26] = coordinate_dofs[2];
    dof_coordinates[27] = coordinate_dofs[3];
    dof_coordinates[28] = coordinate_dofs[4];
    dof_coordinates[29] = coordinate_dofs[5];
    dof_coordinates[30] = coordinate_dofs[6];
    dof_coordinates[31] = coordinate_dofs[7];
    dof_coordinates[32] = coordinate_dofs[8];
    dof_coordinates[33] = coordinate_dofs[9];
    dof_coordinates[34] = coordinate_dofs[10];
    dof_coordinates[35] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_1::num_sub_elements() const
{
    return 3;
}

ufc::finite_element * cahnhilliard3d_finite_element_1::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_1::create() const
{
    return new cahnhilliard3d_finite_element_1();
}


cahnhilliard3d_finite_element_2::cahnhilliard3d_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_2::~cahnhilliard3d_finite_element_2()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_2::signature() const
{
    return "MixedElement(FiniteElement('Lagrange', tetrahedron, 1), FiniteElement('Lagrange', tetrahedron, 1))";
}

ufc::shape cahnhilliard3d_finite_element_2::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_2::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_2::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_2::space_dimension() const
{
    return 8;
}

std::size_t cahnhilliard3d_finite_element_2::value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_2::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_2::value_size() const
{
    return 2;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_finite_element_2::reference_value_size() const
{
    return 2;
}

std::size_t cahnhilliard3d_finite_element_2::degree() const
{
    return 1;
}

const char * cahnhilliard3d_finite_element_2::family() const
{
    return "Mixed";
}

void cahnhilliard3d_finite_element_2::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
}

void cahnhilliard3d_finite_element_2::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 8; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[6];
    for (unsigned int r = 0; r < 6; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 8; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double cahnhilliard3d_finite_element_2::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_2::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
}

void cahnhilliard3d_finite_element_2::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    vertex_values[6] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[3] = dof_values[5];
    vertex_values[5] = dof_values[6];
    vertex_values[7] = dof_values[7];
}

void cahnhilliard3d_finite_element_2::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_2::num_sub_elements() const
{
    return 2;
}

ufc::finite_element * cahnhilliard3d_finite_element_2::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_2::create() const
{
    return new cahnhilliard3d_finite_element_2();
}


cahnhilliard3d_finite_element_3::cahnhilliard3d_finite_element_3() : ufc::finite_element()
{
    // Do nothing
}

cahnhilliard3d_finite_element_3::~cahnhilliard3d_finite_element_3()
{
    // Do nothing
}

const char * cahnhilliard3d_finite_element_3::signature() const
{
    return "FiniteElement('Real', tetrahedron, 0)";
}

ufc::shape cahnhilliard3d_finite_element_3::cell_shape() const
{
    return ufc::shape::tetrahedron;
}

std::size_t cahnhilliard3d_finite_element_3::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_3::geometric_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_finite_element_3::space_dimension() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_3::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_rank() const
{
    return 0;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::reference_value_size() const
{
    return 1;
}

std::size_t cahnhilliard3d_finite_element_3::degree() const
{
    return 0;
}

const char * cahnhilliard3d_finite_element_3::family() const
{
    return "Real";
}

void cahnhilliard3d_finite_element_3::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
}

void cahnhilliard3d_finite_element_3::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
}

double cahnhilliard3d_finite_element_3::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
      y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
      y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void cahnhilliard3d_finite_element_3::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    y[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    y[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
}

void cahnhilliard3d_finite_element_3::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
}

void cahnhilliard3d_finite_element_3::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = 0.25*coordinate_dofs[0] + 0.25*coordinate_dofs[3] + 0.25*coordinate_dofs[6] + 0.25*coordinate_dofs[9];
    dof_coordinates[1] = 0.25*coordinate_dofs[1] + 0.25*coordinate_dofs[4] + 0.25*coordinate_dofs[7] + 0.25*coordinate_dofs[10];
    dof_coordinates[2] = 0.25*coordinate_dofs[2] + 0.25*coordinate_dofs[5] + 0.25*coordinate_dofs[8] + 0.25*coordinate_dofs[11];
}

std::size_t cahnhilliard3d_finite_element_3::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_3::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * cahnhilliard3d_finite_element_3::create() const
{
    return new cahnhilliard3d_finite_element_3();
}


cahnhilliard3d_dofmap_0::cahnhilliard3d_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_0::~cahnhilliard3d_dofmap_0()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 1)";
}

bool cahnhilliard3d_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_0::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_0::num_element_dofs() const
{
    return 4;
}

std::size_t cahnhilliard3d_dofmap_0::num_facet_dofs() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_0::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
    dofs[3] = entity_indices[0][3];
}

void cahnhilliard3d_dofmap_0::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_0::tabulate_entity_dofs(std::size_t * dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_0::create() const
{
    return new cahnhilliard3d_dofmap_0();
}


cahnhilliard3d_dofmap_1::cahnhilliard3d_dofmap_1() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_1::~cahnhilliard3d_dofmap_1()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_1::signature() const
{
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
}

bool cahnhilliard3d_dofmap_1::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_1::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_1::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 3*num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_1::num_element_dofs() const
{
    return 12;
}

std::size_t cahnhilliard3d_dofmap_1::num_facet_dofs() const
{
    return 9;
}

std::size_t cahnhilliard3d_dofmap_1::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_1::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + entity_indices[0][0];
    dofs[9] = offset + entity_indices[0][1];
    dofs[10] = offset + entity_indices[0][2];
    dofs[11] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
}

void cahnhilliard3d_dofmap_1::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_1::tabulate_entity_dofs(std::size_t * dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_1::num_sub_dofmaps() const
{
    return 3;
}

ufc::dofmap * cahnhilliard3d_dofmap_1::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_1::create() const
{
    return new cahnhilliard3d_dofmap_1();
}


cahnhilliard3d_dofmap_2::cahnhilliard3d_dofmap_2() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_2::~cahnhilliard3d_dofmap_2()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_2::signature() const
{
    return "FFC dofmap for MixedElement(FiniteElement('Lagrange', tetrahedron, 1), FiniteElement('Lagrange', tetrahedron, 1))";
}

bool cahnhilliard3d_dofmap_2::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_2::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_2::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

std::size_t cahnhilliard3d_dofmap_2::num_element_dofs() const
{
    return 8;
}

std::size_t cahnhilliard3d_dofmap_2::num_facet_dofs() const
{
    return 6;
}

std::size_t cahnhilliard3d_dofmap_2::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_2::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
}

void cahnhilliard3d_dofmap_2::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_2::tabulate_entity_dofs(std::size_t * dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_2::num_sub_dofmaps() const
{
    return 2;
}

ufc::dofmap * cahnhilliard3d_dofmap_2::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_2::create() const
{
    return new cahnhilliard3d_dofmap_2();
}


cahnhilliard3d_dofmap_3::cahnhilliard3d_dofmap_3() : ufc::dofmap()
{
    // Do nothing
}

cahnhilliard3d_dofmap_3::~cahnhilliard3d_dofmap_3()
{
    // Do nothing
}

const char * cahnhilliard3d_dofmap_3::signature() const
{
    return "FFC dofmap for FiniteElement('Real', tetrahedron, 0)";
}

bool cahnhilliard3d_dofmap_3::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t cahnhilliard3d_dofmap_3::topological_dimension() const
{
    return 3;
}

std::size_t cahnhilliard3d_dofmap_3::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 1;
}

std::size_t cahnhilliard3d_dofmap_3::num_element_dofs() const
{
    return 1;
}

std::size_t cahnhilliard3d_dofmap_3::num_facet_dofs() const
{
    return 0;
}

std::size_t cahnhilliard3d_dofmap_3::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

void cahnhilliard3d_dofmap_3::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = 0;
}

void cahnhilliard3d_dofmap_3::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

void cahnhilliard3d_dofmap_3::tabulate_entity_dofs(std::size_t * dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

std::size_t cahnhilliard3d_dofmap_3::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_3::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * cahnhilliard3d_dofmap_3::create() const
{
    return new cahnhilliard3d_dofmap_3();
}


cahnhilliard3d_cell_integral_0_otherwise::cahnhilliard3d_cell_integral_0_otherwise() : ufc::cell_integral()
{
    
}

cahnhilliard3d_cell_integral_0_otherwise::~cahnhilliard3d_cell_integral_0_otherwise()
{
    
}

const std::vector<bool> & cahnhilliard3d_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true, true, true, true, true});
    return enabled;
}

void cahnhilliard3d_cell_integral_0_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651};
    // Quadrature points on the UFC reference element: (0.0, 0.5, 0.5), (0.5, 0.0, 0.5), (0.5, 0.5, 0.0), (0.5, 0.0, 0.0), (0.0, 0.5, 0.0), (0.0, 0.0, 0.5), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.0568813795204234, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.0568813795204234), (0.314372873493192, 0.0568813795204234, 0.314372873493192)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0[14][4] = \
    {{0.0, 0.0, 0.5, 0.5},
    {0.0, 0.5, 0.0, 0.5},
    {0.0, 0.5, 0.5, 0.0},
    {0.5, 0.5, 0.0, 0.0},
    {0.5, 0.0, 0.5, 0.0},
    {0.5, 0.0, 0.0, 0.5},
    {0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192},
    {0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234},
    {0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    static const double FE0_C0_D001[14][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 8; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 177.
    double G[21];
    G[0] = det*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8] - w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[1] = det*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8] - w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[2] = det*w[3][0]*w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[3] = det*w[3][0]*w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[4] = det*w[3][0]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[5] = det*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8] - w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[6] = det*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5] - w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[7] = det*w[3][0]*w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[8] = det*w[3][0]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[9] = det*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5] - w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[10] = det*w[3][0]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[11] = det*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2] - w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[12] =  - det*w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[13] =  - det*w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[14] =  - det*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[15] =  - det*w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[16] =  - det*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[17] =  - det*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[18] = -400.0*det;
    G[19] = 600.0*det;
    G[20] = -200.0*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2310
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      
      // Total number of operations to compute function values = 36
      for (unsigned int r = 0; r < 2; r++)
      {
        F3 += FE0_C0_D001[ip][r]*w[0][nzc3[r]];
        F4 += FE0_C0_D001[ip][r]*w[0][nzc2[r]];
        F5 += FE0_C0_D001[ip][r]*w[0][nzc1[r]];
        F6 += FE0_C0_D001[ip][r]*w[0][nzc7[r]];
        F7 += FE0_C0_D001[ip][r]*w[0][nzc6[r]];
        F8 += FE0_C0_D001[ip][r]*w[0][nzc5[r]];
        F9 += FE0_C0_D001[ip][r]*w[1][nzc7[r]];
        F10 += FE0_C0_D001[ip][r]*w[1][nzc6[r]];
        F11 += FE0_C0_D001[ip][r]*w[1][nzc5[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 24
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE0_C0[ip][r]*w[0][nzc4[r]];
        F1 += FE0_C0[ip][r]*w[0][nzc0[r]];
        F2 += FE0_C0[ip][r]*w[1][nzc0[r]];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 65
      double I[8];
      // Number of operations: 12
      I[0] = W14[ip]*(F10*G[0] + F11*G[1] + F6*G[2] + F7*G[3] + F8*G[4] + F9*G[5]);
      
      // Number of operations: 12
      I[1] = W14[ip]*(F10*G[6] + F11*G[0] + F6*G[7] + F7*G[8] + F8*G[3] + F9*G[9]);
      
      // Number of operations: 12
      I[2] = W14[ip]*(F10*G[9] + F11*G[5] + F6*G[10] + F7*G[7] + F8*G[2] + F9*G[11]);
      
      // Number of operations: 6
      I[3] = W14[ip]*(F3*G[12] + F4*G[13] + F5*G[14]);
      
      // Number of operations: 6
      I[4] = W14[ip]*(F3*G[15] + F4*G[16] + F5*G[13]);
      
      // Number of operations: 6
      I[5] = W14[ip]*(F3*G[17] + F4*G[15] + F5*G[12]);
      
      // Number of operations: 3
      I[6] = W14[ip]*det*(F1 - F2);
      
      // Number of operations: 8
      I[7] = W14[ip]*(F0*det + F1*(G[20] + F1*(G[19] + F1*G[18])));
      
      
      // Number of operations for primary indices: 24
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE0_C0_D001[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc2[j]] += FE0_C0_D001[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc3[j]] += FE0_C0_D001[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc5[j]] += FE0_C0_D001[ip][j]*I[3];
        // Number of operations to compute entry: 2
        A[nzc6[j]] += FE0_C0_D001[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc7[j]] += FE0_C0_D001[ip][j]*I[5];
      } // end loop over 'j'
      
      // Number of operations for primary indices: 16
      for (unsigned int j = 0; j < 4; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE0_C0[ip][j]*I[6];
        // Number of operations to compute entry: 2
        A[nzc4[j]] += FE0_C0[ip][j]*I[7];
      } // end loop over 'j'
    } // end loop over 'ip'
}


cahnhilliard3d_cell_integral_1_otherwise::cahnhilliard3d_cell_integral_1_otherwise() : ufc::cell_integral()
{
    
}

cahnhilliard3d_cell_integral_1_otherwise::~cahnhilliard3d_cell_integral_1_otherwise()
{
    
}

const std::vector<bool> & cahnhilliard3d_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true, true, true, true});
    return enabled;
}

void cahnhilliard3d_cell_integral_1_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.00317460317460317, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0147649707904968, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651, 0.0221397911142651};
    // Quadrature points on the UFC reference element: (0.0, 0.5, 0.5), (0.5, 0.0, 0.5), (0.5, 0.5, 0.0), (0.5, 0.0, 0.0), (0.0, 0.5, 0.0), (0.0, 0.0, 0.5), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.0568813795204234, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.0568813795204234), (0.314372873493192, 0.0568813795204234, 0.314372873493192)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0[14][4] = \
    {{0.0, 0.0, 0.5, 0.5},
    {0.0, 0.5, 0.0, 0.5},
    {0.0, 0.5, 0.5, 0.0},
    {0.5, 0.5, 0.0, 0.0},
    {0.5, 0.0, 0.5, 0.0},
    {0.5, 0.0, 0.0, 0.5},
    {0.100526765225205, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324387, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225205, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225205, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.0568813795204234, 0.314372873493192, 0.314372873493192},
    {0.0568813795204235, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.0568813795204234},
    {0.314372873493192, 0.314372873493192, 0.0568813795204235, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    static const double FE0_C0_D001[14][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 64; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 93.
    double G[15];
    G[0] = det*w[2][0]*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[1] = det*w[2][0]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[2] = det*w[2][0]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[3] = det*w[2][0]*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[4] = det*w[2][0]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[5] = det*w[2][0]*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[6] =  - det*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]);
    G[7] =  - det*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]);
    G[8] =  - det*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]);
    G[9] =  - det*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]);
    G[10] =  - det*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]);
    G[11] =  - det*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]);
    G[12] = -200.0*det;
    G[13] = -1200.0*det;
    G[14] = 1200.0*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 5404
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE0_C0[ip][r]*w[0][nzc0[r]];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 18
      double I[14];
      // Number of operations: 1
      I[0] = G[0]*W14[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W14[ip];
      
      // Number of operations: 1
      I[2] = G[2]*W14[ip];
      
      // Number of operations: 1
      I[3] = G[3]*W14[ip];
      
      // Number of operations: 1
      I[4] = G[4]*W14[ip];
      
      // Number of operations: 1
      I[5] = G[5]*W14[ip];
      
      // Number of operations: 1
      I[6] = G[6]*W14[ip];
      
      // Number of operations: 1
      I[7] = G[7]*W14[ip];
      
      // Number of operations: 1
      I[8] = G[8]*W14[ip];
      
      // Number of operations: 1
      I[9] = G[9]*W14[ip];
      
      // Number of operations: 1
      I[10] = G[10]*W14[ip];
      
      // Number of operations: 1
      I[11] = G[11]*W14[ip];
      
      // Number of operations: 1
      I[12] = W14[ip]*det;
      
      // Number of operations: 5
      I[13] = W14[ip]*(G[12] + F0*(G[14] + F0*G[13]));
      
      
      // Number of operations for primary indices: 216
      for (unsigned int j = 0; j < 2; j++)
      {
        for (unsigned int k = 0; k < 2; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc5[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[0];
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc6[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc7[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc5[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc6[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[3];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc7[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc5[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc6[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc7[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc1[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[6];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc2[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc3[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc1[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc2[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[9];
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc3[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc1[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc2[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc3[k]] += FE0_C0_D001[ip][j]*FE0_C0_D001[ip][k]*I[11];
        } // end loop over 'k'
      } // end loop over 'j'
      
      // Number of operations for primary indices: 144
      for (unsigned int j = 0; j < 4; j++)
      {
        for (unsigned int k = 0; k < 4; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc0[j]*8 + nzc0[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[12];
          // Number of operations to compute entry: 3
          A[nzc4[j]*8 + nzc0[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[13];
          // Number of operations to compute entry: 3
          A[nzc4[j]*8 + nzc4[k]] += FE0_C0[ip][j]*FE0_C0[ip][k]*I[12];
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
}


cahnhilliard3d_form_0::cahnhilliard3d_form_0() : ufc::form()
{
    // Do nothing
}

cahnhilliard3d_form_0::~cahnhilliard3d_form_0()
{
    // Do nothing
}

const char * cahnhilliard3d_form_0::signature() const
{
    return "d5150d94b3bd09e6ceca9d09afda39e2119a6cb6547ac85205009ca1a593b6fa005a5f402fb19b3374ef1a0dc3c4b03161cd7326b42add38c0d4ee80ec920308";
}

std::size_t cahnhilliard3d_form_0::rank() const
{
    return 1;
}

std::size_t cahnhilliard3d_form_0::num_coefficients() const
{
    return 5;
}

std::size_t cahnhilliard3d_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard3d_form_0::create_coordinate_finite_element() const
{
    return new cahnhilliard3d_finite_element_1();
}

ufc::dofmap * cahnhilliard3d_form_0::create_coordinate_dofmap() const
{
    return new cahnhilliard3d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard3d_form_0::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard3d_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_0::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard3d_form_0::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard3d_form_0::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_0::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard3d_form_0::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard3d_form_0::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_0::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_0::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_0::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_0::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_0::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_0::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard3d_form_0::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_0_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard3d_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_0::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_0::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_0::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_0::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_0::create_default_overlap_integral() const
{
    return 0;
}


cahnhilliard3d_form_1::cahnhilliard3d_form_1() : ufc::form()
{
    // Do nothing
}

cahnhilliard3d_form_1::~cahnhilliard3d_form_1()
{
    // Do nothing
}

const char * cahnhilliard3d_form_1::signature() const
{
    return "de362a73f656f9a69f43f8ea0ac2637021186cefce4f5df9cdea5cf77244d9d3d7e3d75c3ccea2ab95617742c41b0ec432c2935ce380d50bc73ff73f86e77398";
}

std::size_t cahnhilliard3d_form_1::rank() const
{
    return 2;
}

std::size_t cahnhilliard3d_form_1::num_coefficients() const
{
    return 4;
}

std::size_t cahnhilliard3d_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0, 2, 3, 4});
    return position[i];
}

ufc::finite_element * cahnhilliard3d_form_1::create_coordinate_finite_element() const
{
    return new cahnhilliard3d_finite_element_1();
}

ufc::dofmap * cahnhilliard3d_form_1::create_coordinate_dofmap() const
{
    return new cahnhilliard3d_dofmap_1();
}

ufc::coordinate_mapping * cahnhilliard3d_form_1::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * cahnhilliard3d_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_3();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * cahnhilliard3d_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_3();
        break;
      }
    }
    
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t cahnhilliard3d_form_1::max_overlap_subdomain_id() const
{
    return 0;
}

bool cahnhilliard3d_form_1::has_cell_integrals() const
{
    return true;
}

bool cahnhilliard3d_form_1::has_exterior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_interior_facet_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_vertex_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_custom_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_cutcell_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_interface_integrals() const
{
    return false;
}

bool cahnhilliard3d_form_1::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * cahnhilliard3d_form_1::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * cahnhilliard3d_form_1::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_1::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_1::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_1::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_1::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_1::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_1::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * cahnhilliard3d_form_1::create_default_cell_integral() const
{
    return new cahnhilliard3d_cell_integral_1_otherwise();
}

ufc::exterior_facet_integral * cahnhilliard3d_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * cahnhilliard3d_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * cahnhilliard3d_form_1::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * cahnhilliard3d_form_1::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * cahnhilliard3d_form_1::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * cahnhilliard3d_form_1::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * cahnhilliard3d_form_1::create_default_overlap_integral() const
{
    return 0;
}

