// This code conforms with the UFC specification version 1.5.0
// and was automatically generated by FFC version 1.5.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no-evaluate_basis:              True
//   no-evaluate_basis_derivatives:  True
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          True

#include "Poisson2D_5.h"

/// Constructor
poisson2d_5_finite_element_0::poisson2d_5_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
poisson2d_5_finite_element_0::~poisson2d_5_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* poisson2d_5_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', Domain(Cell('triangle', 2)), 5, None)";
}

/// Return the cell shape
ufc::shape poisson2d_5_finite_element_0::cell_shape() const
{
    return ufc::triangle;
}

/// Return the topological dimension of the cell shape
std::size_t poisson2d_5_finite_element_0::topological_dimension() const
{
    return 2;
}

/// Return the geometric dimension of the cell shape
std::size_t poisson2d_5_finite_element_0::geometric_dimension() const
{
    return 2;
}

/// Return the dimension of the finite element function space
std::size_t poisson2d_5_finite_element_0::space_dimension() const
{
    return 21;
}

/// Return the rank of the value space
std::size_t poisson2d_5_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
std::size_t poisson2d_5_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

/// Evaluate basis function i at given point x in cell
void poisson2d_5_finite_element_0::_evaluate_basis(std::size_t i,
                                    double* values,
                                    const double* x,
                                    const double* vertex_coordinates,
                                    int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis not generated (compiled with -fno-evaluate_basis)");
}

/// Evaluate all basis functions at given point x in cell
void poisson2d_5_finite_element_0::_evaluate_basis_all(double* values,
                                        const double* x,
                                        const double* vertex_coordinates,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 21; r++)
    {
      _evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point x in cell
void poisson2d_5_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double* values,
                                                const double* x,
                                                const double* vertex_coordinates,
                                                int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis_derivatives not generated (compiled with -fno-evaluate_basis_derivatives)");
}

/// Evaluate order n derivatives of all basis functions at given point x in cell
void poisson2d_5_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double* values,
                                                    const double* x,
                                                    const double* vertex_coordinates,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 21; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 5)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[32];
    for (unsigned int r = 0; r < 32; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 21; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

/// Evaluate linear functional for dof i on the function f
double poisson2d_5_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double* vertex_coordinates,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[2];
      y[1] = vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[4];
      y[1] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
      y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
      y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
      y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
      y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
      y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
      y[1] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

/// Evaluate linear functionals for all dofs on the function f
void poisson2d_5_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const double* vertex_coordinates,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[2];
    y[1] = vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[4];
    y[1] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
    y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
    y[1] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
    y[1] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
    y[1] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
    y[1] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    y[1] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
}

/// Interpolate vertex values from dof values
void poisson2d_5_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const double* vertex_coordinates,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void poisson2d_5_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void poisson2d_5_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
}

/// Return the number of sub elements (for a mixed element)
std::size_t poisson2d_5_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* poisson2d_5_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* poisson2d_5_finite_element_0::create() const
{
    return new poisson2d_5_finite_element_0();
}

/// Constructor
poisson2d_5_dofmap_0::poisson2d_5_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

/// Destructor
poisson2d_5_dofmap_0::~poisson2d_5_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* poisson2d_5_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('triangle', 2)), 5, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool poisson2d_5_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
}

/// Return the topological dimension of the associated cell shape
std::size_t poisson2d_5_dofmap_0::topological_dimension() const
{
    return 2;
}

/// Return the geometric dimension of the associated cell shape
std::size_t poisson2d_5_dofmap_0::geometric_dimension() const
{
    return 2;
}

/// Return the dimension of the global finite element function space
std::size_t poisson2d_5_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0] + 4*num_global_entities[1] + 6*num_global_entities[2];
}

/// Return the dimension of the local finite element function space for a cell
std::size_t poisson2d_5_dofmap_0::local_dimension() const
{
    return 21;
}

/// Return the number of dofs on each cell facet
std::size_t poisson2d_5_dofmap_0::num_facet_dofs() const
{
    return 6;
}

/// Return the number of dofs associated with each cell entity of dimension d
std::size_t poisson2d_5_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void poisson2d_5_dofmap_0::tabulate_dofs(std::size_t* dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + 4*c.entity_indices[1][0];
    dofs[4] = offset + 4*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 4*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 4*c.entity_indices[1][0] + 3;
    dofs[7] = offset + 4*c.entity_indices[1][1];
    dofs[8] = offset + 4*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 4*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 4*c.entity_indices[1][1] + 3;
    dofs[11] = offset + 4*c.entity_indices[1][2];
    dofs[12] = offset + 4*c.entity_indices[1][2] + 1;
    dofs[13] = offset + 4*c.entity_indices[1][2] + 2;
    dofs[14] = offset + 4*c.entity_indices[1][2] + 3;
    offset += 4*num_global_entities[1];
    dofs[15] = offset + 6*c.entity_indices[2][0];
    dofs[16] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[17] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[18] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[19] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[20] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*num_global_entities[2];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void poisson2d_5_dofmap_0::tabulate_facet_dofs(std::size_t* dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void poisson2d_5_dofmap_0::tabulate_entity_dofs(std::size_t* dofs,
                                  std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
        dofs[3] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 11;
        dofs[1] = 12;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 15;
      dofs[1] = 16;
      dofs[2] = 17;
      dofs[3] = 18;
      dofs[4] = 19;
      dofs[5] = 20;
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void poisson2d_5_dofmap_0::tabulate_coordinates(double* dof_coordinates,
                                         const double* vertex_coordinates) const
{
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = 0.8*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[7] = 0.8*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[8] = 0.6*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[9] = 0.6*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[10] = 0.4*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    dof_coordinates[11] = 0.4*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
    dof_coordinates[12] = 0.2*vertex_coordinates[2] + 0.8*vertex_coordinates[4];
    dof_coordinates[13] = 0.2*vertex_coordinates[3] + 0.8*vertex_coordinates[5];
    dof_coordinates[14] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[4];
    dof_coordinates[15] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[5];
    dof_coordinates[16] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[4];
    dof_coordinates[17] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[5];
    dof_coordinates[18] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[4];
    dof_coordinates[19] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[5];
    dof_coordinates[20] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[4];
    dof_coordinates[21] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[5];
    dof_coordinates[22] = 0.8*vertex_coordinates[0] + 0.2*vertex_coordinates[2];
    dof_coordinates[23] = 0.8*vertex_coordinates[1] + 0.2*vertex_coordinates[3];
    dof_coordinates[24] = 0.6*vertex_coordinates[0] + 0.4*vertex_coordinates[2];
    dof_coordinates[25] = 0.6*vertex_coordinates[1] + 0.4*vertex_coordinates[3];
    dof_coordinates[26] = 0.4*vertex_coordinates[0] + 0.6*vertex_coordinates[2];
    dof_coordinates[27] = 0.4*vertex_coordinates[1] + 0.6*vertex_coordinates[3];
    dof_coordinates[28] = 0.2*vertex_coordinates[0] + 0.8*vertex_coordinates[2];
    dof_coordinates[29] = 0.2*vertex_coordinates[1] + 0.8*vertex_coordinates[3];
    dof_coordinates[30] = 0.6*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[31] = 0.6*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[32] = 0.4*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[33] = 0.4*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[34] = 0.2*vertex_coordinates[0] + 0.6*vertex_coordinates[2] + 0.2*vertex_coordinates[4];
    dof_coordinates[35] = 0.2*vertex_coordinates[1] + 0.6*vertex_coordinates[3] + 0.2*vertex_coordinates[5];
    dof_coordinates[36] = 0.4*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[37] = 0.4*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[38] = 0.2*vertex_coordinates[0] + 0.4*vertex_coordinates[2] + 0.4*vertex_coordinates[4];
    dof_coordinates[39] = 0.2*vertex_coordinates[1] + 0.4*vertex_coordinates[3] + 0.4*vertex_coordinates[5];
    dof_coordinates[40] = 0.2*vertex_coordinates[0] + 0.2*vertex_coordinates[2] + 0.6*vertex_coordinates[4];
    dof_coordinates[41] = 0.2*vertex_coordinates[1] + 0.2*vertex_coordinates[3] + 0.6*vertex_coordinates[5];
}

/// Return the number of sub dofmaps (for a mixed element)
std::size_t poisson2d_5_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* poisson2d_5_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* poisson2d_5_dofmap_0::create() const
{
    return new poisson2d_5_dofmap_0();
}

/// Constructor
poisson2d_5_cell_integral_0_otherwise::poisson2d_5_cell_integral_0_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson2d_5_cell_integral_0_otherwise::~poisson2d_5_cell_integral_0_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson2d_5_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson2d_5_cell_integral_0_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 1279
    // Total number of operations (multiply-add pairs):                  1290
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.342406580687831*G0_0_0 + 0.342406580687831*G0_0_1 + 0.342406580687831*G0_1_0 + 0.342406580687832*G0_1_1;
    A[1] = -0.040998401675484*G0_0_0 - 0.040998401675485*G0_1_0;
    A[2] = -0.0409984016754854*G0_0_1 - 0.0409984016754857*G0_1_1;
    A[3] = -0.0408192791005274*G0_0_0 - 0.0408192791005283*G0_0_1 - 0.0408192791005292*G0_1_0 - 0.0408192791005313*G0_1_1;
    A[4] = -0.0379774305555551*G0_0_0 - 0.0379774305555533*G0_0_1 - 0.0379774305555548*G0_1_0 - 0.0379774305555521*G0_1_1;
    A[5] = -0.037977430555553*G0_0_0 - 0.0379774305555554*G0_0_1 - 0.0379774305555531*G0_1_0 - 0.0379774305555562*G0_1_1;
    A[6] = -0.0408192791005294*G0_0_0 - 0.0408192791005275*G0_0_1 - 0.0408192791005305*G0_1_0 - 0.0408192791005281*G0_1_1;
    A[7] = 0.202287946428573*G0_0_0 - 0.648027584876543*G0_0_1 + 0.202287946428573*G0_1_0 - 0.648027584876542*G0_1_1;
    A[8] = -0.015845458553794*G0_0_0 + 0.594204695767193*G0_0_1 - 0.0158454585537929*G0_1_0 + 0.594204695767193*G0_1_1;
    A[9] = -0.0696683476631372*G0_0_0 - 0.449959352954142*G0_0_1 - 0.0696683476631374*G0_1_0 - 0.449959352954142*G0_1_1;
    A[10] = 0.0408192791005293*G0_0_0 + 0.202374063051146*G0_0_1 + 0.0408192791005304*G0_1_0 + 0.202374063051146*G0_1_1;
    A[11] = -0.648027584876542*G0_0_0 + 0.202287946428573*G0_0_1 - 0.648027584876544*G0_1_0 + 0.202287946428572*G0_1_1;
    A[12] = 0.594204695767194*G0_0_0 - 0.0158454585537928*G0_0_1 + 0.594204695767195*G0_1_0 - 0.0158454585537928*G0_1_1;
    A[13] = -0.449959352954143*G0_0_0 - 0.0696683476631385*G0_0_1 - 0.449959352954144*G0_1_0 - 0.0696683476631396*G0_1_1;
    A[14] = 0.202374063051145*G0_0_0 + 0.0408192791005275*G0_0_1 + 0.202374063051147*G0_1_0 + 0.0408192791005305*G0_1_1;
    A[15] = -0.215291556437393*G0_0_0 - 0.215291556437392*G0_0_1 - 0.215291556437394*G0_1_0 - 0.21529155643739*G0_1_1;
    A[16] = -0.0538228891093435*G0_0_0 - 0.0538228891093435*G0_0_1 - 0.0538228891093435*G0_1_0 - 0.0538228891093425*G0_1_1;
    A[17] = 0.107645778218691*G0_0_0 + 0.10764577821869*G0_0_1 + 0.107645778218694*G0_1_0 + 0.10764577821869*G0_1_1;
    A[18] = -0.0538228891093427*G0_0_0 - 0.0538228891093472*G0_0_1 - 0.0538228891093431*G0_1_0 - 0.0538228891093482*G0_1_1;
    A[19] = 0.107645778218692*G0_0_0 + 0.107645778218697*G0_0_1 + 0.107645778218691*G0_1_0 + 0.107645778218696*G0_1_1;
    A[20] = 0.10764577821869*G0_0_0 + 0.107645778218691*G0_0_1 + 0.107645778218691*G0_1_0 + 0.107645778218692*G0_1_1;
    A[21] = -0.040998401675484*G0_0_0 - 0.040998401675485*G0_0_1;
    A[22] = 0.342406580687827*G0_0_0;
    A[23] = 0.0409984016754849*G0_0_1;
    A[24] = 0.202287946428568*G0_0_0 + 0.850315531305104*G0_0_1;
    A[25] = -0.0158454585537923*G0_0_0 - 0.610050154320985*G0_0_1;
    A[26] = -0.0696683476631389*G0_0_0 + 0.380291005291004*G0_0_1;
    A[27] = 0.0408192791005289*G0_0_0 - 0.161554783950618*G0_0_1;
    A[28] = -0.0408192791005293*G0_0_0;
    A[29] = -0.0379774305555557*G0_0_0;
    A[30] = -0.0379774305555546*G0_0_0;
    A[31] = -0.0408192791005288*G0_0_0;
    A[32] = 0.202374063051144*G0_0_0 + 0.161554783950614*G0_0_1;
    A[33] = -0.449959352954139*G0_0_0 - 0.380291005290998*G0_0_1;
    A[34] = 0.594204695767186*G0_0_0 + 0.610050154320978*G0_0_1;
    A[35] = -0.648027584876533*G0_0_0 - 0.850315531305105*G0_0_1;
    A[36] = 0.107645778218696*G0_0_0;
    A[37] = -0.0538228891093515*G0_0_0;
    A[38] = -0.215291556437383*G0_0_0;
    A[39] = 0.107645778218695*G0_0_0;
    A[40] = -0.053822889109347*G0_0_0;
    A[41] = 0.107645778218693*G0_0_0;
    A[42] = -0.0409984016754854*G0_1_0 - 0.0409984016754857*G0_1_1;
    A[43] = 0.0409984016754849*G0_1_0;
    A[44] = 0.342406580687831*G0_1_1;
    A[45] = -0.161554783950616*G0_1_0 + 0.0408192791005303*G0_1_1;
    A[46] = 0.380291005291006*G0_1_0 - 0.0696683476631395*G0_1_1;
    A[47] = -0.610050154320989*G0_1_0 - 0.0158454585537907*G0_1_1;
    A[48] = 0.850315531305115*G0_1_0 + 0.202287946428569*G0_1_1;
    A[49] = 0.161554783950617*G0_1_0 + 0.202374063051148*G0_1_1;
    A[50] = -0.380291005291007*G0_1_0 - 0.449959352954147*G0_1_1;
    A[51] = 0.61005015432099*G0_1_0 + 0.5942046957672*G0_1_1;
    A[52] = -0.850315531305115*G0_1_0 - 0.648027584876545*G0_1_1;
    A[53] = -0.0408192791005305*G0_1_1;
    A[54] = -0.0379774305555567*G0_1_1;
    A[55] = -0.0379774305555561*G0_1_1;
    A[56] = -0.0408192791005294*G0_1_1;
    A[57] = 0.107645778218696*G0_1_1;
    A[58] = 0.107645778218698*G0_1_1;
    A[59] = 0.107645778218696*G0_1_1;
    A[60] = -0.0538228891093476*G0_1_1;
    A[61] = -0.0538228891093534*G0_1_1;
    A[62] = -0.215291556437385*G0_1_1;
    A[63] = -0.0408192791005274*G0_0_0 - 0.0408192791005292*G0_0_1 - 0.0408192791005283*G0_1_0 - 0.0408192791005313*G0_1_1;
    A[64] = 0.202287946428568*G0_0_0 + 0.850315531305104*G0_1_0;
    A[65] = -0.161554783950616*G0_0_1 + 0.0408192791005303*G0_1_1;
    A[66] = 1.98929398148146*G0_0_0 + 1.28098476080245*G0_0_1 + 1.28098476080245*G0_1_0 + 2.56196952160491*G0_1_1;
    A[67] = -0.906377452601408*G0_0_0 + 0.79657875881833*G0_0_1 - 0.529617228835978*G0_1_0 - 1.39508928571429*G0_1_1;
    A[68] = 0.818107914462077*G0_0_0 - 0.482253086419747*G0_0_1 + 0.232514880952378*G0_1_0 + 0.895612874779541*G0_1_1;
    A[69] = -0.340160659171075*G0_0_0 + 0.329396081349201*G0_0_1 - 0.0710462136243371*G0_1_0 - 0.34016065917108*G0_1_1;
    A[70] = 0.142092427248672*G0_0_0 + 0.0710462136243379*G0_0_1 + 0.0710462136243295*G0_1_0;
    A[71] = 0.131327849426814*G0_0_0 + 0.0301408179012428*G0_0_1 + 0.0301408179012408*G0_1_0;
    A[72] = 0.172233245149905*G0_0_0 + 0.030140817901227*G0_0_1 + 0.030140817901233*G0_1_0;
    A[73] = 0.340160659171075*G0_0_0 + 0.0710462136243452*G0_0_1 + 0.071046213624337*G0_1_0;
    A[74] = 0.198068231922391*G0_0_0 + 0.269114445546724*G0_0_1 + 0.269114445546733*G0_1_0 + 0.34016065917106*G0_1_1;
    A[75] = -0.359536899250427*G0_0_0 - 0.663097993827145*G0_0_1 - 0.663097993827147*G0_1_0 - 0.895612874779521*G0_1_1;
    A[76] = 0.286337770061713*G0_0_0 + 0.865472056878291*G0_0_1 + 0.865472056878283*G0_1_0 + 1.39508928571426*G0_1_1;
    A[77] = -0.286337770061717*G0_0_0 - 1.28098476080245*G0_0_1 - 1.28098476080244*G0_1_0 - 2.56196952160491*G0_1_1;
    A[78] = -0.667403824955892*G0_0_0 - 0.262655698853599*G0_0_1 - 0.2626556988536*G0_1_0 + 1.87040053584164e-14*G0_1_1;
    A[79] = 1.35633680555553*G0_0_0 + 0.572675540123427*G0_0_1 + 0.572675540123436*G0_1_0 - 2.88653649593851e-14*G0_1_1;
    A[80] = -2.82031938932977*G0_0_0 - 1.66205081569661*G0_0_1 - 1.66205081569662*G0_1_0 + 3.76003481822318e-14*G0_1_1;
    A[81] = -0.419818535052919*G0_0_0 - 0.07319912918872*G0_0_1 - 0.0731991291887196*G0_1_0;
    A[82] = 1.19486813822751*G0_0_0 + 0.572675540123454*G0_0_1 + 0.572675540123457*G0_1_0;
    A[83] = -0.990341159611983*G0_0_0 - 0.262655698853612*G0_0_1 - 0.262655698853612*G0_1_0;
    A[84] = -0.0379774305555551*G0_0_0 - 0.0379774305555548*G0_0_1 - 0.0379774305555533*G0_1_0 - 0.0379774305555521*G0_1_1;
    A[85] = -0.0158454585537923*G0_0_0 - 0.610050154320985*G0_1_0;
    A[86] = 0.380291005291006*G0_0_1 - 0.0696683476631395*G0_1_1;
    A[87] = -0.906377452601408*G0_0_0 - 0.529617228835978*G0_0_1 + 0.79657875881833*G0_1_0 - 1.39508928571429*G0_1_1;
    A[88] = 3.07436342592591*G0_0_0 + 1.17549189814814*G0_0_1 + 1.17549189814814*G0_1_0 + 3.6944031084656*G0_1_1;
    A[89] = -1.80414324294532*G0_0_0 + 0.699697558421508*G0_0_1 - 0.350925236992944*G0_1_0 - 1.80414324294532*G0_1_1;
    A[90] = 0.895612874779546*G0_0_0 - 0.482253086419749*G0_0_1 + 0.23251488095238*G0_1_0 + 0.818107914462082*G0_1_1;
    A[91] = 0.131327849426812*G0_0_0 + 0.101187031525574*G0_0_1 + 0.101187031525581*G0_1_0 + 0.0710462136243356*G0_1_1;
    A[92] = -0.297102347883606*G0_0_0 - 0.148551173941805*G0_0_1 - 0.148551173941807*G0_1_0 - 0.0172233245149931*G0_1_1;
    A[93] = -0.219597387566126*G0_0_0 - 0.0624345513668298*G0_0_1 - 0.0624345513668404*G0_1_0 - 0.0172233245149839*G0_1_1;
    A[94] = -0.895612874779544*G0_0_0 - 0.232514880952388*G0_0_1 - 0.23251488095238*G0_1_0 + 0.0710462136243356*G0_1_1;
    A[95] = 0.11195160934744*G0_0_0 + 0.142092427248677*G0_0_1 + 0.14209242724867*G0_1_0 + 0.172233245149914*G0_1_1;
    A[96] = -0.11195160934744*G0_0_0 - 0.157162836199292*G0_0_1 - 0.157162836199284*G0_1_0 - 0.219597387566131*G0_1_1;
    A[97] = 0.103339947089949*G0_0_0 + 0.133480764991186*G0_0_1 + 0.13348076499118*G0_1_0 + 0.266961529982368*G0_1_1;
    A[98] = -0.0495170579806028*G0_0_0 + 0.529617228835979*G0_0_1 + 0.529617228835972*G0_1_0 + 1.39508928571429*G0_1_1;
    A[99] = -0.344466490299822*G0_0_0 - 0.44780643738977*G0_0_1 - 0.447806437389765*G0_1_0 - 0.516699735449741*G0_1_1;
    A[100] = 0.387524801587295*G0_0_0 + 0.859013310185172*G0_0_1 + 0.859013310185164*G0_1_0 + 1.01187031525571*G0_1_1;
    A[101] = 0.731991291887124*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313931*G0_1_0 - 3.96136463844796*G0_1_1;
    A[102] = 1.03339947089947*G0_0_0 + 0.374607308201057*G0_0_1 + 0.37460730820106*G0_1_0 + 0.0430583112874819*G0_1_1;
    A[103] = -3.81066054894177*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525573*G0_1_1;
    A[104] = 2.02374063051145*G0_0_0 + 0.413359788359787*G0_0_1 + 0.413359788359784*G0_1_0 - 0.516699735449731*G0_1_1;
    A[105] = -0.037977430555553*G0_0_0 - 0.0379774305555531*G0_0_1 - 0.0379774305555554*G0_1_0 - 0.0379774305555562*G0_1_1;
    A[106] = -0.0696683476631389*G0_0_0 + 0.380291005291004*G0_1_0;
    A[107] = -0.610050154320989*G0_0_1 - 0.0158454585537907*G0_1_1;
    A[108] = 0.818107914462077*G0_0_0 + 0.232514880952378*G0_0_1 - 0.482253086419747*G0_1_0 + 0.895612874779541*G0_1_1;
    A[109] = -1.80414324294532*G0_0_0 - 0.350925236992944*G0_0_1 + 0.699697558421508*G0_1_0 - 1.80414324294532*G0_1_1;
    A[110] = 3.69440310846559*G0_0_0 + 1.17549189814813*G0_0_1 + 1.17549189814813*G0_1_0 + 3.0743634259259*G0_1_1;
    A[111] = -1.39508928571429*G0_0_0 + 0.796578758818335*G0_0_1 - 0.529617228835975*G0_1_0 - 0.906377452601413*G0_1_1;
    A[112] = 0.172233245149901*G0_0_0 + 0.142092427248664*G0_0_1 + 0.142092427248664*G0_1_0 + 0.111951609347437*G0_1_1;
    A[113] = -0.219597387566118*G0_0_0 - 0.157162836199272*G0_0_1 - 0.157162836199279*G0_1_0 - 0.111951609347429*G0_1_1;
    A[114] = 0.266961529982343*G0_0_0 + 0.133480764991162*G0_0_1 + 0.133480764991174*G0_1_0 + 0.103339947089937*G0_1_1;
    A[115] = 1.39508928571429*G0_0_0 + 0.52961722883599*G0_0_1 + 0.529617228835975*G0_1_0 - 0.0495170579805943*G0_1_1;
    A[116] = 0.0710462136243328*G0_0_0 + 0.101187031525569*G0_0_1 + 0.101187031525571*G0_1_0 + 0.131327849426797*G0_1_1;
    A[117] = -0.0172233245149875*G0_0_0 - 0.148551173941795*G0_0_1 - 0.148551173941798*G0_1_0 - 0.297102347883596*G0_1_1;
    A[118] = -0.0172233245149922*G0_0_0 - 0.0624345513668471*G0_0_1 - 0.0624345513668435*G0_1_0 - 0.219597387566143*G0_1_1;
    A[119] = 0.0710462136243396*G0_0_0 - 0.23251488095238*G0_0_1 - 0.232514880952377*G0_1_0 - 0.895612874779543*G0_1_1;
    A[120] = -0.516699735449712*G0_0_0 - 0.447806437389757*G0_0_1 - 0.447806437389752*G0_1_0 - 0.344466490299804*G0_1_1;
    A[121] = 0.043058311287459*G0_0_0 + 0.374607308201047*G0_0_1 + 0.374607308201046*G0_1_0 + 1.03339947089945*G0_1_1;
    A[122] = -0.516699735449725*G0_0_0 + 0.413359788359797*G0_0_1 + 0.413359788359788*G0_1_0 + 2.02374063051147*G0_1_1;
    A[123] = 1.0118703152557*G0_0_0 + 0.85901331018516*G0_0_1 + 0.859013310185154*G0_1_0 + 0.387524801587281*G0_1_1;
    A[124] = 1.01187031525574*G0_0_0 - 1.40154803240739*G0_0_1 - 1.40154803240738*G0_1_0 - 3.81066054894176*G0_1_1;
    A[125] = -3.96136463844793*G0_0_0 - 1.30897266313931*G0_0_1 - 1.30897266313931*G0_1_0 + 0.731991291887132*G0_1_1;
    A[126] = -0.0408192791005294*G0_0_0 - 0.0408192791005305*G0_0_1 - 0.0408192791005275*G0_1_0 - 0.0408192791005281*G0_1_1;
    A[127] = 0.0408192791005289*G0_0_0 - 0.161554783950618*G0_1_0;
    A[128] = 0.850315531305115*G0_0_1 + 0.202287946428569*G0_1_1;
    A[129] = -0.340160659171076*G0_0_0 - 0.0710462136243371*G0_0_1 + 0.329396081349201*G0_1_0 - 0.34016065917108*G0_1_1;
    A[130] = 0.895612874779546*G0_0_0 + 0.23251488095238*G0_0_1 - 0.482253086419749*G0_1_0 + 0.818107914462082*G0_1_1;
    A[131] = -1.39508928571429*G0_0_0 - 0.529617228835975*G0_0_1 + 0.796578758818335*G0_1_0 - 0.906377452601413*G0_1_1;
    A[132] = 2.56196952160494*G0_0_0 + 1.28098476080247*G0_0_1 + 1.28098476080247*G0_1_0 + 1.98929398148148*G0_1_1;
    A[133] = 0.340160659171079*G0_0_0 + 0.269114445546743*G0_0_1 + 0.269114445546739*G0_1_0 + 0.198068231922398*G0_1_1;
    A[134] = -0.895612874779549*G0_0_0 - 0.663097993827173*G0_0_1 - 0.66309799382716*G0_1_0 - 0.359536899250443*G0_1_1;
    A[135] = 1.39508928571429*G0_0_0 + 0.865472056878324*G0_0_1 + 0.865472056878307*G0_1_0 + 0.286337770061735*G0_1_1;
    A[136] = -2.56196952160494*G0_0_0 - 1.28098476080248*G0_0_1 - 1.28098476080246*G0_1_0 - 0.286337770061729*G0_1_1;
    A[137] = 0.0710462136243377*G0_0_1 + 0.0710462136243372*G0_1_0 + 0.142092427248679*G0_1_1;
    A[138] = 0.0301408179012337*G0_0_1 + 0.0301408179012362*G0_1_0 + 0.131327849426812*G0_1_1;
    A[139] = 0.0301408179012342*G0_0_1 + 0.0301408179012344*G0_1_0 + 0.172233245149913*G0_1_1;
    A[140] = 0.0710462136243405*G0_0_1 + 0.0710462136243383*G0_1_0 + 0.340160659171083*G0_1_1;
    A[141] = -0.262655698853616*G0_0_1 - 0.262655698853613*G0_1_0 - 0.667403824955909*G0_1_1;
    A[142] = -0.0731991291887022*G0_0_1 - 0.0731991291887132*G0_1_0 - 0.419818535052904*G0_1_1;
    A[143] = -0.262655698853614*G0_0_1 - 0.262655698853614*G0_1_0 - 0.990341159611992*G0_1_1;
    A[144] = 1.49880108324396e-14*G0_0_0 + 0.572675540123452*G0_0_1 + 0.572675540123459*G0_1_0 + 1.35633680555555*G0_1_1;
    A[145] = -1.37390099297363e-14*G0_0_0 + 0.572675540123431*G0_0_1 + 0.572675540123448*G0_1_0 + 1.19486813822749*G0_1_1;
    A[146] = -1.66205081569663*G0_0_1 - 1.66205081569664*G0_1_0 - 2.82031938932978*G0_1_1;
    A[147] = 0.202287946428573*G0_0_0 + 0.202287946428573*G0_0_1 - 0.648027584876543*G0_1_0 - 0.648027584876542*G0_1_1;
    A[148] = -0.0408192791005293*G0_0_0;
    A[149] = 0.161554783950617*G0_0_1 + 0.202374063051148*G0_1_1;
    A[150] = 0.142092427248672*G0_0_0 + 0.0710462136243295*G0_0_1 + 0.0710462136243379*G0_1_0;
    A[151] = 0.131327849426812*G0_0_0 + 0.101187031525581*G0_0_1 + 0.101187031525574*G0_1_0 + 0.0710462136243356*G0_1_1;
    A[152] = 0.172233245149901*G0_0_0 + 0.142092427248664*G0_0_1 + 0.142092427248664*G0_1_0 + 0.111951609347437*G0_1_1;
    A[153] = 0.340160659171079*G0_0_0 + 0.269114445546739*G0_0_1 + 0.269114445546743*G0_1_0 + 0.198068231922398*G0_1_1;
    A[154] = 1.98929398148147*G0_0_0 + 0.70830922067901*G0_0_1 + 0.708309220679009*G0_1_0 + 1.98929398148147*G0_1_1;
    A[155] = -0.9063774526014*G0_0_0 - 1.70295621141975*G0_0_1 - 0.376760223765425*G0_1_0 - 2.56842826829805*G0_1_1;
    A[156] = 0.818107914462074*G0_0_0 + 1.30036100088183*G0_0_1 + 0.585593033509694*G0_1_0 + 1.96345899470898*G0_1_1;
    A[157] = -0.340160659171079*G0_0_0 - 0.669556740520282*G0_0_1 - 0.269114445546743*G0_1_0 - 0.938671186067018*G0_1_1;
    A[158] = -0.286337770061733*G0_0_0 + 0.994646990740735*G0_0_1 + 0.99464699074074*G0_1_0 - 0.286337770061726*G0_1_1;
    A[159] = 0.286337770061732*G0_0_0 - 0.579134286816573*G0_0_1 - 0.579134286816578*G0_1_0 - 0.0495170579805981*G0_1_1;
    A[160] = -0.359536899250441*G0_0_0 + 0.303561094576718*G0_0_1 + 0.303561094576721*G0_1_0 + 0.0710462136243443*G0_1_1;
    A[161] = 0.198068231922399*G0_0_0 - 0.0710462136243345*G0_0_1 - 0.0710462136243421*G0_1_0;
    A[162] = -2.82031938932979*G0_0_0 - 1.15826857363314*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063494*G0_1_1;
    A[163] = 1.35633680555554*G0_0_0 + 0.783661265432089*G0_0_1 + 0.783661265432089*G0_1_0 + 0.210985725308632*G0_1_1;
    A[164] = -0.667403824955897*G0_0_0 - 0.404748126102298*G0_0_1 - 0.404748126102291*G0_1_0 - 0.142092427248676*G0_1_1;
    A[165] = 1.1948681382275*G0_0_0 + 0.622192598104034*G0_0_1 + 0.622192598104038*G0_1_0 + 0.0495170579805924*G0_1_1;
    A[166] = -0.419818535052911*G0_0_0 - 0.346619405864177*G0_0_1 - 0.346619405864188*G0_1_0 - 0.273420276675479*G0_1_1;
    A[167] = -0.990341159611973*G0_0_0 - 0.727685460758367*G0_0_1 - 0.727685460758357*G0_1_0 - 0.465029761904752*G0_1_1;
    A[168] = -0.015845458553794*G0_0_0 - 0.0158454585537929*G0_0_1 + 0.594204695767193*G0_1_0 + 0.594204695767193*G0_1_1;
    A[169] = -0.0379774305555557*G0_0_0;
    A[170] = -0.380291005291007*G0_0_1 - 0.449959352954147*G0_1_1;
    A[171] = 0.131327849426814*G0_0_0 + 0.0301408179012408*G0_0_1 + 0.0301408179012428*G0_1_0;
    A[172] = -0.297102347883606*G0_0_0 - 0.148551173941807*G0_0_1 - 0.148551173941805*G0_1_0 - 0.0172233245149931*G0_1_1;
    A[173] = -0.219597387566118*G0_0_0 - 0.157162836199279*G0_0_1 - 0.157162836199272*G0_1_0 - 0.111951609347429*G0_1_1;
    A[174] = -0.895612874779549*G0_0_0 - 0.66309799382716*G0_0_1 - 0.663097993827173*G0_1_0 - 0.359536899250443*G0_1_1;
    A[175] = -0.9063774526014*G0_0_0 - 0.376760223765425*G0_0_1 - 1.70295621141975*G0_1_0 - 2.56842826829805*G0_1_1;
    A[176] = 3.07436342592592*G0_0_0 + 1.89887152777777*G0_0_1 + 1.89887152777777*G0_1_0 + 4.41778273809522*G0_1_1;
    A[177] = -1.80414324294531*G0_0_0 - 2.50384080136683*G0_0_1 - 1.45321800595237*G0_1_0 - 3.95705880731921*G0_1_1;
    A[178] = 0.895612874779549*G0_0_0 + 1.37786596119929*G0_0_1 + 0.663097993827174*G0_1_0 + 1.96345899470899*G0_1_1;
    A[179] = -0.0495170579805945*G0_0_0 - 0.579134286816573*G0_0_1 - 0.579134286816576*G0_1_0 + 0.286337770061724*G0_1_1;
    A[180] = 0.103339947089944*G0_0_0 - 0.0301408179012364*G0_0_1 - 0.0301408179012351*G0_1_0 + 0.103339947089943*G0_1_1;
    A[181] = -0.111951609347441*G0_0_0 + 0.0452112268518537*G0_0_1 + 0.0452112268518506*G0_1_0 - 0.0172233245149965*G0_1_1;
    A[182] = 0.111951609347441*G0_0_0 - 0.0301408179012395*G0_0_1 - 0.0301408179012329*G0_1_0;
    A[183] = 0.731991291887113*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502644*G0_1_0 - 0.611428020282186*G0_1_1;
    A[184] = 0.387524801587301*G0_0_0 - 0.471488508597878*G0_0_1 - 0.471488508597879*G0_1_0 - 0.318631503527328*G0_1_1;
    A[185] = -0.344466490299828*G0_0_0 + 0.103339947089948*G0_0_1 + 0.103339947089943*G0_1_0 + 0.034446649029984*G0_1_1;
    A[186] = -3.81066054894178*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653437*G0_1_0 + 0.0043058311287574*G0_1_1;
    A[187] = 1.03339947089947*G0_0_0 + 0.658792162698404*G0_0_1 + 0.658792162698405*G0_1_0 + 0.327243165784824*G0_1_1;
    A[188] = 2.02374063051143*G0_0_0 + 1.61038084215165*G0_0_1 + 1.61038084215164*G0_1_0 + 0.680321318342139*G0_1_1;
    A[189] = -0.0696683476631372*G0_0_0 - 0.0696683476631374*G0_0_1 - 0.449959352954142*G0_1_0 - 0.449959352954142*G0_1_1;
    A[190] = -0.0379774305555546*G0_0_0;
    A[191] = 0.61005015432099*G0_0_1 + 0.5942046957672*G0_1_1;
    A[192] = 0.172233245149905*G0_0_0 + 0.030140817901233*G0_0_1 + 0.030140817901227*G0_1_0;
    A[193] = -0.219597387566126*G0_0_0 - 0.0624345513668404*G0_0_1 - 0.0624345513668299*G0_1_0 - 0.0172233245149839*G0_1_1;
    A[194] = 0.266961529982343*G0_0_0 + 0.133480764991174*G0_0_1 + 0.133480764991162*G0_1_0 + 0.103339947089937*G0_1_1;
    A[195] = 1.39508928571429*G0_0_0 + 0.865472056878307*G0_0_1 + 0.865472056878324*G0_1_0 + 0.286337770061735*G0_1_1;
    A[196] = 0.818107914462074*G0_0_0 + 0.585593033509694*G0_0_1 + 1.30036100088183*G0_1_0 + 1.96345899470898*G0_1_1;
    A[197] = -1.80414324294531*G0_0_0 - 1.45321800595237*G0_0_1 - 2.50384080136683*G0_1_0 - 3.95705880731921*G0_1_1;
    A[198] = 3.69440310846559*G0_0_0 + 2.51891121031745*G0_0_1 + 2.51891121031746*G0_1_0 + 4.41778273809523*G0_1_1;
    A[199] = -1.39508928571429*G0_0_0 - 2.19166804453263*G0_0_1 - 0.865472056878325*G0_1_0 - 2.56842826829806*G0_1_1;
    A[200] = 0.0710462136243339*G0_0_0 + 0.30356109457672*G0_0_1 + 0.303561094576716*G0_1_0 - 0.359536899250437*G0_1_1;
    A[201] = -0.0172233245149904*G0_0_0 + 0.0452112268518529*G0_0_1 + 0.0452112268518538*G0_1_0 - 0.111951609347442*G0_1_1;
    A[202] = -0.0172233245149884*G0_0_0 + 0.13132784942681*G0_0_1 + 0.131327849426808*G0_1_0 - 0.0172233245149885*G0_1_1;
    A[203] = 0.0710462136243361*G0_0_0 - 0.0301408179012358*G0_0_1 - 0.0301408179012339*G0_1_0;
    A[204] = -0.516699735449721*G0_0_0 - 0.930059523809513*G0_0_1 - 0.930059523809515*G0_1_0 + 0.68032131834215*G0_1_1;
    A[205] = 0.043058311287469*G0_0_0 - 0.331548996913582*G0_0_1 - 0.331548996913581*G0_1_0 + 0.32724316578483*G0_1_1;
    A[206] = -0.516699735449727*G0_0_0 - 0.0688932980599643*G0_0_1 - 0.0688932980599605*G0_1_0 + 0.0344466490299785*G0_1_1;
    A[207] = 1.01187031525572*G0_0_0 + 2.41341834766312*G0_0_1 + 2.41341834766312*G0_1_0 + 0.00430583112874228*G0_1_1;
    A[208] = 1.01187031525572*G0_0_0 + 0.152857005070552*G0_0_1 + 0.152857005070543*G0_1_0 - 0.318631503527335*G0_1_1;
    A[209] = -3.96136463844793*G0_0_0 - 2.65239197530863*G0_0_1 - 2.65239197530861*G0_1_0 - 0.611428020282182*G0_1_1;
    A[210] = 0.0408192791005293*G0_0_0 + 0.0408192791005304*G0_0_1 + 0.202374063051146*G0_1_0 + 0.202374063051146*G0_1_1;
    A[211] = -0.0408192791005288*G0_0_0;
    A[212] = -0.850315531305115*G0_0_1 - 0.648027584876546*G0_1_1;
    A[213] = 0.340160659171075*G0_0_0 + 0.071046213624337*G0_0_1 + 0.0710462136243451*G0_1_0;
    A[214] = -0.895612874779544*G0_0_0 - 0.23251488095238*G0_0_1 - 0.232514880952388*G0_1_0 + 0.0710462136243356*G0_1_1;
    A[215] = 1.39508928571429*G0_0_0 + 0.529617228835975*G0_0_1 + 0.52961722883599*G0_1_0 - 0.0495170579805943*G0_1_1;
    A[216] = -2.56196952160494*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080248*G0_1_0 - 0.286337770061729*G0_1_1;
    A[217] = -0.340160659171079*G0_0_0 - 0.269114445546743*G0_0_1 - 0.669556740520282*G0_1_0 - 0.938671186067018*G0_1_1;
    A[218] = 0.895612874779549*G0_0_0 + 0.663097993827174*G0_0_1 + 1.37786596119929*G0_1_0 + 1.96345899470899*G0_1_1;
    A[219] = -1.39508928571429*G0_0_0 - 0.865472056878325*G0_0_1 - 2.19166804453263*G0_1_0 - 2.56842826829806*G0_1_1;
    A[220] = 2.56196952160494*G0_0_0 + 1.28098476080248*G0_0_1 + 1.28098476080248*G0_1_0 + 1.98929398148149*G0_1_1;
    A[221] = -0.0710462136243377*G0_0_1 - 0.0710462136243377*G0_1_0 + 0.198068231922397*G0_1_1;
    A[222] = -0.0301408179012341*G0_0_1 - 0.0301408179012353*G0_1_0 + 0.111951609347441*G0_1_1;
    A[223] = -0.030140817901234*G0_0_1 - 0.030140817901235*G0_1_0 + 0.0710462136243365*G0_1_1;
    A[224] = -0.0710462136243404*G0_0_1 - 0.0710462136243393*G0_1_0;
    A[225] = 0.262655698853616*G0_0_1 + 0.262655698853613*G0_1_0 - 0.465029761904763*G0_1_1;
    A[226] = 0.0731991291887031*G0_0_1 + 0.0731991291887129*G0_1_0 - 0.273420276675486*G0_1_1;
    A[227] = 0.262655698853613*G0_0_1 + 0.262655698853612*G0_1_0 - 0.142092427248675*G0_1_1;
    A[228] = -1.45716771982052e-14*G0_0_0 - 0.572675540123452*G0_0_1 - 0.572675540123455*G0_1_0 + 0.0495170579806023*G0_1_1;
    A[229] = 1.18099974244501e-14*G0_0_0 - 0.572675540123432*G0_0_1 - 0.572675540123448*G0_1_0 + 0.210985725308645*G0_1_1;
    A[230] = 1.66205081569663*G0_0_1 + 1.66205081569664*G0_1_0 + 0.50378224206349*G0_1_1;
    A[231] = -0.648027584876543*G0_0_0 - 0.648027584876544*G0_0_1 + 0.202287946428573*G0_1_0 + 0.202287946428572*G0_1_1;
    A[232] = 0.202374063051144*G0_0_0 + 0.161554783950614*G0_1_0;
    A[233] = -0.0408192791005305*G0_1_1;
    A[234] = 0.198068231922391*G0_0_0 + 0.269114445546733*G0_0_1 + 0.269114445546724*G0_1_0 + 0.34016065917106*G0_1_1;
    A[235] = 0.11195160934744*G0_0_0 + 0.14209242724867*G0_0_1 + 0.142092427248677*G0_1_0 + 0.172233245149914*G0_1_1;
    A[236] = 0.0710462136243328*G0_0_0 + 0.101187031525571*G0_0_1 + 0.101187031525569*G0_1_0 + 0.131327849426798*G0_1_1;
    A[237] = 0.0710462136243372*G0_0_1 + 0.0710462136243377*G0_1_0 + 0.142092427248679*G0_1_1;
    A[238] = -0.286337770061733*G0_0_0 + 0.99464699074074*G0_0_1 + 0.994646990740735*G0_1_0 - 0.286337770061726*G0_1_1;
    A[239] = -0.0495170579805945*G0_0_0 - 0.579134286816576*G0_0_1 - 0.579134286816573*G0_1_0 + 0.286337770061724*G0_1_1;
    A[240] = 0.0710462136243339*G0_0_0 + 0.303561094576716*G0_0_1 + 0.30356109457672*G0_1_0 - 0.359536899250437*G0_1_1;
    A[241] = -0.0710462136243378*G0_0_1 - 0.0710462136243377*G0_1_0 + 0.198068231922397*G0_1_1;
    A[242] = 1.98929398148147*G0_0_0 + 0.708309220679004*G0_0_1 + 0.708309220679004*G0_1_0 + 1.98929398148147*G0_1_1;
    A[243] = -2.56842826829805*G0_0_0 - 0.376760223765423*G0_0_1 - 1.70295621141974*G0_1_0 - 0.906377452601395*G0_1_1;
    A[244] = 1.96345899470898*G0_0_0 + 0.58559303350969*G0_0_1 + 1.30036100088182*G0_1_0 + 0.81810791446207*G0_1_1;
    A[245] = -0.938671186067011*G0_0_0 - 0.269114445546733*G0_0_1 - 0.669556740520273*G0_1_0 - 0.340160659171065*G0_1_1;
    A[246] = 0.503782242063502*G0_0_0 - 1.15826857363314*G0_0_1 - 1.15826857363314*G0_1_0 - 2.82031938932979*G0_1_1;
    A[247] = 0.0495170579805817*G0_0_0 + 0.622192598104035*G0_0_1 + 0.622192598104039*G0_1_0 + 1.19486813822749*G0_1_1;
    A[248] = -0.465029761904743*G0_0_0 - 0.727685460758356*G0_0_1 - 0.727685460758355*G0_1_0 - 0.990341159611983*G0_1_1;
    A[249] = 0.210985725308631*G0_0_0 + 0.783661265432095*G0_0_1 + 0.783661265432092*G0_1_0 + 1.35633680555554*G0_1_1;
    A[250] = -0.273420276675476*G0_0_0 - 0.346619405864189*G0_0_1 - 0.346619405864195*G0_1_0 - 0.419818535052887*G0_1_1;
    A[251] = -0.142092427248667*G0_0_0 - 0.404748126102287*G0_0_1 - 0.404748126102289*G0_1_0 - 0.667403824955907*G0_1_1;
    A[252] = 0.594204695767193*G0_0_0 + 0.594204695767195*G0_0_1 - 0.0158454585537928*G0_1_0 - 0.0158454585537928*G0_1_1;
    A[253] = -0.449959352954139*G0_0_0 - 0.380291005290998*G0_1_0;
    A[254] = -0.0379774305555567*G0_1_1;
    A[255] = -0.359536899250427*G0_0_0 - 0.663097993827147*G0_0_1 - 0.663097993827145*G0_1_0 - 0.895612874779521*G0_1_1;
    A[256] = -0.11195160934744*G0_0_0 - 0.157162836199284*G0_0_1 - 0.157162836199292*G0_1_0 - 0.219597387566131*G0_1_1;
    A[257] = -0.0172233245149875*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941795*G0_1_0 - 0.297102347883596*G0_1_1;
    A[258] = 0.0301408179012362*G0_0_1 + 0.0301408179012337*G0_1_0 + 0.131327849426812*G0_1_1;
    A[259] = 0.286337770061732*G0_0_0 - 0.579134286816578*G0_0_1 - 0.579134286816573*G0_1_0 - 0.0495170579805981*G0_1_1;
    A[260] = 0.103339947089944*G0_0_0 - 0.0301408179012351*G0_0_1 - 0.0301408179012363*G0_1_0 + 0.103339947089943*G0_1_1;
    A[261] = -0.0172233245149904*G0_0_0 + 0.0452112268518538*G0_0_1 + 0.0452112268518529*G0_1_0 - 0.111951609347442*G0_1_1;
    A[262] = -0.0301408179012353*G0_0_1 - 0.0301408179012341*G0_1_0 + 0.111951609347441*G0_1_1;
    A[263] = -2.56842826829805*G0_0_0 - 1.70295621141974*G0_0_1 - 0.376760223765423*G0_1_0 - 0.906377452601395*G0_1_1;
    A[264] = 4.41778273809521*G0_0_0 + 1.89887152777775*G0_0_1 + 1.89887152777775*G0_1_0 + 3.0743634259259*G0_1_1;
    A[265] = -3.95705880731919*G0_0_0 - 1.45321800595236*G0_0_1 - 2.50384080136681*G0_1_0 - 1.80414324294529*G0_1_1;
    A[266] = 1.96345899470897*G0_0_0 + 0.663097993827149*G0_0_1 + 1.37786596119927*G0_1_0 + 0.895612874779522*G0_1_1;
    A[267] = -0.611428020282201*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502643*G0_1_0 + 0.731991291887101*G0_1_1;
    A[268] = 0.00430583112877628*G0_0_0 - 2.40911251653435*G0_0_1 - 2.40911251653435*G0_1_0 - 3.81066054894176*G0_1_1;
    A[269] = 0.68032131834212*G0_0_0 + 1.61038084215164*G0_0_1 + 1.61038084215164*G0_1_0 + 2.02374063051142*G0_1_1;
    A[270] = -0.31863150352733*G0_0_0 - 0.471488508597883*G0_0_1 - 0.471488508597879*G0_1_0 + 0.387524801587314*G0_1_1;
    A[271] = 0.327243165784823*G0_0_0 + 0.658792162698402*G0_0_1 + 0.658792162698407*G0_1_0 + 1.03339947089946*G0_1_1;
    A[272] = 0.0344466490299794*G0_0_0 + 0.103339947089947*G0_0_1 + 0.103339947089942*G0_1_0 - 0.344466490299826*G0_1_1;
    A[273] = -0.449959352954143*G0_0_0 - 0.449959352954144*G0_0_1 - 0.0696683476631385*G0_1_0 - 0.0696683476631396*G0_1_1;
    A[274] = 0.594204695767186*G0_0_0 + 0.610050154320978*G0_1_0;
    A[275] = -0.0379774305555561*G0_1_1;
    A[276] = 0.286337770061713*G0_0_0 + 0.865472056878283*G0_0_1 + 0.865472056878291*G0_1_0 + 1.39508928571426*G0_1_1;
    A[277] = 0.103339947089949*G0_0_0 + 0.13348076499118*G0_0_1 + 0.133480764991186*G0_1_0 + 0.266961529982368*G0_1_1;
    A[278] = -0.0172233245149922*G0_0_0 - 0.0624345513668434*G0_0_1 - 0.0624345513668471*G0_1_0 - 0.219597387566143*G0_1_1;
    A[279] = 0.0301408179012343*G0_0_1 + 0.0301408179012342*G0_1_0 + 0.172233245149913*G0_1_1;
    A[280] = -0.359536899250441*G0_0_0 + 0.303561094576721*G0_0_1 + 0.303561094576718*G0_1_0 + 0.0710462136243443*G0_1_1;
    A[281] = -0.111951609347441*G0_0_0 + 0.0452112268518507*G0_0_1 + 0.0452112268518537*G0_1_0 - 0.0172233245149964*G0_1_1;
    A[282] = -0.0172233245149884*G0_0_0 + 0.131327849426808*G0_0_1 + 0.13132784942681*G0_1_0 - 0.0172233245149885*G0_1_1;
    A[283] = -0.030140817901235*G0_0_1 - 0.030140817901234*G0_1_0 + 0.0710462136243365*G0_1_1;
    A[284] = 1.96345899470898*G0_0_0 + 1.30036100088182*G0_0_1 + 0.58559303350969*G0_1_0 + 0.81810791446207*G0_1_1;
    A[285] = -3.95705880731919*G0_0_0 - 2.50384080136681*G0_0_1 - 1.45321800595236*G0_1_0 - 1.80414324294529*G0_1_1;
    A[286] = 4.4177827380952*G0_0_0 + 2.51891121031743*G0_0_1 + 2.51891121031743*G0_1_0 + 3.69440310846557*G0_1_1;
    A[287] = -2.56842826829803*G0_0_0 - 0.865472056878285*G0_0_1 - 2.1916680445326*G0_1_0 - 1.39508928571426*G0_1_1;
    A[288] = 0.680321318342164*G0_0_0 - 0.930059523809508*G0_0_1 - 0.930059523809503*G0_1_0 - 0.516699735449718*G0_1_1;
    A[289] = 0.00430583112871861*G0_0_0 + 2.4134183476631*G0_0_1 + 2.4134183476631*G0_1_0 + 1.01187031525569*G0_1_1;
    A[290] = -0.611428020282154*G0_0_0 - 2.6523919753086*G0_0_1 - 2.6523919753086*G0_1_0 - 3.96136463844793*G0_1_1;
    A[291] = 0.32724316578483*G0_0_0 - 0.331548996913577*G0_0_1 - 0.33154899691358*G0_1_0 + 0.0430583112874724*G0_1_1;
    A[292] = -0.318631503527336*G0_0_0 + 0.152857005070551*G0_0_1 + 0.152857005070542*G0_1_0 + 1.01187031525574*G0_1_1;
    A[293] = 0.0344466490299793*G0_0_0 - 0.0688932980599677*G0_0_1 - 0.0688932980599632*G0_1_0 - 0.516699735449736*G0_1_1;
    A[294] = 0.202374063051145*G0_0_0 + 0.202374063051147*G0_0_1 + 0.0408192791005275*G0_1_0 + 0.0408192791005305*G0_1_1;
    A[295] = -0.648027584876533*G0_0_0 - 0.850315531305105*G0_1_0;
    A[296] = -0.0408192791005294*G0_1_1;
    A[297] = -0.286337770061717*G0_0_0 - 1.28098476080244*G0_0_1 - 1.28098476080245*G0_1_0 - 2.56196952160491*G0_1_1;
    A[298] = -0.0495170579806028*G0_0_0 + 0.529617228835972*G0_0_1 + 0.529617228835979*G0_1_0 + 1.39508928571429*G0_1_1;
    A[299] = 0.0710462136243396*G0_0_0 - 0.232514880952377*G0_0_1 - 0.23251488095238*G0_1_0 - 0.895612874779542*G0_1_1;
    A[300] = 0.0710462136243383*G0_0_1 + 0.0710462136243405*G0_1_0 + 0.340160659171083*G0_1_1;
    A[301] = 0.198068231922399*G0_0_0 - 0.0710462136243422*G0_0_1 - 0.0710462136243345*G0_1_0;
    A[302] = 0.111951609347441*G0_0_0 - 0.030140817901233*G0_0_1 - 0.0301408179012395*G0_1_0;
    A[303] = 0.0710462136243361*G0_0_0 - 0.0301408179012338*G0_0_1 - 0.0301408179012358*G0_1_0;
    A[304] = -0.0710462136243393*G0_0_1 - 0.0710462136243404*G0_1_0;
    A[305] = -0.938671186067011*G0_0_0 - 0.669556740520273*G0_0_1 - 0.269114445546733*G0_1_0 - 0.340160659171065*G0_1_1;
    A[306] = 1.96345899470897*G0_0_0 + 1.37786596119927*G0_0_1 + 0.663097993827149*G0_1_0 + 0.895612874779522*G0_1_1;
    A[307] = -2.56842826829803*G0_0_0 - 2.1916680445326*G0_0_1 - 0.865472056878285*G0_1_0 - 1.39508928571426*G0_1_1;
    A[308] = 1.98929398148146*G0_0_0 + 1.28098476080245*G0_0_1 + 1.28098476080245*G0_1_0 + 2.56196952160492*G0_1_1;
    A[309] = -0.465029761904767*G0_0_0 + 0.262655698853606*G0_0_1 + 0.262655698853603*G0_1_0 - 1.53052483881089e-14*G0_1_1;
    A[310] = 0.0495170579806151*G0_0_0 - 0.572675540123431*G0_0_1 - 0.572675540123439*G0_1_0 + 2.91847709193993e-14*G0_1_1;
    A[311] = 0.503782242063471*G0_0_0 + 1.66205081569662*G0_0_1 + 1.66205081569662*G0_1_0 - 3.27102711236704e-14*G0_1_1;
    A[312] = -0.273420276675486*G0_0_0 + 0.0731991291887108*G0_0_1 + 0.0731991291887165*G0_1_0;
    A[313] = 0.210985725308646*G0_0_0 - 0.57267554012346*G0_0_1 - 0.572675540123456*G0_1_0;
    A[314] = -0.142092427248675*G0_0_0 + 0.262655698853619*G0_0_1 + 0.262655698853616*G0_1_0;
    A[315] = -0.215291556437393*G0_0_0 - 0.215291556437394*G0_0_1 - 0.215291556437392*G0_1_0 - 0.21529155643739*G0_1_1;
    A[316] = 0.107645778218696*G0_0_0;
    A[317] = 0.107645778218696*G0_1_1;
    A[318] = -0.667403824955892*G0_0_0 - 0.2626556988536*G0_0_1 - 0.262655698853599*G0_1_0 + 1.87308935722941e-14*G0_1_1;
    A[319] = -0.344466490299822*G0_0_0 - 0.447806437389765*G0_0_1 - 0.44780643738977*G0_1_0 - 0.516699735449741*G0_1_1;
    A[320] = -0.516699735449712*G0_0_0 - 0.447806437389752*G0_0_1 - 0.447806437389757*G0_1_0 - 0.344466490299804*G0_1_1;
    A[321] = -0.262655698853613*G0_0_1 - 0.262655698853616*G0_1_0 - 0.667403824955909*G0_1_1;
    A[322] = -2.82031938932979*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363314*G0_1_0 + 0.503782242063494*G0_1_1;
    A[323] = 0.731991291887113*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502644*G0_1_0 - 0.611428020282186*G0_1_1;
    A[324] = -0.516699735449721*G0_0_0 - 0.930059523809515*G0_0_1 - 0.930059523809513*G0_1_0 + 0.68032131834215*G0_1_1;
    A[325] = 0.262655698853613*G0_0_1 + 0.262655698853616*G0_1_0 - 0.465029761904763*G0_1_1;
    A[326] = 0.503782242063502*G0_0_0 - 1.15826857363314*G0_0_1 - 1.15826857363314*G0_1_0 - 2.82031938932979*G0_1_1;
    A[327] = -0.611428020282201*G0_0_0 + 2.04096395502643*G0_0_1 + 2.04096395502644*G0_1_0 + 0.731991291887101*G0_1_1;
    A[328] = 0.680321318342164*G0_0_0 - 0.930059523809503*G0_0_1 - 0.930059523809508*G0_1_0 - 0.516699735449718*G0_1_1;
    A[329] = -0.465029761904767*G0_0_0 + 0.262655698853603*G0_0_1 + 0.262655698853606*G0_1_0 - 1.5331919761552e-14*G0_1_1;
    A[330] = 7.06156305114634*G0_0_0 + 3.10019841269837*G0_0_1 + 3.10019841269837*G0_1_0 + 7.06156305114635*G0_1_1;
    A[331] = -6.3295717592592*G0_0_0 - 3.0571401014109*G0_0_1 - 3.0571401014109*G0_1_0 - 1.80844907407403*G0_1_1;
    A[332] = 2.75573192239855*G0_0_0 + 1.37786596119927*G0_0_1 + 1.37786596119926*G0_1_0 + 1.03339947089946*G0_1_1;
    A[333] = -1.80844907407405*G0_0_0 - 3.05714010141089*G0_0_1 - 3.05714010141091*G0_1_0 - 6.32957175925922*G0_1_1;
    A[334] = 1.42092427248676*G0_0_0 + 1.46398258377422*G0_0_1 + 1.46398258377423*G0_1_0 + 1.42092427248674*G0_1_1;
    A[335] = 1.03339947089943*G0_0_0 + 1.37786596119927*G0_0_1 + 1.37786596119927*G0_1_0 + 2.75573192239857*G0_1_1;
    A[336] = -0.0538228891093435*G0_0_0 - 0.0538228891093435*G0_0_1 - 0.0538228891093435*G0_1_0 - 0.0538228891093425*G0_1_1;
    A[337] = -0.0538228891093515*G0_0_0;
    A[338] = 0.107645778218698*G0_1_1;
    A[339] = 1.35633680555553*G0_0_0 + 0.572675540123436*G0_0_1 + 0.572675540123427*G0_1_0 - 2.88093117070676e-14*G0_1_1;
    A[340] = 0.387524801587295*G0_0_0 + 0.859013310185164*G0_0_1 + 0.859013310185172*G0_1_0 + 1.01187031525571*G0_1_1;
    A[341] = 0.043058311287459*G0_0_0 + 0.374607308201047*G0_0_1 + 0.374607308201047*G0_1_0 + 1.03339947089945*G0_1_1;
    A[342] = -0.0731991291887133*G0_0_1 - 0.0731991291887022*G0_1_0 - 0.419818535052904*G0_1_1;
    A[343] = 1.35633680555554*G0_0_0 + 0.78366126543209*G0_0_1 + 0.783661265432089*G0_1_0 + 0.210985725308632*G0_1_1;
    A[344] = 0.387524801587301*G0_0_0 - 0.471488508597879*G0_0_1 - 0.471488508597878*G0_1_0 - 0.318631503527328*G0_1_1;
    A[345] = 0.043058311287469*G0_0_0 - 0.331548996913581*G0_0_1 - 0.331548996913582*G0_1_0 + 0.32724316578483*G0_1_1;
    A[346] = 0.0731991291887129*G0_0_1 + 0.0731991291887031*G0_1_0 - 0.273420276675486*G0_1_1;
    A[347] = 0.0495170579805818*G0_0_0 + 0.622192598104039*G0_0_1 + 0.622192598104035*G0_1_0 + 1.19486813822749*G0_1_1;
    A[348] = 0.00430583112877583*G0_0_0 - 2.40911251653435*G0_0_1 - 2.40911251653435*G0_1_0 - 3.81066054894176*G0_1_1;
    A[349] = 0.0043058311287184*G0_0_0 + 2.4134183476631*G0_0_1 + 2.4134183476631*G0_1_0 + 1.01187031525569*G0_1_1;
    A[350] = 0.0495170579806151*G0_0_0 - 0.572675540123439*G0_0_1 - 0.572675540123431*G0_1_0 + 2.92402820706306e-14*G0_1_1;
    A[351] = -6.3295717592592*G0_0_0 - 3.0571401014109*G0_0_1 - 3.0571401014109*G0_1_0 - 1.80844907407403*G0_1_1;
    A[352] = 9.94646990740731*G0_0_0 + 4.97323495370363*G0_0_1 + 4.97323495370363*G0_1_0 + 8.654720568783*G0_1_1;
    A[353] = -6.32957175925918*G0_0_0 - 3.27243165784826*G0_0_1 - 3.27243165784826*G0_1_0 - 2.0237406305114*G0_1_1;
    A[354] = -0.387524801587312*G0_0_0 + 2.55120494378303*G0_0_1 + 2.55120494378305*G0_1_0 - 0.387524801587328*G0_1_1;
    A[355] = -0.387524801587285*G0_0_0 - 2.93872974537033*G0_0_1 - 2.93872974537034*G0_1_0 - 5.8774594907407*G0_1_1;
    A[356] = -0.0861166225749283*G0_0_0 - 0.0430583112874656*G0_0_1 - 0.0430583112874657*G0_1_0 + 1.42092427248678*G0_1_1;
    A[357] = 0.107645778218691*G0_0_0 + 0.107645778218694*G0_0_1 + 0.10764577821869*G0_1_0 + 0.10764577821869*G0_1_1;
    A[358] = -0.215291556437383*G0_0_0;
    A[359] = 0.107645778218696*G0_1_1;
    A[360] = -2.82031938932977*G0_0_0 - 1.66205081569662*G0_0_1 - 1.66205081569661*G0_1_0 + 3.76005650226663e-14*G0_1_1;
    A[361] = 0.731991291887124*G0_0_0 - 1.30897266313931*G0_0_1 - 1.30897266313933*G0_1_0 - 3.96136463844796*G0_1_1;
    A[362] = -0.516699735449725*G0_0_0 + 0.413359788359788*G0_0_1 + 0.413359788359797*G0_1_0 + 2.02374063051147*G0_1_1;
    A[363] = -0.262655698853614*G0_0_1 - 0.262655698853614*G0_1_0 - 0.990341159611992*G0_1_1;
    A[364] = -0.667403824955897*G0_0_0 - 0.404748126102291*G0_0_1 - 0.404748126102298*G0_1_0 - 0.142092427248676*G0_1_1;
    A[365] = -0.344466490299828*G0_0_0 + 0.103339947089943*G0_0_1 + 0.103339947089948*G0_1_0 + 0.0344466490299841*G0_1_1;
    A[366] = -0.516699735449727*G0_0_0 - 0.0688932980599606*G0_0_1 - 0.0688932980599643*G0_1_0 + 0.0344466490299785*G0_1_1;
    A[367] = 0.262655698853612*G0_0_1 + 0.262655698853613*G0_1_0 - 0.142092427248675*G0_1_1;
    A[368] = -0.465029761904743*G0_0_0 - 0.727685460758355*G0_0_1 - 0.727685460758356*G0_1_0 - 0.990341159611983*G0_1_1;
    A[369] = 0.680321318342121*G0_0_0 + 1.61038084215164*G0_0_1 + 1.61038084215164*G0_1_0 + 2.02374063051142*G0_1_1;
    A[370] = -0.611428020282155*G0_0_0 - 2.6523919753086*G0_0_1 - 2.6523919753086*G0_1_0 - 3.96136463844793*G0_1_1;
    A[371] = 0.503782242063471*G0_0_0 + 1.66205081569662*G0_0_1 + 1.66205081569662*G0_1_0 - 3.27102711236704e-14*G0_1_1;
    A[372] = 2.75573192239855*G0_0_0 + 1.37786596119926*G0_0_1 + 1.37786596119927*G0_1_0 + 1.03339947089946*G0_1_1;
    A[373] = -6.32957175925918*G0_0_0 - 3.27243165784826*G0_0_1 - 3.27243165784826*G0_1_0 - 2.0237406305114*G0_1_1;
    A[374] = 7.0615630511463*G0_0_0 + 3.9613646384479*G0_0_1 + 3.9613646384479*G0_1_0 + 7.92272927689587*G0_1_1;
    A[375] = 1.42092427248678*G0_0_0 - 0.0430583112874602*G0_0_1 - 0.043058311287472*G0_1_0 - 0.0861166225749481*G0_1_1;
    A[376] = -1.80844907407408*G0_0_0 + 1.24869102733684*G0_0_1 + 1.24869102733685*G0_1_0 - 2.02374063051147*G0_1_1;
    A[377] = 1.03339947089945*G0_0_0 - 0.34446649029983*G0_0_1 - 0.344466490299832*G0_1_0 + 1.03339947089946*G0_1_1;
    A[378] = -0.0538228891093427*G0_0_0 - 0.0538228891093431*G0_0_1 - 0.0538228891093471*G0_1_0 - 0.0538228891093481*G0_1_1;
    A[379] = 0.107645778218695*G0_0_0;
    A[380] = -0.0538228891093476*G0_1_1;
    A[381] = -0.419818535052918*G0_0_0 - 0.0731991291887196*G0_0_1 - 0.07319912918872*G0_1_0;
    A[382] = 1.03339947089947*G0_0_0 + 0.37460730820106*G0_0_1 + 0.374607308201057*G0_1_0 + 0.0430583112874819*G0_1_1;
    A[383] = 1.0118703152557*G0_0_0 + 0.859013310185154*G0_0_1 + 0.85901331018516*G0_1_0 + 0.387524801587281*G0_1_1;
    A[384] = 1.49880108324396e-14*G0_0_0 + 0.572675540123459*G0_0_1 + 0.572675540123452*G0_1_0 + 1.35633680555555*G0_1_1;
    A[385] = 1.1948681382275*G0_0_0 + 0.622192598104038*G0_0_1 + 0.622192598104034*G0_1_0 + 0.0495170579805924*G0_1_1;
    A[386] = -3.81066054894178*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653437*G0_1_0 + 0.00430583112875729*G0_1_1;
    A[387] = 1.01187031525572*G0_0_0 + 2.41341834766312*G0_0_1 + 2.41341834766312*G0_1_0 + 0.00430583112874194*G0_1_1;
    A[388] = -1.45716771982052e-14*G0_0_0 - 0.572675540123455*G0_0_1 - 0.572675540123452*G0_1_0 + 0.0495170579806023*G0_1_1;
    A[389] = 0.210985725308631*G0_0_0 + 0.783661265432091*G0_0_1 + 0.783661265432094*G0_1_0 + 1.35633680555554*G0_1_1;
    A[390] = -0.31863150352733*G0_0_0 - 0.47148850859788*G0_0_1 - 0.471488508597883*G0_1_0 + 0.387524801587314*G0_1_1;
    A[391] = 0.32724316578483*G0_0_0 - 0.33154899691358*G0_0_1 - 0.331548996913577*G0_1_0 + 0.0430583112874724*G0_1_1;
    A[392] = -0.273420276675486*G0_0_0 + 0.0731991291887164*G0_0_1 + 0.0731991291887108*G0_1_0;
    A[393] = -1.80844907407405*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141089*G0_1_0 - 6.32957175925922*G0_1_1;
    A[394] = -0.387524801587312*G0_0_0 + 2.55120494378305*G0_0_1 + 2.55120494378304*G0_1_0 - 0.387524801587328*G0_1_1;
    A[395] = 1.42092427248678*G0_0_0 - 0.043058311287472*G0_0_1 - 0.0430583112874603*G0_1_0 - 0.0861166225749481*G0_1_1;
    A[396] = 8.65472056878302*G0_0_0 + 4.97323495370365*G0_0_1 + 4.97323495370365*G0_1_0 + 9.94646990740735*G0_1_1;
    A[397] = -5.87745949074071*G0_0_0 - 2.93872974537033*G0_0_1 - 2.93872974537034*G0_1_0 - 0.38752480158727*G0_1_1;
    A[398] = -2.02374063051141*G0_0_0 - 3.27243165784829*G0_0_1 - 3.27243165784827*G0_1_0 - 6.32957175925922*G0_1_1;
    A[399] = 0.107645778218692*G0_0_0 + 0.107645778218691*G0_0_1 + 0.107645778218697*G0_1_0 + 0.107645778218696*G0_1_1;
    A[400] = -0.053822889109347*G0_0_0;
    A[401] = -0.0538228891093534*G0_1_1;
    A[402] = 1.19486813822751*G0_0_0 + 0.572675540123456*G0_0_1 + 0.572675540123454*G0_1_0;
    A[403] = -3.81066054894177*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525573*G0_1_1;
    A[404] = 1.01187031525574*G0_0_0 - 1.40154803240738*G0_0_1 - 1.40154803240739*G0_1_0 - 3.81066054894176*G0_1_1;
    A[405] = -1.35169653248113e-14*G0_0_0 + 0.572675540123448*G0_0_1 + 0.572675540123431*G0_1_0 + 1.19486813822749*G0_1_1;
    A[406] = -0.419818535052912*G0_0_0 - 0.346619405864188*G0_0_1 - 0.346619405864177*G0_1_0 - 0.273420276675479*G0_1_1;
    A[407] = 1.03339947089947*G0_0_0 + 0.658792162698405*G0_0_1 + 0.658792162698404*G0_1_0 + 0.327243165784824*G0_1_1;
    A[408] = 1.01187031525572*G0_0_0 + 0.152857005070543*G0_0_1 + 0.152857005070552*G0_1_0 - 0.318631503527335*G0_1_1;
    A[409] = 1.17544862732188e-14*G0_0_0 - 0.572675540123448*G0_0_1 - 0.572675540123432*G0_1_0 + 0.210985725308645*G0_1_1;
    A[410] = -0.273420276675476*G0_0_0 - 0.346619405864195*G0_0_1 - 0.346619405864189*G0_1_0 - 0.419818535052887*G0_1_1;
    A[411] = 0.327243165784823*G0_0_0 + 0.658792162698407*G0_0_1 + 0.658792162698402*G0_1_0 + 1.03339947089946*G0_1_1;
    A[412] = -0.318631503527336*G0_0_0 + 0.152857005070542*G0_0_1 + 0.152857005070551*G0_1_0 + 1.01187031525574*G0_1_1;
    A[413] = 0.210985725308646*G0_0_0 - 0.572675540123456*G0_0_1 - 0.57267554012346*G0_1_0;
    A[414] = 1.42092427248676*G0_0_0 + 1.46398258377423*G0_0_1 + 1.46398258377422*G0_1_0 + 1.42092427248674*G0_1_1;
    A[415] = -0.387524801587285*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537033*G0_1_0 - 5.8774594907407*G0_1_1;
    A[416] = -1.80844907407408*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733684*G0_1_0 - 2.02374063051147*G0_1_1;
    A[417] = -5.87745949074071*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537033*G0_1_0 - 0.38752480158727*G0_1_1;
    A[418] = 8.65472056878301*G0_0_0 + 3.68148561507933*G0_0_1 + 3.68148561507933*G0_1_0 + 8.654720568783*G0_1_1;
    A[419] = -2.02374063051146*G0_0_0 + 1.24869102733686*G0_0_1 + 1.24869102733684*G0_1_0 - 1.80844907407407*G0_1_1;
    A[420] = 0.10764577821869*G0_0_0 + 0.107645778218691*G0_0_1 + 0.107645778218692*G0_1_0 + 0.107645778218692*G0_1_1;
    A[421] = 0.107645778218693*G0_0_0;
    A[422] = -0.215291556437385*G0_1_1;
    A[423] = -0.990341159611983*G0_0_0 - 0.262655698853612*G0_0_1 - 0.262655698853612*G0_1_0;
    A[424] = 2.02374063051145*G0_0_0 + 0.413359788359784*G0_0_1 + 0.413359788359787*G0_1_0 - 0.516699735449731*G0_1_1;
    A[425] = -3.96136463844793*G0_0_0 - 1.30897266313931*G0_0_1 - 1.30897266313931*G0_1_0 + 0.731991291887132*G0_1_1;
    A[426] = -1.66205081569664*G0_0_1 - 1.66205081569663*G0_1_0 - 2.82031938932978*G0_1_1;
    A[427] = -0.990341159611973*G0_0_0 - 0.727685460758357*G0_0_1 - 0.727685460758367*G0_1_0 - 0.465029761904752*G0_1_1;
    A[428] = 2.02374063051143*G0_0_0 + 1.61038084215164*G0_0_1 + 1.61038084215165*G0_1_0 + 0.680321318342139*G0_1_1;
    A[429] = -3.96136463844793*G0_0_0 - 2.65239197530861*G0_0_1 - 2.65239197530863*G0_1_0 - 0.611428020282182*G0_1_1;
    A[430] = 1.66205081569664*G0_0_1 + 1.66205081569663*G0_1_0 + 0.50378224206349*G0_1_1;
    A[431] = -0.142092427248667*G0_0_0 - 0.404748126102289*G0_0_1 - 0.404748126102287*G0_1_0 - 0.667403824955907*G0_1_1;
    A[432] = 0.0344466490299794*G0_0_0 + 0.103339947089942*G0_0_1 + 0.103339947089947*G0_1_0 - 0.344466490299826*G0_1_1;
    A[433] = 0.0344466490299793*G0_0_0 - 0.0688932980599632*G0_0_1 - 0.0688932980599678*G0_1_0 - 0.516699735449736*G0_1_1;
    A[434] = -0.142092427248675*G0_0_0 + 0.262655698853616*G0_0_1 + 0.262655698853619*G0_1_0;
    A[435] = 1.03339947089943*G0_0_0 + 1.37786596119927*G0_0_1 + 1.37786596119927*G0_1_0 + 2.75573192239857*G0_1_1;
    A[436] = -0.0861166225749284*G0_0_0 - 0.0430583112874657*G0_0_1 - 0.0430583112874657*G0_1_0 + 1.42092427248678*G0_1_1;
    A[437] = 1.03339947089945*G0_0_0 - 0.344466490299831*G0_0_1 - 0.34446649029983*G0_1_0 + 1.03339947089946*G0_1_1;
    A[438] = -2.02374063051141*G0_0_0 - 3.27243165784827*G0_0_1 - 3.27243165784829*G0_1_0 - 6.32957175925922*G0_1_1;
    A[439] = -2.02374063051146*G0_0_0 + 1.24869102733684*G0_0_1 + 1.24869102733686*G0_1_0 - 1.80844907407407*G0_1_1;
    A[440] = 7.92272927689586*G0_0_0 + 3.96136463844793*G0_0_1 + 3.96136463844793*G0_1_0 + 7.06156305114633*G0_1_1;
}

/// Constructor
poisson2d_5_cell_integral_1_otherwise::poisson2d_5_cell_integral_1_otherwise() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
poisson2d_5_cell_integral_1_otherwise::~poisson2d_5_cell_integral_1_otherwise()
{
    // Do nothing
}

/// Tabulate which form coefficients are used by this integral
const std::vector<bool> & poisson2d_5_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true});
    return enabled;
}

/// Tabulate the tensor for the contribution from a local cell
void poisson2d_5_cell_integral_1_otherwise::tabulate_tensor(double*  A,
                                    const double * const *  w,
                                    const double*  vertex_coordinates,
                                    int cell_orientation) const
{
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    21
    // Number of operations (multiply-add pairs) for tensor contraction: 430
    // Total number of operations (multiply-add pairs):                  454
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00138945256132761*G0_0 + 0.000123877456776765*G0_1 + 0.000123877456776765*G0_2 + 0.000363647010782439*G0_3 + 0.000207201813104596*G0_4 + 0.000207201813104597*G0_5 + 0.000363647010782438*G0_6 + 0.00118136348605102*G0_7 - 0.000958243145743178*G0_8 + 0.000462681126743636*G0_9 - 2.29644326866568e-05*G0_10 + 0.00118136348605102*G0_11 - 0.000958243145743178*G0_12 + 0.000462681126743638*G0_13 - 2.29644326866555e-05*G0_14 + 0.000892481361231364*G0_15 - 0.000974683591871135*G0_16 + 0.000879433388113953*G0_17 - 0.000974683591871131*G0_18 + 0.000649789061247419*G0_19 + 0.000879433388113951*G0_20;
    A[1] = 0.000123877456776765*G0_0 + 0.00138945256132761*G0_1 + 0.000123877456776766*G0_2 + 0.00118136348605102*G0_3 - 0.000958243145743182*G0_4 + 0.000462681126743644*G0_5 - 2.2964432686658e-05*G0_6 + 0.000363647010782441*G0_7 + 0.000207201813104595*G0_8 + 0.000207201813104599*G0_9 + 0.000363647010782438*G0_10 - 2.29644326866539e-05*G0_11 + 0.000462681126743647*G0_12 - 0.000958243145743182*G0_13 + 0.00118136348605103*G0_14 + 0.000879433388113976*G0_15 - 0.000974683591871122*G0_16 + 0.00089248136123139*G0_17 + 0.000649789061247416*G0_18 - 0.000974683591871126*G0_19 + 0.00087943338811397*G0_20;
    A[2] = 0.000123877456776765*G0_0 + 0.000123877456776766*G0_1 + 0.00138945256132761*G0_2 - 2.29644326866539e-05*G0_3 + 0.000462681126743638*G0_4 - 0.000958243145743175*G0_5 + 0.00118136348605102*G0_6 - 2.29644326866545e-05*G0_7 + 0.000462681126743639*G0_8 - 0.000958243145743178*G0_9 + 0.00118136348605102*G0_10 + 0.000363647010782442*G0_11 + 0.0002072018131046*G0_12 + 0.000207201813104598*G0_13 + 0.00036364701078244*G0_14 + 0.000879433388113975*G0_15 + 0.000649789061247419*G0_16 + 0.00087943338811397*G0_17 - 0.000974683591871126*G0_18 - 0.00097468359187113*G0_19 + 0.000892481361231379*G0_20;
    A[3] = 0.000363647010782439*G0_0 + 0.00118136348605102*G0_1 - 2.29644326866539e-05*G0_2 + 0.0147050657033301*G0_3 - 0.00958373625474353*G0_4 + 0.00770482812583532*G0_5 - 0.00396984582097443*G0_6 - 0.000411011153198678*G0_7 - 0.00144832501603339*G0_8 - 4.56679059109682e-05*G0_9 - 0.00248237688558877*G0_10 - 0.00248237688558878*G0_11 + 0.00576068013134009*G0_12 - 0.00735253285166507*G0_13 + 0.00735253285166507*G0_14 + 0.00078287838704508*G0_15 - 0.00381653213684479*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 + 9.78597983806315e-05*G0_19 - 0.00280531422024486*G0_20;
    A[4] = 0.000207201813104596*G0_0 - 0.000958243145743182*G0_1 + 0.000462681126743638*G0_2 - 0.00958373625474353*G0_3 + 0.0220771705146713*G0_4 - 0.0134785562302928*G0_5 + 0.00770482812583534*G0_6 - 0.00144832501603339*G0_7 + 0.00281836219336229*G0_8 - 0.00135698920421147*G0_9 + 0.00576068013134005*G0_10 - 4.56679059109496e-05*G0_11 - 0.00135698920421148*G0_12 + 0.0029488419245365*G0_13 - 0.00735253285166506*G0_14 + 0.00313151354818033*G0_15 - 0.00548014870931554*G0_16 - 0.00143527704291599*G0_17 - 0.000587158790283811*G0_18 + 0.00528442911255429*G0_19 + 0.00508870951579302*G0_20;
    A[5] = 0.000207201813104597*G0_0 + 0.000462681126743644*G0_1 - 0.000958243145743175*G0_2 + 0.00770482812583532*G0_3 - 0.0134785562302928*G0_4 + 0.0220771705146713*G0_5 - 0.00958373625474352*G0_6 - 4.56679059109687e-05*G0_7 - 0.00135698920421146*G0_8 + 0.00294884192453647*G0_9 - 0.00735253285166504*G0_10 - 0.0014483250160334*G0_11 + 0.00281836219336231*G0_12 - 0.00135698920421148*G0_13 + 0.00576068013134005*G0_14 + 0.00313151354818033*G0_15 - 0.000587158790283832*G0_16 + 0.00508870951579303*G0_17 - 0.00548014870931556*G0_18 + 0.0052844291125543*G0_19 - 0.00143527704291597*G0_20;
    A[6] = 0.000363647010782438*G0_0 - 2.29644326866579e-05*G0_1 + 0.00118136348605102*G0_2 - 0.00396984582097443*G0_3 + 0.00770482812583534*G0_4 - 0.00958373625474352*G0_5 + 0.0147050657033301*G0_6 - 0.00248237688558878*G0_7 + 0.00576068013134005*G0_8 - 0.00735253285166505*G0_9 + 0.00735253285166505*G0_10 - 0.000411011153198661*G0_11 - 0.0014483250160334*G0_12 - 4.56679059109575e-05*G0_13 - 0.00248237688558878*G0_14 + 0.000782878387045073*G0_15 - 0.00137003717732888*G0_16 - 0.00280531422024488*G0_17 - 0.00381653213684476*G0_18 + 9.7859798380642e-05*G0_19 + 0.0102426588971731*G0_20;
    A[7] = 0.00118136348605102*G0_0 + 0.000363647010782441*G0_1 - 2.29644326866545e-05*G0_2 - 0.000411011153198678*G0_3 - 0.00144832501603339*G0_4 - 4.56679059109689e-05*G0_5 - 0.00248237688558878*G0_6 + 0.0147050657033301*G0_7 - 0.00958373625474352*G0_8 + 0.00770482812583533*G0_9 - 0.00396984582097444*G0_10 + 0.00735253285166505*G0_11 - 0.00735253285166505*G0_12 + 0.00576068013134006*G0_13 - 0.00248237688558879*G0_14 + 0.0102426588971732*G0_15 - 0.00381653213684478*G0_16 + 0.000782878387045078*G0_17 + 9.78597983806186e-05*G0_18 - 0.00137003717732889*G0_19 - 0.00280531422024487*G0_20;
    A[8] = -0.000958243145743178*G0_0 + 0.000207201813104595*G0_1 + 0.000462681126743639*G0_2 - 0.00144832501603339*G0_3 + 0.00281836219336229*G0_4 - 0.00135698920421147*G0_5 + 0.00576068013134005*G0_6 - 0.00958373625474352*G0_7 + 0.0220771705146712*G0_8 - 0.0134785562302928*G0_9 + 0.00770482812583534*G0_10 - 0.00735253285166504*G0_11 + 0.00294884192453647*G0_12 - 0.00135698920421148*G0_13 - 4.56679059109633e-05*G0_14 - 0.00143527704291601*G0_15 - 0.00548014870931555*G0_16 + 0.0031315135481803*G0_17 + 0.0052844291125543*G0_18 - 0.000587158790283819*G0_19 + 0.00508870951579298*G0_20;
    A[9] = 0.000462681126743636*G0_0 + 0.0002072018131046*G0_1 - 0.000958243145743178*G0_2 - 4.56679059109682e-05*G0_3 - 0.00135698920421147*G0_4 + 0.00294884192453647*G0_5 - 0.00735253285166505*G0_6 + 0.00770482812583533*G0_7 - 0.0134785562302928*G0_8 + 0.0220771705146713*G0_9 - 0.00958373625474355*G0_10 + 0.00576068013134005*G0_11 - 0.00135698920421147*G0_12 + 0.0028183621933623*G0_13 - 0.0014483250160334*G0_14 + 0.00508870951579306*G0_15 - 0.000587158790283817*G0_16 + 0.00313151354818034*G0_17 + 0.00528442911255427*G0_18 - 0.00548014870931555*G0_19 - 0.00143527704291596*G0_20;
    A[10] = -2.29644326866567e-05*G0_0 + 0.000363647010782438*G0_1 + 0.00118136348605102*G0_2 - 0.00248237688558877*G0_3 + 0.00576068013134005*G0_4 - 0.00735253285166504*G0_5 + 0.00735253285166505*G0_6 - 0.00396984582097444*G0_7 + 0.00770482812583534*G0_8 - 0.00958373625474355*G0_9 + 0.0147050657033301*G0_10 - 0.00248237688558878*G0_11 - 4.56679059109584e-05*G0_12 - 0.0014483250160334*G0_13 - 0.000411011153198662*G0_14 - 0.0028053142202449*G0_15 - 0.00137003717732888*G0_16 + 0.000782878387045079*G0_17 + 9.78597983806383e-05*G0_18 - 0.00381653213684477*G0_19 + 0.0102426588971731*G0_20;
    A[11] = 0.00118136348605102*G0_0 - 2.29644326866539e-05*G0_1 + 0.000363647010782442*G0_2 - 0.00248237688558878*G0_3 - 4.56679059109497e-05*G0_4 - 0.0014483250160334*G0_5 - 0.000411011153198661*G0_6 + 0.00735253285166505*G0_7 - 0.00735253285166504*G0_8 + 0.00576068013134005*G0_9 - 0.00248237688558878*G0_10 + 0.0147050657033301*G0_11 - 0.00958373625474354*G0_12 + 0.00770482812583536*G0_13 - 0.00396984582097444*G0_14 + 0.0102426588971732*G0_15 + 9.7859798380627e-05*G0_16 - 0.00280531422024484*G0_17 - 0.00381653213684478*G0_18 - 0.00137003717732887*G0_19 + 0.000782878387045111*G0_20;
    A[12] = -0.000958243145743178*G0_0 + 0.000462681126743647*G0_1 + 0.0002072018131046*G0_2 + 0.00576068013134009*G0_3 - 0.00135698920421148*G0_4 + 0.00281836219336231*G0_5 - 0.0014483250160334*G0_6 - 0.00735253285166505*G0_7 + 0.00294884192453647*G0_8 - 0.00135698920421147*G0_9 - 4.56679059109584e-05*G0_10 - 0.00958373625474354*G0_11 + 0.0220771705146713*G0_12 - 0.0134785562302928*G0_13 + 0.00770482812583538*G0_14 - 0.00143527704291595*G0_15 + 0.00528442911255429*G0_16 + 0.00508870951579309*G0_17 - 0.00548014870931556*G0_18 - 0.000587158790283808*G0_19 + 0.00313151354818035*G0_20;
    A[13] = 0.000462681126743638*G0_0 - 0.000958243145743182*G0_1 + 0.000207201813104598*G0_2 - 0.00735253285166507*G0_3 + 0.0029488419245365*G0_4 - 0.00135698920421148*G0_5 - 4.5667905910958e-05*G0_6 + 0.00576068013134007*G0_7 - 0.00135698920421148*G0_8 + 0.0028183621933623*G0_9 - 0.0014483250160334*G0_10 + 0.00770482812583536*G0_11 - 0.0134785562302928*G0_12 + 0.0220771705146713*G0_13 - 0.00958373625474357*G0_14 + 0.00508870951579306*G0_15 + 0.0052844291125543*G0_16 - 0.00143527704291599*G0_17 - 0.000587158790283811*G0_18 - 0.00548014870931556*G0_19 + 0.00313151354818033*G0_20;
    A[14] = -2.29644326866554e-05*G0_0 + 0.00118136348605103*G0_1 + 0.00036364701078244*G0_2 + 0.00735253285166507*G0_3 - 0.00735253285166506*G0_4 + 0.00576068013134005*G0_5 - 0.00248237688558878*G0_6 - 0.00248237688558879*G0_7 - 4.56679059109632e-05*G0_8 - 0.0014483250160334*G0_9 - 0.000411011153198661*G0_10 - 0.00396984582097444*G0_11 + 0.00770482812583538*G0_12 - 0.00958373625474357*G0_13 + 0.0147050657033301*G0_14 - 0.00280531422024488*G0_15 + 9.7859798380624e-05*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 - 0.00381653213684476*G0_19 + 0.000782878387045086*G0_20;
    A[15] = 0.000892481361231365*G0_0 + 0.000879433388113976*G0_1 + 0.000879433388113975*G0_2 + 0.00078287838704508*G0_3 + 0.00313151354818033*G0_4 + 0.00313151354818033*G0_5 + 0.000782878387045073*G0_6 + 0.0102426588971732*G0_7 - 0.00143527704291601*G0_8 + 0.00508870951579306*G0_9 - 0.0028053142202449*G0_10 + 0.0102426588971732*G0_11 - 0.00143527704291595*G0_12 + 0.00508870951579306*G0_13 - 0.00280531422024487*G0_14 + 0.0704590548340574*G0_15 - 0.0156575677409016*G0_16 + 0.0117431758056762*G0_17 - 0.0156575677409016*G0_18 + 0.0039143919352254*G0_19 + 0.0117431758056762*G0_20;
    A[16] = -0.000974683591871135*G0_0 - 0.000974683591871122*G0_1 + 0.000649789061247419*G0_2 - 0.00381653213684479*G0_3 - 0.00548014870931554*G0_4 - 0.000587158790283832*G0_5 - 0.00137003717732888*G0_6 - 0.00381653213684478*G0_7 - 0.00548014870931555*G0_8 - 0.000587158790283815*G0_9 - 0.00137003717732888*G0_10 + 9.78597983806265e-05*G0_11 + 0.00528442911255429*G0_12 + 0.0052844291125543*G0_13 + 9.78597983806244e-05*G0_14 - 0.0156575677409016*G0_15 + 0.0763306427368953*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 - 0.0117431758056762*G0_19 + 0.0039143919352254*G0_20;
    A[17] = 0.000879433388113953*G0_0 + 0.00089248136123139*G0_1 + 0.00087943338811397*G0_2 + 0.0102426588971732*G0_3 - 0.00143527704291599*G0_4 + 0.00508870951579303*G0_5 - 0.00280531422024488*G0_6 + 0.000782878387045078*G0_7 + 0.0031315135481803*G0_8 + 0.00313151354818034*G0_9 + 0.000782878387045079*G0_10 - 0.00280531422024484*G0_11 + 0.00508870951579309*G0_12 - 0.00143527704291599*G0_13 + 0.0102426588971732*G0_14 + 0.0117431758056762*G0_15 - 0.0156575677409016*G0_16 + 0.0704590548340572*G0_17 + 0.00391439193522537*G0_18 - 0.0156575677409016*G0_19 + 0.0117431758056762*G0_20;
    A[18] = -0.000974683591871131*G0_0 + 0.000649789061247416*G0_1 - 0.000974683591871126*G0_2 - 0.00137003717732889*G0_3 - 0.000587158790283811*G0_4 - 0.00548014870931556*G0_5 - 0.00381653213684476*G0_6 + 9.78597983806186e-05*G0_7 + 0.00528442911255429*G0_8 + 0.00528442911255427*G0_9 + 9.78597983806388e-05*G0_10 - 0.00381653213684478*G0_11 - 0.00548014870931557*G0_12 - 0.00058715879028381*G0_13 - 0.00137003717732889*G0_14 - 0.0156575677409016*G0_15 - 0.0117431758056762*G0_16 + 0.00391439193522537*G0_17 + 0.0763306427368953*G0_18 - 0.0117431758056762*G0_19 - 0.0156575677409016*G0_20;
    A[19] = 0.000649789061247419*G0_0 - 0.000974683591871126*G0_1 - 0.00097468359187113*G0_2 + 9.78597983806303e-05*G0_3 + 0.00528442911255429*G0_4 + 0.0052844291125543*G0_5 + 9.78597983806421e-05*G0_6 - 0.00137003717732889*G0_7 - 0.000587158790283818*G0_8 - 0.00548014870931555*G0_9 - 0.00381653213684477*G0_10 - 0.00137003717732887*G0_11 - 0.000587158790283809*G0_12 - 0.00548014870931556*G0_13 - 0.00381653213684476*G0_14 + 0.00391439193522541*G0_15 - 0.0117431758056762*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 + 0.0763306427368953*G0_19 - 0.0156575677409016*G0_20;
    A[20] = 0.000879433388113951*G0_0 + 0.00087943338811397*G0_1 + 0.000892481361231379*G0_2 - 0.00280531422024486*G0_3 + 0.00508870951579302*G0_4 - 0.00143527704291597*G0_5 + 0.0102426588971731*G0_6 - 0.00280531422024487*G0_7 + 0.00508870951579298*G0_8 - 0.00143527704291596*G0_9 + 0.0102426588971731*G0_10 + 0.000782878387045111*G0_11 + 0.00313151354818035*G0_12 + 0.00313151354818033*G0_13 + 0.000782878387045086*G0_14 + 0.0117431758056762*G0_15 + 0.0039143919352254*G0_16 + 0.0117431758056762*G0_17 - 0.0156575677409016*G0_18 - 0.0156575677409017*G0_19 + 0.0704590548340572*G0_20;
}

/// Constructor
poisson2d_5_form_0::poisson2d_5_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson2d_5_form_0::~poisson2d_5_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson2d_5_form_0::signature() const
{
    return "e88c5396a60bd3055e045b314bd929cd9dc7eefa5ea101af566570317a9c3e1d569987a64a6c76a5b60e6491de0557a46720df9852e20affb824013861f47613";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t poisson2d_5_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t poisson2d_5_form_0::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
std::size_t poisson2d_5_form_0::num_coefficients() const
{
    return 0;
}

/// Return the number of cell domains
std::size_t poisson2d_5_form_0::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson2d_5_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson2d_5_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson2d_5_form_0::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson2d_5_form_0::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson2d_5_form_0::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson2d_5_form_0::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson2d_5_form_0::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson2d_5_form_0::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson2d_5_form_0::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson2d_5_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson2d_5_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson2d_5_form_0::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson2d_5_form_0::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson2d_5_form_0::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson2d_5_form_0::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson2d_5_form_0::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson2d_5_form_0::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_0_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson2d_5_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson2d_5_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson2d_5_form_0::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson2d_5_form_0::create_default_custom_integral() const
{
    return 0;
}


/// Constructor
poisson2d_5_form_1::poisson2d_5_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
poisson2d_5_form_1::~poisson2d_5_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* poisson2d_5_form_1::signature() const
{
    return "f3c4cfd5ce2d317cbaf2fa686e9e30381be1f50f9fdebebf1f2c812bae32d133be9a5559a587c69fbdd688c2a08a785479227343f381262b45bb639b8cb2a941";
}

/// Return original coefficient position for each coefficient (0 <= i < n)
std::size_t poisson2d_5_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0});
    return position[i];
}

/// Return the rank of the global tensor (r)
std::size_t poisson2d_5_form_1::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
std::size_t poisson2d_5_form_1::num_coefficients() const
{
    return 1;
}

/// Return the number of cell domains
std::size_t poisson2d_5_form_1::num_cell_domains() const
{
    return 0;
}

/// Return the number of exterior facet domains
std::size_t poisson2d_5_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
std::size_t poisson2d_5_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Return the number of point domains
std::size_t poisson2d_5_form_1::num_point_domains() const
{
    return 0;
}

/// Return the number of custom domains
std::size_t poisson2d_5_form_1::num_custom_domains() const
{
    return 0;
}

/// Return whether the form has any cell integrals
bool poisson2d_5_form_1::has_cell_integrals() const
{
    return true;
}

/// Return whether the form has any exterior facet integrals
bool poisson2d_5_form_1::has_exterior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any interior facet integrals
bool poisson2d_5_form_1::has_interior_facet_integrals() const
{
    return false;
}

/// Return whether the form has any point integrals
bool poisson2d_5_form_1::has_point_integrals() const
{
    return false;
}

/// Return whether the form has any custom integrals
bool poisson2d_5_form_1::has_custom_integrals() const
{
    return false;
}

/// Create a new finite element for argument function i
ufc::finite_element* poisson2d_5_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* poisson2d_5_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* poisson2d_5_form_1::create_cell_integral(std::size_t i) const
{
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* poisson2d_5_form_1::create_exterior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* poisson2d_5_form_1::create_interior_facet_integral(std::size_t i) const
{
    return 0;
}

/// Create a new point integral on sub domain i
ufc::point_integral* poisson2d_5_form_1::create_point_integral(std::size_t i) const
{
    return 0;
}

/// Create a new custom integral on sub domain i
ufc::custom_integral* poisson2d_5_form_1::create_custom_integral(std::size_t i) const
{
    return 0;
}

/// Create a new cell integral on everywhere else
ufc::cell_integral* poisson2d_5_form_1::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_1_otherwise();
}

/// Create a new exterior facet integral on everywhere else
ufc::exterior_facet_integral* poisson2d_5_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

/// Create a new interior facet integral on everywhere else
ufc::interior_facet_integral* poisson2d_5_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

/// Create a new point integral on everywhere else
ufc::point_integral* poisson2d_5_form_1::create_default_point_integral() const
{
    return 0;
}

/// Create a new custom integral on everywhere else
ufc::custom_integral* poisson2d_5_form_1::create_default_custom_integral() const
{
    return 0;
}


