// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=intersection, header=IntersectionOperator.h)
%feature("docstring")  dolfin::IntersectionOperator::IntersectionOperator "
**Overloaded versions**

* IntersectionOperator\ (_mesh, \"SimpleCartesian\")

  Create intersection detector for a given mesh
  
  
  @param kernel_type The CGAL geometric kernel is used to compute predicates,
  intersections and such. Depending on this choice the kernel
  (kernel_type = \"ExcactPredicates\") can compute predicates excactly
  (without roundoff error) or only approximately (default, kernel_type =
  \"SimpleCartesian\").

* IntersectionOperator\ (labels, label, \"SimpleCartesian\")

  Create  IntersectionOperator for a given mesh
  
  *Arguments*
      labels (_MeshFunction<std::size_t>_)
          A MeshFunction over entities labeling the part of the Mesh
          for which the distance will be measured to
  
      label (std::size_t)
          The label determining the part of the mesh for which
          the distance will be measured to
  
      kernel_type (str)
          The CGAL geometric kernel which is used to compute predicates,
          intersections and such. Depending on this choice the kernel
          (kernel_type = \"ExcactPredicates\") can compute predicates
          excactly (without roundoff error) or only approximately
          default value is \"SimpleCartesian\".

* IntersectionOperator\ (labels, label, kernel_type=\"SimpleCartesian\")

  Create IntersectionOperator for a given mesh (shared data)
  
  *Arguments*
      labels (_MeshFunction<std::size_t>_)
          A MeshFunction over facets labeling the part of the Boundary
          for which the distance will be measured to
  
      label (std::size_t)
          The label determining the part of the mesh for which
          the distance will be measured to
  
      kernel_type (str)
          The CGAL geometric kernel which is used to compute predicates,
          intersections and such. Depending on this choice the kernel
          (kernel_type = \"ExcactPredicates\") can compute predicates
          excactly (without roundoff error) or only approximately
          default value is \"SimpleCartesian\".
";

%feature("docstring")  dolfin::IntersectionOperator::all_intersected_entities "
**Overloaded versions**

* all_intersected_entities\ (point, ids_result)

  Compute all id of all cells which are intersects by a \em point.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (points, ids_result)

  Compute all id of all cells which are intersects any point in \em points.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (entity, ids_result)

  Compute all id of all cells which are intersects by a \em entity.
  \param[out] ids_result The ids of the intersected entities are saved in a vector.
  This allows is more efficent than using a set and allows a map between
  the (external) cell and the intersected cell of the mesh. If you
  are only interested in intersection with a list of cells without caring about which
  cell what intersected by which one, use
  void IntersectionOperator::all_intersected_entities(const std::vector<Cell> &, std::set<std::size_t> &) const;
  @internal
  @todo This function has to improved: 1) it requires the object the
  mesh is to be cut with to be another mesh entitiy instead of being just a
  kind of geometric object. 2) Requires a runtime switch 3) would require a
  implementation for each geometric  primitive if they have no common base
  class.

* all_intersected_entities\ (entities, ids_result)

  Compute all id of all cells which are intersects by any of the entities in \em entities. This
  \param[out] ids_result The ids of the intersected set are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (another_mesh, ids_result)

  Compute all id of all cells which are intersects by the given mesh \em another_mesh;
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.
";

%feature("docstring")  dolfin::IntersectionOperator::any_intersected_entity "
Computes only the first id of the entity, which contains the point. Returns -1 if no cell is intersected.
@internal @remark This makes the function evaluation significantly faster.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point "
Computes the point inside the mesh which is closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_cell "
Computes the index of the cell inside the mesh which are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point_and_cell "
Computes the point inside the mesh and the corresponding cell index
that are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::distance "
Computes the distance between the given point and the nearest entity
";

%feature("docstring")  dolfin::IntersectionOperator::reset_kernel "
Rebuilds the underlying search structure from scratch and uses
the kernel kernel_type underlying CGAL Geometry kernel.
";

%feature("docstring")  dolfin::IntersectionOperator::clear "
Clears search structure. Should be used if the mesh has changed
";

// Documentation extracted from: (module=intersection, header=PrimitiveIntersector.h)
%feature("docstring")  dolfin::PrimitiveIntersector "
This class implements an intersection detection, detecting
whether two given (arbitrary) meshentities intersect.
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect "
**Overloaded versions**

* do_intersect\ (entity_1, entity_2)

  Computes whether two mesh entities intersect using an inexact
  geometry kernel which is fast but may suffer from floating
  point precision

* do_intersect\ (entity_1, point)

  Computes whether a mesh entity and point intersect using an
  inexact geometry kernel which is fast but may suffer from
  floating point precision
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect_exact "
**Overloaded versions**

* do_intersect_exact\ (entity_1, entity_2)

  Computes whether two mesh entities intersect using an exact
  geometry kernel which is slow but always correct

* do_intersect_exact\ (entity_1, point)

  Computes whether a mesh entity and point intersect using an
  exact geometry kernel which is slow but always correct
";

// Documentation extracted from: (module=intersection, header=PrimitiveTraits.h)
// Documentation extracted from: (module=intersection, header=MeshPrimitive.h)
%feature("docstring")  dolfin::getEntity "
Static, so only reference to a mesh and entity index have to be saved
";

%feature("docstring")  dolfin::MeshPrimitive "
**Overloaded versions**

* MeshPrimitive\ (entity)

  Create a MeshPrimitive from a given MeshEntityIterator

* MeshPrimitive\ (entity)

  Create a MeshPrimitive from a given SubsetIterator
";

