// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=common, header=init.h)
%feature("docstring")  dolfin::init "
Initialize DOLFIN (and PETSc) with command-line arguments. This
should not be needed in most cases since the initialization is
otherwise handled automatically.
";

// Documentation extracted from: (module=common, header=defines.h)
// Documentation extracted from: (module=common, header=types.h)
// Documentation extracted from: (module=common, header=constants.h)
// Documentation extracted from: (module=common, header=timing.h)
%feature("docstring")  dolfin::tic "
Timing functions measure CPU time as determined by clock(),
the precision of which seems to be 0.01 seconds.
Start timing (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::toc "
Return elapsed CPU time (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::time "
Return current CPU time used by process
";

%feature("docstring")  dolfin::timings "
Return a summary of timings and tasks in a Table, optionally clearing
stored timings
";

%feature("docstring")  dolfin::list_timings "
List a summary of timings and tasks, optionally clearing stored timings
";

%feature("docstring")  dolfin::summary "
This function is deprecated, use list_timings
";

%feature("docstring")  dolfin::timing "
Return timing (average) for given task, optionally clearing timing
for task
";

// Documentation extracted from: (module=common, header=Array.h)
%feature("docstring")  dolfin::Array "
This class provides a simple wrapper for a pointer to an array. A
purpose of this class is to enable the simple and safe exchange
of data between C++ and Python.
";

%feature("docstring")  dolfin::Array::Array "
**Overloaded versions**

* Array\ (N)

  Create array of size N. Array has ownership.

* Array\ (N, x)

  Construct array from a pointer. Array does not take ownership.

* Array\ (other)

  Disable copy construction, to avoid unanticipated sharing or
  copying of data. This means that an Array must always be passed as
  reference, or as a (possibly shared) pointer.
";

%feature("docstring")  dolfin::Array::str "
Return informal string representation (pretty-print).
Note that the Array class is not a subclass of Variable (for
efficiency) which means that one needs to call str() directly
instead of using the info() function on Array objects.
";

%feature("docstring")  dolfin::Array::size "
Return size of array
";

%feature("docstring")  dolfin::Array::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::Array::data "
**Overloaded versions**

* data\ ()

  Return pointer to data (const version)

* data\ ()

  Return pointer to data (non-const version)
";

// Documentation extracted from: (module=common, header=IndexSet.h)
%feature("docstring")  dolfin::IndexSet "
This class provides an efficient data structure for index sets.
The cost of checking whether a given index is in the set is O(1)
and very very fast (optimal) at the cost of extra storage.
";

%feature("docstring")  dolfin::IndexSet::IndexSet "
Create index set of given size
";

%feature("docstring")  dolfin::IndexSet::empty "
Return true if set is empty
";

%feature("docstring")  dolfin::IndexSet::size "
Return size of set
";

%feature("docstring")  dolfin::IndexSet::has_index "
Check whether index is in set
";

%feature("docstring")  dolfin::IndexSet::find "
Return position (if any) for given index
";

%feature("docstring")  dolfin::IndexSet::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Return given index

* operator[]\ (i)

  Return given index (const version)
";

%feature("docstring")  dolfin::IndexSet::insert "
Insert index into set
";

%feature("docstring")  dolfin::IndexSet::fill "
Fill index set with indices 0, 1, 2, ..., size - 1
";

%feature("docstring")  dolfin::IndexSet::clear "
Clear set
";

// Documentation extracted from: (module=common, header=Set.h)
%feature("docstring")  dolfin::Set::Set "
**Overloaded versions**

* Set\ ()

  Create empty set

* Set\ (x)

  Wrap std::vectpr as a set. Contents will be erased.

* Set\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::Set::find "
**Overloaded versions**

* find\ (x)

  Find entry in set and return an iterator to the entry

* find\ (x)

  Find entry in set and return an iterator to the entry (const)
";

%feature("docstring")  dolfin::Set::insert "
**Overloaded versions**

* insert\ (x)

  Insert entry

* insert\ (first, last)

  Insert entries
";

%feature("docstring")  dolfin::Set::size "
Set size
";

%feature("docstring")  dolfin::Set::erase "
Erase an entry
";

%feature("docstring")  dolfin::Set::sort "
Sort set
";

%feature("docstring")  dolfin::Set::clear "
Clear set
";

%feature("docstring")  dolfin::Set::operator[] "
Index the nth entry in the set
";

%feature("docstring")  dolfin::Set::set "
**Overloaded versions**

* set\ ()

  Return the vector that stores the data in the Set

* set\ ()

  Return the vector that stores the data in the Set
";

// Documentation extracted from: (module=common, header=Timer.h)
%feature("docstring")  dolfin::Timer "
A timer can be used for timing tasks. The basic usage is

  Timer timer(\"Assembling over cells\");

The timer is started at construction and timing ends
when the timer is destroyed (goes out of scope). It is
also possible to start and stop a timer explicitly by

  timer.start();
  timer.stop();

Timings are stored globally and a summary may be printed
by calling

  list_timings();
";

%feature("docstring")  dolfin::Timer::Timer "
Create timer
";

%feature("docstring")  dolfin::Timer::start "
Start timer
";

%feature("docstring")  dolfin::Timer::stop "
Stop timer
";

%feature("docstring")  dolfin::Timer::value "
Return value of timer (or time at start if not stopped)
";

// Documentation extracted from: (module=common, header=Variable.h)
%feature("docstring")  dolfin::Variable "
Common base class for DOLFIN variables.
";

%feature("docstring")  dolfin::Variable::Variable "
**Overloaded versions**

* Variable\ ()

  Create unnamed variable

* Variable\ (name, label)

  Create variable with given name and label

* Variable\ (variable)

  Copy constructor
";

%feature("docstring")  dolfin::Variable::rename "
Rename variable
";

%feature("docstring")  dolfin::Variable::name "
Return name
";

%feature("docstring")  dolfin::Variable::label "
Return label (description)
";

%feature("docstring")  dolfin::Variable::id "
Get unique identifier.

*Returns*
    _std::size_t_
        The unique integer identifier associated with the object.
";

%feature("docstring")  dolfin::Variable::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=common, header=Hierarchical.h)
%feature("docstring")  dolfin::Hierarchical "
This class provides storage and data access for hierarchical
classes; that is, classes where an object may have a child
and a parent.

Note to developers: each subclass of Hierarchical that
implements an assignment operator must call the base class
assignment operator at the *end* of the subclass assignment
operator. See the Mesh class for an example.
";

%feature("docstring")  dolfin::Hierarchical::Hierarchical "
Constructor
";

%feature("docstring")  dolfin::Hierarchical::depth "
Return depth of the hierarchy; that is, the total number of
objects in the hierarchy linked to the current object via
child-parent relationships, including the object itself.

*Returns*
    std::size_t
        The depth of the hierarchy.
";

%feature("docstring")  dolfin::Hierarchical::has_parent "
Check if the object has a parent.

*Returns*
    bool
        The return value is true iff the object has a parent.
";

%feature("docstring")  dolfin::Hierarchical::has_child "
Check if the object has a child.

*Returns*
    bool
        The return value is true iff the object has a child.
";

%feature("docstring")  dolfin::Hierarchical::parent "
**Overloaded versions**

* parent\ ()

  Return parent in hierarchy. An error is thrown if the object
  has no parent.
  
  *Returns*
      _Object_
          The parent object.

* parent\ ()

  Return parent in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::parent_shared_ptr "
**Overloaded versions**

* parent_shared_ptr\ ()

  Return shared pointer to parent. A zero pointer is returned if
  the object has no parent.
  
  *Returns*
      shared_ptr<T>
          The parent object.

* parent_shared_ptr\ ()

  Return shared pointer to parent (const version).
";

%feature("docstring")  dolfin::Hierarchical::child "
**Overloaded versions**

* child\ ()

  Return child in hierarchy. An error is thrown if the object
  has no child.
  
  *Returns*
      _T_
          The child object.

* child\ ()

  Return child in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::child_shared_ptr "
**Overloaded versions**

* child_shared_ptr\ ()

  Return shared pointer to child. A zero pointer is returned if
  the object has no child.
  
  *Returns*
      shared_ptr<T>
          The child object.

* child_shared_ptr\ ()

  Return shared pointer to child (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node "
**Overloaded versions**

* root_node\ ()

  Return root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node\ ()

  Return root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node_shared_ptr "
**Overloaded versions**

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node "
**Overloaded versions**

* leaf_node\ ()

  Return leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node\ ()

  Return leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node_shared_ptr "
**Overloaded versions**

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::set_parent "
Set parent
";

%feature("docstring")  dolfin::Hierarchical::clear_child "
Clear child
";

%feature("docstring")  dolfin::Hierarchical::set_child "
Set child
";

%feature("docstring")  dolfin::Hierarchical::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Hierarchical::_debug "
Function useful for debugging the hierarchy
";

// Documentation extracted from: (module=common, header=MPI.h)
%feature("docstring")  dolfin::MPICommunicator::MPICommunicator "
Create communicator (copy of MPI_COMM_WORLD)
";

%feature("docstring")  dolfin::MPICommunicator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MPINonblocking::send_recv "
**Overloaded versions**

* send_recv\ (send_value, dest, recv_value, source)

  Non-blocking send and receive

* send_recv\ (send_value, dest_tag, dest, recv_value, source_tag, source)

  Non-blocking send and receive with tag
";

%feature("docstring")  dolfin::MPINonblocking::wait_all "
Wait for all requests to finish
";

%feature("docstring")  dolfin::MPI "
This class provides utility functions for easy communcation
with MPI.
";

%feature("docstring")  dolfin::MPI::process_number "
Return proccess number
";

%feature("docstring")  dolfin::MPI::num_processes "
Return number of processes
";

%feature("docstring")  dolfin::MPI::is_broadcaster "
Determine whether we should broadcast (based on current parallel
policy)
";

%feature("docstring")  dolfin::MPI::is_receiver "
Determine whether we should receive (based on current parallel
policy)
";

%feature("docstring")  dolfin::MPI::barrier "
Set a barrier (synchronization point)
";

%feature("docstring")  dolfin::MPI::all_to_all "
Send in_values[p0] to process p0 and receive values from process
p1 in out_values[p1]
";

%feature("docstring")  dolfin::MPI::distribute "
Distribute local arrays on a group of processes (typically
neighbours from GenericDofMap::neighbours()). It is important
that each process' group includes exactly the processes that
has it in their groups, otherwise it will deadlock.
";

%feature("docstring")  dolfin::MPI::broadcast "
Broadcast value from broadcaster process to all processes
";

%feature("docstring")  dolfin::MPI::scatter "
Scatter in_values[i] to process i
";

%feature("docstring")  dolfin::MPI::gather "
Gather values on one process (wrapper for boost::mpi::gather)
";

%feature("docstring")  dolfin::MPI::all_gather "
Gather values, one from each process (wrapper for boost::mpi::all_gather)
";

%feature("docstring")  dolfin::MPI::max "
Return global max value
";

%feature("docstring")  dolfin::MPI::min "
Return global min value
";

%feature("docstring")  dolfin::MPI::sum "
Sum values and return sum
";

%feature("docstring")  dolfin::MPI::all_reduce "
All reduce
";

%feature("docstring")  dolfin::MPI::global_offset "
Find global offset (index) (wrapper for MPI_(Ex)Scan with MPI_SUM as
reduction op)
";

%feature("docstring")  dolfin::MPI::send_recv "
Send-receive data. Note that if the number of posted send-receives
may differ between processes, another interface (such as
MPINonblocking::send_recv) must be used since duplicating the
communicator requires participation from all processes.
";

%feature("docstring")  dolfin::MPI::local_range "
**Overloaded versions**

* local_range\ (N)

  Return local range for local process, splitting [0, N - 1] into
  num_processes() portions of almost equal size

* local_range\ (process, N)

  Return local range for given process, splitting [0, N - 1] into
  num_processes() portions of almost equal size

* local_range\ (process, N, num_processes)

  Return local range for given process, splitting [0, N - 1] into
  num_processes portions of almost equal size
";

%feature("docstring")  dolfin::MPI::index_owner "
Return which process owns index (inverse of local_range)
";

// Documentation extracted from: (module=common, header=SubSystemsManager.h)
%feature("docstring")  dolfin::SubSystemsManager "
This is a singleton class which manages the initialisation and
finalisation of various sub systems, such as MPI and PETSc.
";

%feature("docstring")  dolfin::SubSystemsManager::init_mpi "
**Overloaded versions**

* init_mpi\ ()

  Initialise MPI

* init_mpi\ (argc, argv[], required_thread_level)

  Initialise MPI with required level of thread support
";

%feature("docstring")  dolfin::SubSystemsManager::init_petsc "
**Overloaded versions**

* init_petsc\ ()

  Initialize PETSc without command-line arguments

* init_petsc\ (argc, argv[])

  Initialize PETSc with command-line arguments. Note that PETSc
  command-line arguments may also be filtered and sent to PETSc
  by parameters.parse(argc, argv).
";

%feature("docstring")  dolfin::SubSystemsManager::finalize "
Finalize subsytems. This will be called by the destructor, but in
special cases it may be necessary to call finalize() explicitly.
";

%feature("docstring")  dolfin::SubSystemsManager::responsible_mpi "
Return true if DOLFIN intialised MPI (and is therefore responsible
for finalization)
";

%feature("docstring")  dolfin::SubSystemsManager::responsible_petsc "
Return true if DOLFIN intialised PETSc (and is therefore
responsible for finalization)
";

%feature("docstring")  dolfin::SubSystemsManager::mpi_initialized "
Check if MPI has been initialised (returns true if MPI has been
initialised, even if it is later finalised)
";

%feature("docstring")  dolfin::SubSystemsManager::mpi_finalized "
Check if MPI has been finalized (returns true if MPI has been
finalised)
";

