// This code conforms with the UFC specification version 2.1.0+
// and was automatically generated by FFC version 1.1.0+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON_H
#define __POISSON_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[2];
      y[1] = vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[4];
      y[1] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[2];
    y[1] = vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[4];
    y[1] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new poisson_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  poisson_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 3*num_global_entities[2];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = 3*c.entity_indices[2][0];
    dofs[1] = 3*c.entity_indices[2][0] + 1;
    dofs[2] = 3*c.entity_indices[2][0] + 2;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[1][0] = vertex_coordinates[2];
    dof_coordinates[1][1] = vertex_coordinates[3];
    dof_coordinates[2][0] = vertex_coordinates[4];
    dof_coordinates[2][1] = vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new poisson_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  poisson_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 11
    // Total number of operations (multiply-add pairs):                  22
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.5*G0_0_0 + 0.5*G0_0_1 + 0.5*G0_1_0 + 0.5*G0_1_1;
    A[1] = -0.5*G0_0_0 - 0.5*G0_1_0;
    A[2] = -0.5*G0_0_1 - 0.5*G0_1_1;
    A[3] = -0.5*G0_0_0 - 0.5*G0_0_1;
    A[4] = 0.5*G0_0_0;
    A[5] = 0.5*G0_0_1;
    A[6] = -0.5*G0_1_0 - 0.5*G0_1_1;
    A[7] = 0.5*G0_1_0;
    A[8] = 0.5*G0_1_1;
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class poisson_exterior_facet_integral_0_otherwise: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  poisson_exterior_facet_integral_0_otherwise() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_exterior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               std::size_t facet) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = vertex_coordinates[2*v1 + 0] - vertex_coordinates[2*v0 + 0];
    const double dx1 = vertex_coordinates[2*v1 + 1] - vertex_coordinates[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    const bool direction = dx1*(vertex_coordinates[2*facet] - vertex_coordinates[2*v0]) - dx0*(vertex_coordinates[2*facet + 1] - vertex_coordinates[2*v0 + 1]) < 0;
    // Compute facet normals from the facet scale factor constants
    const double n0 = direction ? dx1 / det : -dx1 / det;
    const double n1 = direction ? -dx0 / det : dx0 / det;
    
    // Cell volume
    const double volume = std::abs(detJ)/2.0;
    
    // Compute circumradius of triangle in 2D
    const double v1v2  = std::sqrt((vertex_coordinates[4] - vertex_coordinates[2])*(vertex_coordinates[4] - vertex_coordinates[2]) + (vertex_coordinates[5] - vertex_coordinates[3])*(vertex_coordinates[5] - vertex_coordinates[3]) );
    const double v0v2  = std::sqrt(J[3]*J[3] + J[1]*J[1]);
    const double v0v1  = std::sqrt(J[0]*J[0] + J[2]*J[2]);
    
    const double circumradius = 0.25*(v1v2*v0v2*v0v1)/(volume);
    
    // Facet area
    
    // Array of quadrature weights.
    static const double W2[2] = {0.5, 0.5};
    // Quadrature points on the UFC reference element: (0.211324865405187), (0.788675134594813)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0[2][2] = \
    {{0.788675134594813, 0.211324865405187},
    {0.211324865405187, 0.788675134594813}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {1, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc4[2] = {0, 1};
    
    static const double FE0_f0_D01[2][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 1};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 9; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 10.
    double G[3];
    G[0] = 4.0*det/circumradius;
    G[1] =  - det*(K[2]*n0 + K[3]*n1);
    G[2] =  - det*(K[0]*n0 + K[1]*n1);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    switch (facet)
    {
    case 0:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Number of operations to compute ip constants: 3
        double I[3];
        // Number of operations: 1
        I[0] = G[0]*W2[ip];
        
        // Number of operations: 1
        I[1] = G[1]*W2[ip];
        
        // Number of operations: 1
        I[2] = G[2]*W2[ip];
        
        
        // Number of operations for primary indices: 60
        for (unsigned int j = 0; j < 2; j++)
        {
          for (unsigned int k = 0; k < 2; k++)
          {
            // Number of operations to compute entry: 3
            A[nzc0[j]*3 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[0];
            // Number of operations to compute entry: 3
            A[nzc0[j]*3 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
            // Number of operations to compute entry: 3
            A[nzc0[j]*3 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
            // Number of operations to compute entry: 3
            A[nzc1[j]*3 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
            // Number of operations to compute entry: 3
            A[nzc2[j]*3 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
          }// end loop over 'k'
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 1:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Number of operations to compute ip constants: 3
        double I[3];
        // Number of operations: 1
        I[0] = G[1]*W2[ip];
        
        // Number of operations: 1
        I[1] = G[2]*W2[ip];
        
        // Number of operations: 1
        I[2] = G[0]*W2[ip];
        
        
        // Number of operations for primary indices: 60
        for (unsigned int j = 0; j < 2; j++)
        {
          for (unsigned int k = 0; k < 2; k++)
          {
            // Number of operations to compute entry: 3
            A[nzc1[j]*3 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
            // Number of operations to compute entry: 3
            A[nzc2[j]*3 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
            // Number of operations to compute entry: 3
            A[nzc3[j]*3 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
            // Number of operations to compute entry: 3
            A[nzc3[j]*3 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
            // Number of operations to compute entry: 3
            A[nzc3[j]*3 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[2];
          }// end loop over 'k'
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 2:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Number of operations to compute ip constants: 3
        double I[3];
        // Number of operations: 1
        I[0] = G[1]*W2[ip];
        
        // Number of operations: 1
        I[1] = G[2]*W2[ip];
        
        // Number of operations: 1
        I[2] = G[0]*W2[ip];
        
        
        // Number of operations for primary indices: 60
        for (unsigned int j = 0; j < 2; j++)
        {
          for (unsigned int k = 0; k < 2; k++)
          {
            // Number of operations to compute entry: 3
            A[nzc1[j]*3 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
            // Number of operations to compute entry: 3
            A[nzc2[j]*3 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
            // Number of operations to compute entry: 3
            A[nzc4[j]*3 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
            // Number of operations to compute entry: 3
            A[nzc4[j]*3 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
            // Number of operations to compute entry: 3
            A[nzc4[j]*3 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[2];
          }// end loop over 'k'
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class poisson_interior_facet_integral_0_otherwise: public ufc::interior_facet_integral
{
public:

  /// Constructor
  poisson_interior_facet_integral_0_otherwise() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_interior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates_0,
                               const double* vertex_coordinates_1,
                               std::size_t facet_0,
                               std::size_t facet_1) const
  {
    // Compute Jacobian
    double J_0[4];
    compute_jacobian_triangle_2d(J_0, vertex_coordinates_0);
    
    // Compute Jacobian inverse and determinant
    double K_0[4];
    double detJ_0;
    compute_jacobian_inverse_triangle_2d(K_0, detJ_0, J_0);
    
    // Compute Jacobian
    double J_1[4];
    compute_jacobian_triangle_2d(J_1, vertex_coordinates_1);
    
    // Compute Jacobian inverse and determinant
    double K_1[4];
    double detJ_1;
    compute_jacobian_inverse_triangle_2d(K_1, detJ_1, J_1);
    
    
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet_0][0];
    const unsigned int v1 = edge_vertices[facet_0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = vertex_coordinates_0[2*v1 + 0] - vertex_coordinates_0[2*v0 + 0];
    const double dx1 = vertex_coordinates_0[2*v1 + 1] - vertex_coordinates_0[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    const bool direction = dx1*(vertex_coordinates_0[2*facet_0] - vertex_coordinates_0[2*v0]) - dx0*(vertex_coordinates_0[2*facet_0 + 1] - vertex_coordinates_0[2*v0 + 1]) < 0;
    // Compute facet normals from the facet scale factor constants
    const double n_00 = direction ? dx1 / det : -dx1 / det;
    const double n_01 = direction ? -dx0 / det : dx0 / det;// Compute facet normals from the facet scale factor constants
    const double n_10 = !direction ? dx1 / det : -dx1 / det;
    const double n_11 = !direction ? -dx0 / det : dx0 / det;
    
    // Cell volume
    const double volume_0 = std::abs(detJ_0)/2.0;// Cell volume
    const double volume_1 = std::abs(detJ_1)/2.0;
    
    // Compute circumradius of triangle in 2D
    const double v1v2_0  = std::sqrt((vertex_coordinates_0[4] - vertex_coordinates_0[2])*(vertex_coordinates_0[4] - vertex_coordinates_0[2]) + (vertex_coordinates_0[5] - vertex_coordinates_0[3])*(vertex_coordinates_0[5] - vertex_coordinates_0[3]) );
    const double v0v2_0  = std::sqrt(J_0[3]*J_0[3] + J_0[1]*J_0[1]);
    const double v0v1_0  = std::sqrt(J_0[0]*J_0[0] + J_0[2]*J_0[2]);
    
    const double circumradius_0 = 0.25*(v1v2_0*v0v2_0*v0v1_0)/(volume_0);// Compute circumradius of triangle in 2D
    const double v1v2_1  = std::sqrt((vertex_coordinates_1[4] - vertex_coordinates_1[2])*(vertex_coordinates_1[4] - vertex_coordinates_1[2]) + (vertex_coordinates_1[5] - vertex_coordinates_1[3])*(vertex_coordinates_1[5] - vertex_coordinates_1[3]) );
    const double v0v2_1  = std::sqrt(J_1[3]*J_1[3] + J_1[1]*J_1[1]);
    const double v0v1_1  = std::sqrt(J_1[0]*J_1[0] + J_1[2]*J_1[2]);
    
    const double circumradius_1 = 0.25*(v1v2_1*v0v2_1*v0v1_1)/(volume_1);
    
    // Facet area
    
    // Array of quadrature weights.
    static const double W2[2] = {0.5, 0.5};
    // Quadrature points on the UFC reference element: (0.211324865405187), (0.788675134594813)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0[2][2] = \
    {{0.788675134594813, 0.211324865405187},
    {0.211324865405187, 0.788675134594813}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[2] = {1, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc4[2] = {0, 1};
    
    static const double FE0_f0_D01[2][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 1};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 36; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 61.
    double G[11];
    G[0] = 4.0*det*(n_10*n_10 + n_11*n_11)/(circumradius_0 + circumradius_1);
    G[1] = -0.5*det*(K_1[2]*n_10 + K_1[3]*n_11);
    G[2] = -0.5*det*(K_1[0]*n_10 + K_1[1]*n_11);
    G[3] = 4.0*det*(n_00*n_10 + n_01*n_11)/(circumradius_0 + circumradius_1);
    G[4] = -0.5*det*(K_0[2]*n_10 + K_0[3]*n_11);
    G[5] = -0.5*det*(K_0[0]*n_10 + K_0[1]*n_11);
    G[6] = -0.5*det*(K_1[2]*n_00 + K_1[3]*n_01);
    G[7] = -0.5*det*(K_1[0]*n_00 + K_1[1]*n_01);
    G[8] = 4.0*det*(n_00*n_00 + n_01*n_01)/(circumradius_0 + circumradius_1);
    G[9] = -0.5*det*(K_0[2]*n_00 + K_0[3]*n_01);
    G[10] = -0.5*det*(K_0[0]*n_00 + K_0[1]*n_01);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    switch (facet_0)
    {
    case 0:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[10]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[10]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[10]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc0[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc0[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc0[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc3[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*6 + nzc3[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc0[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc0[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc3[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 502
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 502
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 11
          double I[11];
          // Number of operations: 1
          I[0] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[8]*W2[ip];
          
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 2; j++)
          {
            for (unsigned int k = 0; k < 2; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 3)*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc1[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc2[j]*6 + nzc4[k]] += FE0_f0[ip][k]*FE0_f0_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc1[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc2[k] + 3)] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + (nzc4[k] + 3)] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc1[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc2[k]] += FE0_f0[ip][j]*FE0_f0_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc4[j]*6 + nzc4[k]] += FE0_f0[ip][j]*FE0_f0[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  poisson_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_cell_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    3
    // Number of operations (multiply-add pairs) for tensor contraction: 7
    // Total number of operations (multiply-add pairs):                  13
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0833333333333334*G0_0 + 0.0416666666666667*G0_1 + 0.0416666666666667*G0_2;
    A[1] = 0.0416666666666667*G0_0 + 0.0833333333333333*G0_1 + 0.0416666666666666*G0_2;
    A[2] = 0.0416666666666667*G0_0 + 0.0416666666666666*G0_1 + 0.0833333333333333*G0_2;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson_form_0: public ufc::form
{
public:

  /// Constructor
  poisson_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "579adac083481a61ee3fdfedfbc02b91eeae16b0d1710c52c622c43c65b975efaefd5b73cb5e1d2258e682ca28ef3f26e3bd354e23361a0ebf6348c9212eeed0";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new poisson_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return new poisson_exterior_facet_integral_0_otherwise();
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return new poisson_interior_facet_integral_0_otherwise();
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson_form_1: public ufc::form
{
public:

  /// Constructor
  poisson_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "112bdc92d46da896974d9dc1ceb38ea6be3ff74173bf7cc0a6d230fd36f1f33d971df80141bfa66ab7718e6e4f6fa97b6af007589e86bafd1748000ca6f389b6";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new poisson_cell_integral_1_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Restriction.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Poisson
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_f(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  CoefficientSpace_f(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~CoefficientSpace_f()
  {
  }

};

class Form_a_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_a_FunctionSpace_0()
  {
  }

};

class Form_a_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_a_FunctionSpace_1()
  {
  }

};

class Form_a: public dolfin::Form
{
public:

  // Constructor
  Form_a(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_0());
  }

  // Constructor
  Form_a(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_0());
  }

  // Destructor
  ~Form_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_L_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson_dofmap_0()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_L_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_L_FunctionSpace_1;

class Form_L: public dolfin::Form
{
public:

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson_form_1());
  }

  // Destructor
  ~Form_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_a BilinearForm;
typedef Form_a JacobianForm;
typedef Form_L LinearForm;
typedef Form_L ResidualForm;
typedef Form_a::TestSpace FunctionSpace;

}

#endif
