"""This module provides a time class in Python. It is typically used for
problems involving time stepping ."""

__author__ = "Garth N. Wells (gnw20@cam.ac.uk)"
__date__ = "2008-08-29 - 2010-04-30"
__copyright__ = "Copyright (C) 2008-2010 Garth N. Wells"
__license__  = "GNU LGPL Version 2.1"

__all__ = ["Time"]

class Time:
    def  __init__(self, value):
        self.value = value

    def __iadd__(self, value):
        self.value += value
        return self

    def __isub__(self, value):
        self.value -= value
        return self

    def __idiv__(self, value):
        self.value /= value
        return self

    def __imul__(self, value):
        self.value *= value
        return self

    def __mul__(self, value):
        return self.value*value

    def __div__(self, value):
        return self.value/value

    def __lt__(self, value):
        return self.value < value

    def __gt__(self, value):
        return self.value > value

    def __call__(self):
        return self.value

    def __float__(self):
        return self.value

    def __str__(self):
        return str(self.value)
