// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __POISSON2D_5_H
#define __POISSON2D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson2d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson2d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 21;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[21] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 5; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 1; s < 5 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 6 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[21][21] = \
    {{0.015432886097325, -0.009450674049235, -0.005456349206349, 0.030187530726696, 0.023383160753523, 0.013500274155551, -0.023199760582676, -0.019607376365131, -0.015187808424995, -0.008768685282571, 0.021389865125598, 0.018864087899848, 0.015943064150130, 0.012349444388194, 0.007129955041866, -0.017989175756004, -0.016271821710115, -0.014350397874316, -0.012128299820525, -0.009394540644541, -0.005423940570038},
    {0.015432886097325, 0.009450674049235, -0.005456349206349, 0.030187530726696, -0.023383160753523, 0.013500274155551, 0.023199760582676, -0.019607376365131, 0.015187808424995, -0.008768685282571, 0.021389865125598, -0.018864087899848, 0.015943064150130, -0.012349444388194, 0.007129955041866, 0.017989175756004, -0.016271821710115, 0.014350397874316, -0.012128299820525, 0.009394540644541, -0.005423940570038},
    {0.015432886097325, 0.000000000000000, 0.010912698412698, 0.000000000000000, 0.000000000000000, 0.040500822466653, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035074741130285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035649775209330, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.032543643420231},
    {0.035074741130285, 0.126008987323133, -0.084325396825397, 0.101882916202598, -0.028644371923066, 0.002025041123333, 0.077332535275586, -0.026143168486842, 0.000000000000000, 0.005845790188381, 0.035649775209330, 0.012576058599899, -0.038529071696146, 0.044252175724361, -0.029708146007775, 0.000000000000000, 0.032543643420231, -0.051661432347536, 0.058215839138519, -0.052609427609428, 0.032543643420230},
    {0.035074741130285, -0.032934167141273, 0.121527777777778, -0.011320324022511, 0.075410693430113, -0.022275452356659, 0.000000000000000, 0.104572673947367, -0.101252056166633, 0.058457901883808, 0.000000000000000, 0.056592263699545, -0.009300120754242, -0.040135694261629, 0.041591404410885, 0.000000000000000, 0.000000000000000, 0.051661432347536, -0.101877718492409, 0.118371212121212, -0.081359108550576},
    {0.035074741130285, 0.088779059250389, -0.089285714285714, 0.030187530726696, 0.043258847394018, -0.059401206284424, 0.000000000000000, 0.026143168486842, 0.101252056166633, -0.116915803767617, 0.000000000000000, 0.000000000000000, 0.074400966033938, -0.030873610970484, -0.011883258403110, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067918478994939, -0.131523569023569, 0.108478811400768},
    {0.035074741130285, -0.010023442173431, 0.151289682539682, 0.000000000000000, 0.050273795620075, 0.093151891673302, 0.000000000000000, 0.000000000000000, 0.050626028083316, 0.064303692072189, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.072038425597796, -0.023766516806220, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.065761784511785, -0.081359108550576},
    {0.035074741130285, -0.126008987323133, -0.084325396825397, 0.101882916202598, 0.028644371923066, 0.002025041123333, -0.077332535275586, -0.026143168486842, 0.000000000000000, 0.005845790188381, 0.035649775209330, -0.012576058599899, -0.038529071696147, -0.044252175724361, -0.029708146007775, 0.000000000000000, 0.032543643420230, 0.051661432347536, 0.058215839138519, 0.052609427609428, 0.032543643420231},
    {0.035074741130285, 0.032934167141273, 0.121527777777778, -0.011320324022511, -0.075410693430113, -0.022275452356659, 0.000000000000000, 0.104572673947367, 0.101252056166633, 0.058457901883808, 0.000000000000000, -0.056592263699545, -0.009300120754242, 0.040135694261630, 0.041591404410885, 0.000000000000000, 0.000000000000000, -0.051661432347536, -0.101877718492409, -0.118371212121212, -0.081359108550576},
    {0.035074741130285, -0.088779059250389, -0.089285714285714, 0.030187530726696, -0.043258847394018, -0.059401206284424, 0.000000000000000, 0.026143168486842, -0.101252056166633, -0.116915803767617, 0.000000000000000, 0.000000000000000, 0.074400966033938, 0.030873610970484, -0.011883258403110, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067918478994939, 0.131523569023569, 0.108478811400768},
    {0.035074741130285, 0.010023442173431, 0.151289682539682, 0.000000000000000, -0.050273795620075, 0.093151891673302, 0.000000000000000, 0.000000000000000, -0.050626028083316, 0.064303692072189, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.072038425597796, -0.023766516806220, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065761784511785, -0.081359108550576},
    {0.035074741130285, -0.136032429496564, -0.066964285714286, 0.036979725140202, 0.078918167543141, 0.060076219992202, -0.007733253527559, -0.045750544851973, -0.055688630891648, -0.037997636224476, -0.064169595376793, -0.012576058599899, 0.017271652829307, 0.027786249873436, 0.020201539285287, 0.089945878780019, 0.048815465130346, 0.020090557024042, 0.002425659964105, -0.005636724386724, -0.005423940570038},
    {0.035074741130285, 0.121713226391662, -0.032242063492063, -0.067167255866898, -0.032151846036095, 0.027675562018880, 0.139198563496054, 0.065357921217104, -0.010125205616663, -0.029228950941904, 0.042779730251196, -0.056592263699545, -0.033214716979437, 0.009262083291145, 0.020201539285287, -0.179891757560038, -0.032543643420231, 0.011480318299452, 0.009702639856420, -0.001878908128908, -0.005423940570038},
    {0.035074741130285, -0.121713226391662, -0.032242063492064, -0.067167255866898, 0.032151846036095, 0.027675562018880, -0.139198563496054, 0.065357921217104, 0.010125205616663, -0.029228950941904, 0.042779730251196, 0.056592263699545, -0.033214716979437, -0.009262083291145, 0.020201539285287, 0.179891757560038, -0.032543643420231, -0.011480318299452, 0.009702639856420, 0.001878908128908, -0.005423940570038},
    {0.035074741130285, 0.136032429496564, -0.066964285714286, 0.036979725140202, -0.078918167543141, 0.060076219992202, 0.007733253527559, -0.045750544851973, 0.055688630891648, -0.037997636224476, -0.064169595376793, 0.012576058599899, 0.017271652829307, -0.027786249873436, 0.020201539285287, -0.089945878780019, 0.048815465130346, -0.020090557024042, 0.002425659964105, 0.005636724386724, -0.005423940570038},
    {0.280597929042281, -0.214788046573522, -0.124007936507937, 0.090562592180087, 0.116915803767617, 0.000000000000000, 0.154665070551171, 0.078429505460525, 0.101252056166633, 0.081841062637332, -0.142599100837319, 0.025152117199798, -0.031886128300259, -0.107028518031012, -0.095066067224879, 0.000000000000000, -0.130174573680922, -0.103322864695072, -0.029107919569260, 0.026304713804714, 0.032543643420231},
    {0.035074741130285, 0.000000000000000, -0.124007936507936, -0.384891016765370, 0.000000000000000, 0.101252056166633, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.213898651255978, 0.000000000000000, 0.140830399992811, 0.000000000000000, -0.095066067224879, 0.000000000000000, 0.195261860521383, 0.000000000000000, -0.058215839138519, 0.000000000000000, 0.032543643420230},
    {0.280597929042281, 0.214788046573521, -0.124007936507936, 0.090562592180087, -0.116915803767617, 0.000000000000000, -0.154665070551171, 0.078429505460525, -0.101252056166633, 0.081841062637332, -0.142599100837319, -0.025152117199798, -0.031886128300259, 0.107028518031012, -0.095066067224879, 0.000000000000000, -0.130174573680922, 0.103322864695072, -0.029107919569260, -0.026304713804714, 0.032543643420231},
    {0.035074741130285, -0.107394023286761, 0.062003968253968, 0.011320324022511, -0.306903984889995, -0.253130140416582, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.000000000000000, 0.169776791098635, 0.009300120754242, 0.126581804978985, 0.172307246845093, 0.000000000000000, 0.000000000000000, 0.154984297042608, 0.101877718492409, -0.039457070707071, -0.081359108550576},
    {0.035074741130285, 0.107394023286761, 0.062003968253968, 0.011320324022511, 0.306903984889995, -0.253130140416582, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.000000000000000, -0.169776791098635, 0.009300120754242, -0.126581804978985, 0.172307246845093, 0.000000000000000, 0.000000000000000, -0.154984297042608, 0.101877718492409, 0.039457070707071, -0.081359108550576},
    {0.280597929042281, 0.000000000000000, 0.248015873015873, -0.060375061453391, 0.000000000000000, 0.135002741555510, 0.000000000000000, -0.052286336973683, 0.000000000000000, -0.210448446781710, 0.000000000000000, 0.000000000000000, -0.148801932067876, 0.000000000000000, -0.142599100837319, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.135836957989878, 0.000000000000000, 0.108478811400768}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 21; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[21] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 5; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 5; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 1; s < 5 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 6 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[21][21] = \
    {{0.015432886097325, -0.009450674049235, -0.005456349206349, 0.030187530726696, 0.023383160753523, 0.013500274155551, -0.023199760582676, -0.019607376365131, -0.015187808424995, -0.008768685282571, 0.021389865125598, 0.018864087899848, 0.015943064150130, 0.012349444388194, 0.007129955041866, -0.017989175756004, -0.016271821710115, -0.014350397874316, -0.012128299820525, -0.009394540644541, -0.005423940570038},
    {0.015432886097325, 0.009450674049235, -0.005456349206349, 0.030187530726696, -0.023383160753523, 0.013500274155551, 0.023199760582676, -0.019607376365131, 0.015187808424995, -0.008768685282571, 0.021389865125598, -0.018864087899848, 0.015943064150130, -0.012349444388194, 0.007129955041866, 0.017989175756004, -0.016271821710115, 0.014350397874316, -0.012128299820525, 0.009394540644541, -0.005423940570038},
    {0.015432886097325, 0.000000000000000, 0.010912698412698, 0.000000000000000, 0.000000000000000, 0.040500822466653, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035074741130285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.035649775209330, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.032543643420231},
    {0.035074741130285, 0.126008987323133, -0.084325396825397, 0.101882916202598, -0.028644371923066, 0.002025041123333, 0.077332535275586, -0.026143168486842, 0.000000000000000, 0.005845790188381, 0.035649775209330, 0.012576058599899, -0.038529071696146, 0.044252175724361, -0.029708146007775, 0.000000000000000, 0.032543643420231, -0.051661432347536, 0.058215839138519, -0.052609427609428, 0.032543643420230},
    {0.035074741130285, -0.032934167141273, 0.121527777777778, -0.011320324022511, 0.075410693430113, -0.022275452356659, 0.000000000000000, 0.104572673947367, -0.101252056166633, 0.058457901883808, 0.000000000000000, 0.056592263699545, -0.009300120754242, -0.040135694261629, 0.041591404410885, 0.000000000000000, 0.000000000000000, 0.051661432347536, -0.101877718492409, 0.118371212121212, -0.081359108550576},
    {0.035074741130285, 0.088779059250389, -0.089285714285714, 0.030187530726696, 0.043258847394018, -0.059401206284424, 0.000000000000000, 0.026143168486842, 0.101252056166633, -0.116915803767617, 0.000000000000000, 0.000000000000000, 0.074400966033938, -0.030873610970484, -0.011883258403110, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067918478994939, -0.131523569023569, 0.108478811400768},
    {0.035074741130285, -0.010023442173431, 0.151289682539682, 0.000000000000000, 0.050273795620075, 0.093151891673302, 0.000000000000000, 0.000000000000000, 0.050626028083316, 0.064303692072189, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.072038425597796, -0.023766516806220, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.065761784511785, -0.081359108550576},
    {0.035074741130285, -0.126008987323133, -0.084325396825397, 0.101882916202598, 0.028644371923066, 0.002025041123333, -0.077332535275586, -0.026143168486842, 0.000000000000000, 0.005845790188381, 0.035649775209330, -0.012576058599899, -0.038529071696147, -0.044252175724361, -0.029708146007775, 0.000000000000000, 0.032543643420230, 0.051661432347536, 0.058215839138519, 0.052609427609428, 0.032543643420231},
    {0.035074741130285, 0.032934167141273, 0.121527777777778, -0.011320324022511, -0.075410693430113, -0.022275452356659, 0.000000000000000, 0.104572673947367, 0.101252056166633, 0.058457901883808, 0.000000000000000, -0.056592263699545, -0.009300120754242, 0.040135694261630, 0.041591404410885, 0.000000000000000, 0.000000000000000, -0.051661432347536, -0.101877718492409, -0.118371212121212, -0.081359108550576},
    {0.035074741130285, -0.088779059250389, -0.089285714285714, 0.030187530726696, -0.043258847394018, -0.059401206284424, 0.000000000000000, 0.026143168486842, -0.101252056166633, -0.116915803767617, 0.000000000000000, 0.000000000000000, 0.074400966033938, 0.030873610970484, -0.011883258403110, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.067918478994939, 0.131523569023569, 0.108478811400768},
    {0.035074741130285, 0.010023442173431, 0.151289682539682, 0.000000000000000, -0.050273795620075, 0.093151891673302, 0.000000000000000, 0.000000000000000, -0.050626028083316, 0.064303692072189, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.072038425597796, -0.023766516806220, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065761784511785, -0.081359108550576},
    {0.035074741130285, -0.136032429496564, -0.066964285714286, 0.036979725140202, 0.078918167543141, 0.060076219992202, -0.007733253527559, -0.045750544851973, -0.055688630891648, -0.037997636224476, -0.064169595376793, -0.012576058599899, 0.017271652829307, 0.027786249873436, 0.020201539285287, 0.089945878780019, 0.048815465130346, 0.020090557024042, 0.002425659964105, -0.005636724386724, -0.005423940570038},
    {0.035074741130285, 0.121713226391662, -0.032242063492063, -0.067167255866898, -0.032151846036095, 0.027675562018880, 0.139198563496054, 0.065357921217104, -0.010125205616663, -0.029228950941904, 0.042779730251196, -0.056592263699545, -0.033214716979437, 0.009262083291145, 0.020201539285287, -0.179891757560038, -0.032543643420231, 0.011480318299452, 0.009702639856420, -0.001878908128908, -0.005423940570038},
    {0.035074741130285, -0.121713226391662, -0.032242063492064, -0.067167255866898, 0.032151846036095, 0.027675562018880, -0.139198563496054, 0.065357921217104, 0.010125205616663, -0.029228950941904, 0.042779730251196, 0.056592263699545, -0.033214716979437, -0.009262083291145, 0.020201539285287, 0.179891757560038, -0.032543643420231, -0.011480318299452, 0.009702639856420, 0.001878908128908, -0.005423940570038},
    {0.035074741130285, 0.136032429496564, -0.066964285714286, 0.036979725140202, -0.078918167543141, 0.060076219992202, 0.007733253527559, -0.045750544851973, 0.055688630891648, -0.037997636224476, -0.064169595376793, 0.012576058599899, 0.017271652829307, -0.027786249873436, 0.020201539285287, -0.089945878780019, 0.048815465130346, -0.020090557024042, 0.002425659964105, 0.005636724386724, -0.005423940570038},
    {0.280597929042281, -0.214788046573522, -0.124007936507937, 0.090562592180087, 0.116915803767617, 0.000000000000000, 0.154665070551171, 0.078429505460525, 0.101252056166633, 0.081841062637332, -0.142599100837319, 0.025152117199798, -0.031886128300259, -0.107028518031012, -0.095066067224879, 0.000000000000000, -0.130174573680922, -0.103322864695072, -0.029107919569260, 0.026304713804714, 0.032543643420231},
    {0.035074741130285, 0.000000000000000, -0.124007936507936, -0.384891016765370, 0.000000000000000, 0.101252056166633, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.213898651255978, 0.000000000000000, 0.140830399992811, 0.000000000000000, -0.095066067224879, 0.000000000000000, 0.195261860521383, 0.000000000000000, -0.058215839138519, 0.000000000000000, 0.032543643420230},
    {0.280597929042281, 0.214788046573521, -0.124007936507936, 0.090562592180087, -0.116915803767617, 0.000000000000000, -0.154665070551171, 0.078429505460525, -0.101252056166633, 0.081841062637332, -0.142599100837319, -0.025152117199798, -0.031886128300259, 0.107028518031012, -0.095066067224879, 0.000000000000000, -0.130174573680922, 0.103322864695072, -0.029107919569260, -0.026304713804714, 0.032543643420231},
    {0.035074741130285, -0.107394023286761, 0.062003968253968, 0.011320324022511, -0.306903984889995, -0.253130140416582, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.000000000000000, 0.169776791098635, 0.009300120754242, 0.126581804978985, 0.172307246845093, 0.000000000000000, 0.000000000000000, 0.154984297042608, 0.101877718492409, -0.039457070707071, -0.081359108550576},
    {0.035074741130285, 0.107394023286761, 0.062003968253968, 0.011320324022511, 0.306903984889995, -0.253130140416582, 0.000000000000000, -0.104572673947367, 0.000000000000000, 0.046766321507047, 0.000000000000000, -0.169776791098635, 0.009300120754242, -0.126581804978985, 0.172307246845093, 0.000000000000000, 0.000000000000000, -0.154984297042608, 0.101877718492409, 0.039457070707071, -0.081359108550576},
    {0.280597929042281, 0.000000000000000, 0.248015873015873, -0.060375061453391, 0.000000000000000, 0.135002741555510, 0.000000000000000, -0.052286336973683, 0.000000000000000, -0.210448446781710, 0.000000000000000, 0.000000000000000, -0.148801932067876, 0.000000000000000, -0.142599100837319, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.135836957989878, 0.000000000000000, 0.108478811400768}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[21][21] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 9.486832980505140, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.999999999999999, 0.000000000000000, 7.071067811865478, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.291502622129187, 0.000000000000000, -2.993325909419156, 13.662601021279471, 0.000000000000000, 0.611010092660783, 0.000000000000000, -0.000000000000012, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.381780460041329, 0.000000000000000, 0.000000000000000, 12.521980673998824, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.464101615137753, 0.000000000000000, 7.838367176906170, 0.000000000000000, 0.000000000000000, 8.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 10.954451150103317, 0.000000000000000, 0.000000000000000, -3.833259389999640, 0.000000000000000, 17.748239349298846, 0.000000000000000, 0.553283335172481, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.732863826479705, 0.000000000000000, 3.346640106136310, 4.364357804719847, 0.000000000000000, -5.074680379332373, 0.000000000000000, 17.008401285415236, 0.000000000000000, 1.521277658511335, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 2.449489742783183, 0.000000000000000, 0.000000000000000, 9.142857142857142, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.846149779161816, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.098386676965935, 0.000000000000000, 7.668115805072331, 0.000000000000000, 0.000000000000000, 10.733126291998994, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.295160030897806, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.416025603090630, 0.000000000000000, -4.376809635457549, 15.732132722552270, 0.000000000000000, 2.010178182781468, 0.000000000000000, -4.036867138796668, 0.000000000000000, -0.515811962199108, 21.799082549501939, 0.000000000000000, 0.451335466924222, 0.000000000000000, 0.057669530554237, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 6.857142857142846, -0.000000000000013, 0.000000000000000, 9.972922524188656, 0.000000000000000, 4.320493798938567, -0.000000000000015, -7.273098320775935, 0.000000000000000, 0.000000000000000, 21.254019227744511, 0.000000000000000, 1.490788039793665, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.320493798938574, 0.000000000000000, 5.935526614418996, 1.792842914001590, 0.000000000000000, -0.320713490294917, 0.000000000000000, 9.200874124564738, 0.000000000000000, -5.966396198534212, 0.000000000000000, 0.000000000000000, 19.802263245135119, 0.000000000000000, 2.530240384255303, 0.000000000000000, 0.000000000000013, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.533303755999870, 0.000000000000000, 0.000000000000000, 6.337932451131207, 0.000000000000000, 0.000000000000010, 0.000000000000000, 13.552618543578779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.667516985111465, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.828427124746193, 0.000000000000000, 7.314285714285728, 0.000000000000000, 0.000000000000000, 11.337638238025006, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.929952570268316, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.938586931957769, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[21][21] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.449489742783179, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.242640687119287, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.581988897471612, 4.743416490252570, -0.912870929175274, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.999999999999998, 6.123724356957945, 3.535533905932741, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.309401076758506, 0.000000000000000, 8.164965809277259, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.645751311064592, 5.184592558726291, -1.496662954709576, 6.831300510639736, -1.058300524425835, 0.305505046330390, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.236067977499789, 2.190890230020667, 2.529822128134708, 8.082903768654763, 6.260990336999416, -1.807392228230125, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.732050807568878, -5.091168824543144, 3.919183588453084, 0.000000000000000, 9.699484522385710, 4.200000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.000000000000004, 0.000000000000000, -2.828427124746193, 0.000000000000000, -0.000000000000012, 12.124355652982139, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.683281572999745, 5.477225575051658, -1.897366596101024, 7.423074889580902, -1.916629694999818, 0.663940002206986, 8.874119674649419, -1.071428571428577, 0.276641667586241, -0.095831484749986, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.366431913239848, 2.898275349237880, 1.673320053068159, 2.182178902359919, 5.747048932153919, -2.537340189666187, 10.062305898749051, 8.504200642707616, -2.195775164134209, 0.760638829255670, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.000000000000006, 1.224744871391593, 3.535533905932738, -7.377111135633184, 4.571428571428567, 1.649572197684639, 0.000000000000000, 11.499778169998939, 7.423074889580906, -2.571428571428584, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.549193338482966, 6.640783086353601, 3.834057902536168, 0.000000000000000, -6.196773353931873, 5.366563145999496, 0.000000000000000, 0.000000000000000, 13.416407864998748, 4.647580015448905, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.577708763999663, 0.000000000000000, 8.854377448471491, 0.000000000000000, 0.000000000000000, -3.098386676965919, 0.000000000000000, 0.000000000000000, 0.000000000000000, 16.099689437998521, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000011, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000015},
    {2.708012801545312, 5.685642497752098, -2.188404817728772, 7.866066361276138, -2.611298058632982, 1.005089091390736, 9.552971226757622, -2.018433569398339, 0.670059394260480, -0.257905981099551, 10.899541274750971, -1.068054652506478, 0.225667733462112, -0.074914917726436, 0.028834765277119, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.449489742783179, 3.428571428571423, 0.989743318610785, 3.049339172305220, 4.986461262094330, -2.727411870290972, 2.160246899469287, 8.346248495316818, -3.636549160387970, 1.516350793151489, 12.049896265113652, 10.627009613872255, -2.245365597551247, 0.745394019896831, -0.286902292026517, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.160246899469290, 1.814229470444297, 2.967763307209495, 0.896421457000795, 5.416047583669426, -0.160356745147457, -9.525793444156795, 4.600437062282367, 5.345224838248486, -2.983198099267109, 0.000000000000000, 13.388773627904058, 9.901131622567560, -3.286878675669585, 1.265120192127652, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.825741858350548, 0.766651877999930, 3.836097790529246, 8.636804255921412, 3.168966225565605, 3.659207006766274, 0.000000000000000, -8.748177652797080, 6.776309271789395, 0.521640530957305, 0.000000000000000, 0.000000000000000, 15.062370331392071, 8.333758492555734, -3.207665139358918, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.414213562373099, -6.730254566553347, 3.657142857142851, 0.000000000000000, 9.455027817008695, 5.668819119012500, 0.000000000000000, 0.000000000000000, -6.998542122237651, 6.464976285134147, 0.000000000000000, 0.000000000000000, 0.000000000000000, 17.214137521590924, 4.969293465978883, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.715476066494085, 0.000000000000000, -4.618802153517004, 0.000000000000000, 0.000000000000000, 12.727922061357861, 0.000000000000000, 0.000000000000000, 0.000000000000000, -3.265986323710900, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 20.083160441856087, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[21][21] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[21][21] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 21; t++)
      {
        for (unsigned int u = 0; u < 21; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            for (unsigned int tu = 0; tu < 21; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            for (unsigned int tu = 0; tu < 21; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 21; s++)
      {
        for (unsigned int t = 0; t < 21; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
      y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
      y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
      y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
      y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
      y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
      y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
      y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
      y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
      y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
    y[1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
    y[1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
    y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
    y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
    y[1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
    y[1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
    y[1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
    y[1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
    y[1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson2d_5_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson2d_5_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson2d_5_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 4.000000000000000*m.num_entities[1] + 6.000000000000000*m.num_entities[2];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 21;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 21;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 4*c.entity_indices[1][0];
    dofs[4] = offset + 4*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 4*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 4*c.entity_indices[1][0] + 3;
    dofs[7] = offset + 4*c.entity_indices[1][1];
    dofs[8] = offset + 4*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 4*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 4*c.entity_indices[1][1] + 3;
    dofs[11] = offset + 4*c.entity_indices[1][2];
    dofs[12] = offset + 4*c.entity_indices[1][2] + 1;
    dofs[13] = offset + 4*c.entity_indices[1][2] + 2;
    dofs[14] = offset + 4*c.entity_indices[1][2] + 3;
    offset += 4*m.num_entities[1];
    dofs[15] = offset + 6*c.entity_indices[2][0];
    dofs[16] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[17] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[18] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[19] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[20] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
        dofs[3] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 11;
        dofs[1] = 12;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 15;
      dofs[1] = 16;
      dofs[2] = 17;
      dofs[3] = 18;
      dofs[4] = 19;
      dofs[5] = 20;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.800000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[3][1] = 0.800000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[4][0] = 0.600000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[4][1] = 0.600000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[5][0] = 0.400000000000000*x[1][0] + 0.600000000000000*x[2][0];
    coordinates[5][1] = 0.400000000000000*x[1][1] + 0.600000000000000*x[2][1];
    coordinates[6][0] = 0.200000000000000*x[1][0] + 0.800000000000000*x[2][0];
    coordinates[6][1] = 0.200000000000000*x[1][1] + 0.800000000000000*x[2][1];
    coordinates[7][0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[2][0];
    coordinates[7][1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[2][1];
    coordinates[8][0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[2][0];
    coordinates[8][1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[2][1];
    coordinates[9][0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[2][0];
    coordinates[9][1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[2][1];
    coordinates[10][0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[2][0];
    coordinates[10][1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[2][1];
    coordinates[11][0] = 0.800000000000000*x[0][0] + 0.200000000000000*x[1][0];
    coordinates[11][1] = 0.800000000000000*x[0][1] + 0.200000000000000*x[1][1];
    coordinates[12][0] = 0.600000000000000*x[0][0] + 0.400000000000000*x[1][0];
    coordinates[12][1] = 0.600000000000000*x[0][1] + 0.400000000000000*x[1][1];
    coordinates[13][0] = 0.400000000000000*x[0][0] + 0.600000000000000*x[1][0];
    coordinates[13][1] = 0.400000000000000*x[0][1] + 0.600000000000000*x[1][1];
    coordinates[14][0] = 0.200000000000000*x[0][0] + 0.800000000000000*x[1][0];
    coordinates[14][1] = 0.200000000000000*x[0][1] + 0.800000000000000*x[1][1];
    coordinates[15][0] = 0.600000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[15][1] = 0.600000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[16][0] = 0.400000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[16][1] = 0.400000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[17][0] = 0.200000000000000*x[0][0] + 0.600000000000000*x[1][0] + 0.200000000000000*x[2][0];
    coordinates[17][1] = 0.200000000000000*x[0][1] + 0.600000000000000*x[1][1] + 0.200000000000000*x[2][1];
    coordinates[18][0] = 0.400000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[18][1] = 0.400000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[19][0] = 0.200000000000000*x[0][0] + 0.400000000000000*x[1][0] + 0.400000000000000*x[2][0];
    coordinates[19][1] = 0.200000000000000*x[0][1] + 0.400000000000000*x[1][1] + 0.400000000000000*x[2][1];
    coordinates[20][0] = 0.200000000000000*x[0][0] + 0.200000000000000*x[1][0] + 0.600000000000000*x[2][0];
    coordinates[20][1] = 0.200000000000000*x[0][1] + 0.200000000000000*x[1][1] + 0.600000000000000*x[2][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson2d_5_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson2d_5_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 1259
    // Total number of operations (multiply-add pairs):                  1278
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.342406580687829*G0_0_0 + 0.342406580687829*G0_0_1 + 0.342406580687829*G0_1_0 + 0.342406580687829*G0_1_1;
    A[1] = -0.040998401675485*G0_0_0 - 0.040998401675485*G0_1_0;
    A[2] = -0.040998401675485*G0_0_1 - 0.040998401675485*G0_1_1;
    A[3] = -0.040819279100529*G0_0_0 - 0.040819279100529*G0_0_1 - 0.040819279100529*G0_1_0 - 0.040819279100529*G0_1_1;
    A[4] = -0.037977430555555*G0_0_0 - 0.037977430555555*G0_0_1 - 0.037977430555555*G0_1_0 - 0.037977430555555*G0_1_1;
    A[5] = -0.037977430555555*G0_0_0 - 0.037977430555555*G0_0_1 - 0.037977430555555*G0_1_0 - 0.037977430555555*G0_1_1;
    A[6] = -0.040819279100529*G0_0_0 - 0.040819279100528*G0_0_1 - 0.040819279100528*G0_1_0 - 0.040819279100528*G0_1_1;
    A[7] = 0.202287946428571*G0_0_0 - 0.648027584876540*G0_0_1 + 0.202287946428571*G0_1_0 - 0.648027584876541*G0_1_1;
    A[8] = -0.015845458553793*G0_0_0 + 0.594204695767193*G0_0_1 - 0.015845458553793*G0_1_0 + 0.594204695767193*G0_1_1;
    A[9] = -0.069668347663138*G0_0_0 - 0.449959352954142*G0_0_1 - 0.069668347663138*G0_1_0 - 0.449959352954142*G0_1_1;
    A[10] = 0.040819279100529*G0_0_0 + 0.202374063051145*G0_0_1 + 0.040819279100528*G0_1_0 + 0.202374063051145*G0_1_1;
    A[11] = -0.648027584876540*G0_0_0 + 0.202287946428571*G0_0_1 - 0.648027584876540*G0_1_0 + 0.202287946428571*G0_1_1;
    A[12] = 0.594204695767192*G0_0_0 - 0.015845458553792*G0_0_1 + 0.594204695767192*G0_1_0 - 0.015845458553791*G0_1_1;
    A[13] = -0.449959352954141*G0_0_0 - 0.069668347663140*G0_0_1 - 0.449959352954141*G0_1_0 - 0.069668347663140*G0_1_1;
    A[14] = 0.202374063051145*G0_0_0 + 0.040819279100529*G0_0_1 + 0.202374063051145*G0_1_0 + 0.040819279100529*G0_1_1;
    A[15] = -0.215291556437389*G0_0_0 - 0.215291556437391*G0_0_1 - 0.215291556437389*G0_1_0 - 0.215291556437392*G0_1_1;
    A[16] = -0.053822889109348*G0_0_0 - 0.053822889109345*G0_0_1 - 0.053822889109348*G0_1_0 - 0.053822889109345*G0_1_1;
    A[17] = 0.107645778218695*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218695*G0_1_0 + 0.107645778218693*G0_1_1;
    A[18] = -0.053822889109345*G0_0_0 - 0.053822889109345*G0_0_1 - 0.053822889109345*G0_1_0 - 0.053822889109345*G0_1_1;
    A[19] = 0.107645778218693*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218694*G0_1_1;
    A[20] = 0.107645778218692*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218692*G0_1_1;
    A[21] = -0.040998401675485*G0_0_0 - 0.040998401675485*G0_0_1;
    A[22] = 0.342406580687829*G0_0_0;
    A[23] = 0.040998401675485*G0_0_1;
    A[24] = 0.202287946428571*G0_0_0 + 0.850315531305110*G0_0_1;
    A[25] = -0.015845458553792*G0_0_0 - 0.610050154320985*G0_0_1;
    A[26] = -0.069668347663139*G0_0_0 + 0.380291005291003*G0_0_1;
    A[27] = 0.040819279100529*G0_0_0 - 0.161554783950616*G0_0_1;
    A[28] = -0.040819279100528*G0_0_0;
    A[29] = -0.037977430555556*G0_0_0;
    A[30] = -0.037977430555555*G0_0_0;
    A[31] = -0.040819279100529*G0_0_0;
    A[32] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_0_1;
    A[33] = -0.449959352954141*G0_0_0 - 0.380291005291001*G0_0_1;
    A[34] = 0.594204695767192*G0_0_0 + 0.610050154320983*G0_0_1;
    A[35] = -0.648027584876540*G0_0_0 - 0.850315531305110*G0_0_1;
    A[36] = 0.107645778218695*G0_0_0;
    A[37] = -0.053822889109348*G0_0_0;
    A[38] = -0.215291556437389*G0_0_0;
    A[39] = 0.107645778218695*G0_0_0;
    A[40] = -0.053822889109346*G0_0_0;
    A[41] = 0.107645778218693*G0_0_0;
    A[42] = -0.040998401675485*G0_1_0 - 0.040998401675485*G0_1_1;
    A[43] = 0.040998401675485*G0_1_0;
    A[44] = 0.342406580687830*G0_1_1;
    A[45] = -0.161554783950617*G0_1_0 + 0.040819279100529*G0_1_1;
    A[46] = 0.380291005291005*G0_1_0 - 0.069668347663139*G0_1_1;
    A[47] = -0.610050154320987*G0_1_0 - 0.015845458553791*G0_1_1;
    A[48] = 0.850315531305112*G0_1_0 + 0.202287946428570*G0_1_1;
    A[49] = 0.161554783950617*G0_1_0 + 0.202374063051145*G0_1_1;
    A[50] = -0.380291005291005*G0_1_0 - 0.449959352954142*G0_1_1;
    A[51] = 0.610050154320986*G0_1_0 + 0.594204695767193*G0_1_1;
    A[52] = -0.850315531305112*G0_1_0 - 0.648027584876541*G0_1_1;
    A[53] = -0.040819279100529*G0_1_1;
    A[54] = -0.037977430555555*G0_1_1;
    A[55] = -0.037977430555555*G0_1_1;
    A[56] = -0.040819279100529*G0_1_1;
    A[57] = 0.107645778218693*G0_1_1;
    A[58] = 0.107645778218692*G0_1_1;
    A[59] = 0.107645778218694*G0_1_1;
    A[60] = -0.053822889109345*G0_1_1;
    A[61] = -0.053822889109347*G0_1_1;
    A[62] = -0.215291556437389*G0_1_1;
    A[63] = -0.040819279100529*G0_0_0 - 0.040819279100529*G0_0_1 - 0.040819279100529*G0_1_0 - 0.040819279100529*G0_1_1;
    A[64] = 0.202287946428571*G0_0_0 + 0.850315531305110*G0_1_0;
    A[65] = -0.161554783950617*G0_0_1 + 0.040819279100529*G0_1_1;
    A[66] = 1.989293981481473*G0_0_0 + 1.280984760802463*G0_0_1 + 1.280984760802463*G0_1_0 + 2.561969521604922*G0_1_1;
    A[67] = -0.906377452601408*G0_0_0 + 0.796578758818337*G0_0_1 - 0.529617228835978*G0_1_0 - 1.395089285714278*G0_1_1;
    A[68] = 0.818107914462077*G0_0_0 - 0.482253086419751*G0_0_1 + 0.232514880952381*G0_1_0 + 0.895612874779536*G0_1_1;
    A[69] = -0.340160659171076*G0_0_0 + 0.329396081349204*G0_0_1 - 0.071046213624339*G0_1_0 - 0.340160659171074*G0_1_1;
    A[70] = 0.142092427248675*G0_0_0 + 0.071046213624339*G0_0_1 + 0.071046213624338*G0_1_0;
    A[71] = 0.131327849426809*G0_0_0 + 0.030140817901234*G0_0_1 + 0.030140817901233*G0_1_0;
    A[72] = 0.172233245149910*G0_0_0 + 0.030140817901235*G0_0_1 + 0.030140817901236*G0_1_0;
    A[73] = 0.340160659171075*G0_0_0 + 0.071046213624339*G0_0_1 + 0.071046213624339*G0_1_0;
    A[74] = 0.198068231922397*G0_0_0 + 0.269114445546734*G0_0_1 + 0.269114445546735*G0_1_0 + 0.340160659171072*G0_1_1;
    A[75] = -0.359536899250437*G0_0_0 - 0.663097993827154*G0_0_1 - 0.663097993827153*G0_1_0 - 0.895612874779530*G0_1_1;
    A[76] = 0.286337770061725*G0_0_0 + 0.865472056878300*G0_0_1 + 0.865472056878298*G0_1_0 + 1.395089285714273*G0_1_1;
    A[77] = -0.286337770061726*G0_0_0 - 1.280984760802462*G0_0_1 - 1.280984760802461*G0_1_0 - 2.561969521604922*G0_1_1;
    A[78] = -0.667403824955902*G0_0_0 - 0.262655698853610*G0_0_1 - 0.262655698853611*G0_1_0;
    A[79] = 1.356336805555544*G0_0_0 + 0.572675540123448*G0_0_1 + 0.572675540123448*G0_1_0;
    A[80] = -2.820319389329791*G0_0_0 - 1.662050815696638*G0_0_1 - 1.662050815696639*G0_1_0;
    A[81] = -0.419818535052912*G0_0_0 - 0.073199129188718*G0_0_1 - 0.073199129188713*G0_1_0;
    A[82] = 1.194868138227510*G0_0_0 + 0.572675540123456*G0_0_1 + 0.572675540123458*G0_1_0;
    A[83] = -0.990341159611987*G0_0_0 - 0.262655698853611*G0_0_1 - 0.262655698853617*G0_1_0;
    A[84] = -0.037977430555555*G0_0_0 - 0.037977430555555*G0_0_1 - 0.037977430555555*G0_1_0 - 0.037977430555555*G0_1_1;
    A[85] = -0.015845458553792*G0_0_0 - 0.610050154320985*G0_1_0;
    A[86] = 0.380291005291005*G0_0_1 - 0.069668347663139*G0_1_1;
    A[87] = -0.906377452601408*G0_0_0 - 0.529617228835978*G0_0_1 + 0.796578758818337*G0_1_0 - 1.395089285714279*G0_1_1;
    A[88] = 3.074363425925915*G0_0_0 + 1.175491898148148*G0_0_1 + 1.175491898148148*G0_1_0 + 3.694403108465595*G0_1_1;
    A[89] = -1.804143242945320*G0_0_0 + 0.699697558421512*G0_0_1 - 0.350925236992947*G0_1_0 - 1.804143242945318*G0_1_1;
    A[90] = 0.895612874779542*G0_0_0 - 0.482253086419749*G0_0_1 + 0.232514880952382*G0_1_0 + 0.818107914462077*G0_1_1;
    A[91] = 0.131327849426810*G0_0_0 + 0.101187031525573*G0_0_1 + 0.101187031525573*G0_1_0 + 0.071046213624338*G0_1_1;
    A[92] = -0.297102347883602*G0_0_0 - 0.148551173941801*G0_0_1 - 0.148551173941798*G0_1_0 - 0.017223324514991*G0_1_1;
    A[93] = -0.219597387566132*G0_0_0 - 0.062434551366839*G0_0_1 - 0.062434551366843*G0_1_0 - 0.017223324514991*G0_1_1;
    A[94] = -0.895612874779542*G0_0_0 - 0.232514880952383*G0_0_1 - 0.232514880952381*G0_1_0 + 0.071046213624338*G0_1_1;
    A[95] = 0.111951609347441*G0_0_0 + 0.142092427248677*G0_0_1 + 0.142092427248675*G0_1_0 + 0.172233245149910*G0_1_1;
    A[96] = -0.111951609347441*G0_0_0 - 0.157162836199292*G0_0_1 - 0.157162836199292*G0_1_0 - 0.219597387566136*G0_1_1;
    A[97] = 0.103339947089946*G0_0_0 + 0.133480764991182*G0_0_1 + 0.133480764991180*G0_1_0 + 0.266961529982362*G0_1_1;
    A[98] = -0.049517057980599*G0_0_0 + 0.529617228835978*G0_0_1 + 0.529617228835977*G0_1_0 + 1.395089285714280*G0_1_1;
    A[99] = -0.344466490299821*G0_0_0 - 0.447806437389771*G0_0_1 - 0.447806437389767*G0_1_0 - 0.516699735449730*G0_1_1;
    A[100] = 0.387524801587296*G0_0_0 + 0.859013310185176*G0_0_1 + 0.859013310185176*G0_1_0 + 1.011870315255723*G0_1_1;
    A[101] = 0.731991291887125*G0_0_0 - 1.308972663139327*G0_0_1 - 1.308972663139319*G0_1_0 - 3.961364638447955*G0_1_1;
    A[102] = 1.033399470899471*G0_0_0 + 0.374607308201062*G0_0_1 + 0.374607308201055*G0_1_0 + 0.043058311287475*G0_1_1;
    A[103] = -3.810660548941786*G0_0_0 - 1.401548032407399*G0_0_1 - 1.401548032407407*G0_1_0 + 1.011870315255728*G0_1_1;
    A[104] = 2.023740630511452*G0_0_0 + 0.413359788359781*G0_0_1 + 0.413359788359790*G0_1_0 - 0.516699735449731*G0_1_1;
    A[105] = -0.037977430555555*G0_0_0 - 0.037977430555555*G0_0_1 - 0.037977430555555*G0_1_0 - 0.037977430555555*G0_1_1;
    A[106] = -0.069668347663139*G0_0_0 + 0.380291005291004*G0_1_0;
    A[107] = -0.610050154320987*G0_0_1 - 0.015845458553791*G0_1_1;
    A[108] = 0.818107914462077*G0_0_0 + 0.232514880952381*G0_0_1 - 0.482253086419751*G0_1_0 + 0.895612874779536*G0_1_1;
    A[109] = -1.804143242945320*G0_0_0 - 0.350925236992947*G0_0_1 + 0.699697558421512*G0_1_0 - 1.804143242945318*G0_1_1;
    A[110] = 3.694403108465595*G0_0_0 + 1.175491898148145*G0_0_1 + 1.175491898148145*G0_1_0 + 3.074363425925911*G0_1_1;
    A[111] = -1.395089285714285*G0_0_0 + 0.796578758818336*G0_0_1 - 0.529617228835977*G0_1_0 - 0.906377452601406*G0_1_1;
    A[112] = 0.172233245149908*G0_0_0 + 0.142092427248674*G0_0_1 + 0.142092427248676*G0_1_0 + 0.111951609347441*G0_1_1;
    A[113] = -0.219597387566131*G0_0_0 - 0.157162836199290*G0_0_1 - 0.157162836199295*G0_1_0 - 0.111951609347442*G0_1_1;
    A[114] = 0.266961529982358*G0_0_0 + 0.133480764991178*G0_0_1 + 0.133480764991183*G0_1_0 + 0.103339947089949*G0_1_1;
    A[115] = 1.395089285714284*G0_0_0 + 0.529617228835979*G0_0_1 + 0.529617228835976*G0_1_0 - 0.049517057980600*G0_1_1;
    A[116] = 0.071046213624337*G0_0_0 + 0.101187031525571*G0_0_1 + 0.101187031525572*G0_1_0 + 0.131327849426807*G0_1_1;
    A[117] = -0.017223324514990*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941797*G0_1_0 - 0.297102347883595*G0_1_1;
    A[118] = -0.017223324514992*G0_0_0 - 0.062434551366845*G0_0_1 - 0.062434551366844*G0_1_0 - 0.219597387566138*G0_1_1;
    A[119] = 0.071046213624339*G0_0_0 - 0.232514880952380*G0_0_1 - 0.232514880952380*G0_1_0 - 0.895612874779536*G0_1_1;
    A[120] = -0.516699735449729*G0_0_0 - 0.447806437389762*G0_0_1 - 0.447806437389766*G0_1_0 - 0.344466490299822*G0_1_1;
    A[121] = 0.043058311287473*G0_0_0 + 0.374607308201058*G0_0_1 + 0.374607308201054*G0_1_0 + 1.033399470899467*G0_1_1;
    A[122] = -0.516699735449732*G0_0_0 + 0.413359788359791*G0_0_1 + 0.413359788359787*G0_1_0 + 2.023740630511455*G0_1_1;
    A[123] = 1.011870315255721*G0_0_0 + 0.859013310185171*G0_0_1 + 0.859013310185181*G0_1_0 + 0.387524801587299*G0_1_1;
    A[124] = 1.011870315255731*G0_0_0 - 1.401548032407405*G0_0_1 - 1.401548032407398*G0_1_0 - 3.810660548941784*G0_1_1;
    A[125] = -3.961364638447952*G0_0_0 - 1.308972663139316*G0_0_1 - 1.308972663139327*G0_1_0 + 0.731991291887120*G0_1_1;
    A[126] = -0.040819279100529*G0_0_0 - 0.040819279100528*G0_0_1 - 0.040819279100528*G0_1_0 - 0.040819279100528*G0_1_1;
    A[127] = 0.040819279100529*G0_0_0 - 0.161554783950616*G0_1_0;
    A[128] = 0.850315531305112*G0_0_1 + 0.202287946428570*G0_1_1;
    A[129] = -0.340160659171076*G0_0_0 - 0.071046213624339*G0_0_1 + 0.329396081349204*G0_1_0 - 0.340160659171074*G0_1_1;
    A[130] = 0.895612874779542*G0_0_0 + 0.232514880952382*G0_0_1 - 0.482253086419749*G0_1_0 + 0.818107914462077*G0_1_1;
    A[131] = -1.395089285714285*G0_0_0 - 0.529617228835977*G0_0_1 + 0.796578758818336*G0_1_0 - 0.906377452601406*G0_1_1;
    A[132] = 2.561969521604929*G0_0_0 + 1.280984760802462*G0_0_1 + 1.280984760802462*G0_1_0 + 1.989293981481470*G0_1_1;
    A[133] = 0.340160659171074*G0_0_0 + 0.269114445546734*G0_0_1 + 0.269114445546734*G0_1_0 + 0.198068231922395*G0_1_1;
    A[134] = -0.895612874779540*G0_0_0 - 0.663097993827156*G0_0_1 - 0.663097993827156*G0_1_0 - 0.359536899250436*G0_1_1;
    A[135] = 1.395089285714281*G0_0_0 + 0.865472056878302*G0_0_1 + 0.865472056878301*G0_1_0 + 0.286337770061724*G0_1_1;
    A[136] = -2.561969521604929*G0_0_0 - 1.280984760802465*G0_0_1 - 1.280984760802462*G0_1_0 - 0.286337770061726*G0_1_1;
    A[137] = 0.071046213624339*G0_0_1 + 0.071046213624337*G0_1_0 + 0.142092427248676*G0_1_1;
    A[138] = 0.030140817901236*G0_0_1 + 0.030140817901235*G0_1_0 + 0.131327849426808*G0_1_1;
    A[139] = 0.030140817901237*G0_0_1 + 0.030140817901234*G0_1_0 + 0.172233245149911*G0_1_1;
    A[140] = 0.071046213624338*G0_0_1 + 0.071046213624338*G0_1_0 + 0.340160659171074*G0_1_1;
    A[141] = -0.262655698853617*G0_0_1 - 0.262655698853610*G0_1_0 - 0.667403824955903*G0_1_1;
    A[142] = -0.073199129188719*G0_0_1 - 0.073199129188716*G0_1_0 - 0.419818535052914*G0_1_1;
    A[143] = -0.262655698853617*G0_0_1 - 0.262655698853611*G0_1_0 - 0.990341159611988*G0_1_1;
    A[144] = 0.572675540123458*G0_0_1 + 0.572675540123449*G0_1_0 + 1.356336805555546*G0_1_1;
    A[145] = 0.572675540123459*G0_0_1 + 0.572675540123454*G0_1_0 + 1.194868138227511*G0_1_1;
    A[146] = -1.662050815696641*G0_0_1 - 1.662050815696636*G0_1_0 - 2.820319389329788*G0_1_1;
    A[147] = 0.202287946428571*G0_0_0 + 0.202287946428571*G0_0_1 - 0.648027584876540*G0_1_0 - 0.648027584876540*G0_1_1;
    A[148] = -0.040819279100528*G0_0_0;
    A[149] = 0.161554783950617*G0_0_1 + 0.202374063051145*G0_1_1;
    A[150] = 0.142092427248675*G0_0_0 + 0.071046213624338*G0_0_1 + 0.071046213624339*G0_1_0;
    A[151] = 0.131327849426810*G0_0_0 + 0.101187031525573*G0_0_1 + 0.101187031525573*G0_1_0 + 0.071046213624338*G0_1_1;
    A[152] = 0.172233245149908*G0_0_0 + 0.142092427248676*G0_0_1 + 0.142092427248674*G0_1_0 + 0.111951609347441*G0_1_1;
    A[153] = 0.340160659171074*G0_0_0 + 0.269114445546734*G0_0_1 + 0.269114445546734*G0_1_0 + 0.198068231922395*G0_1_1;
    A[154] = 1.989293981481469*G0_0_0 + 0.708309220679006*G0_0_1 + 0.708309220679006*G0_1_0 + 1.989293981481471*G0_1_1;
    A[155] = -0.906377452601403*G0_0_0 - 1.702956211419742*G0_0_1 - 0.376760223765425*G0_1_0 - 2.568428268298045*G0_1_1;
    A[156] = 0.818107914462076*G0_0_0 + 1.300361000881825*G0_0_1 + 0.585593033509694*G0_1_0 + 1.963458994708983*G0_1_1;
    A[157] = -0.340160659171075*G0_0_0 - 0.669556740520279*G0_0_1 - 0.269114445546734*G0_1_0 - 0.938671186067013*G0_1_1;
    A[158] = -0.286337770061728*G0_0_0 + 0.994646990740735*G0_0_1 + 0.994646990740736*G0_1_0 - 0.286337770061727*G0_1_1;
    A[159] = 0.286337770061727*G0_0_0 - 0.579134286816573*G0_0_1 - 0.579134286816574*G0_1_0 - 0.049517057980600*G0_1_1;
    A[160] = -0.359536899250438*G0_0_0 + 0.303561094576717*G0_0_1 + 0.303561094576717*G0_1_0 + 0.071046213624341*G0_1_1;
    A[161] = 0.198068231922397*G0_0_0 - 0.071046213624337*G0_0_1 - 0.071046213624338*G0_1_0;
    A[162] = -2.820319389329784*G0_0_0 - 1.158268573633146*G0_0_1 - 1.158268573633147*G0_1_0 + 0.503782242063497*G0_1_1;
    A[163] = 1.356336805555540*G0_0_0 + 0.783661265432090*G0_0_1 + 0.783661265432093*G0_1_0 + 0.210985725308635*G0_1_1;
    A[164] = -0.667403824955900*G0_0_0 - 0.404748126102291*G0_0_1 - 0.404748126102291*G0_1_0 - 0.142092427248677*G0_1_1;
    A[165] = 1.194868138227503*G0_0_0 + 0.622192598104048*G0_0_1 + 0.622192598104045*G0_1_0 + 0.049517057980592*G0_1_1;
    A[166] = -0.419818535052909*G0_0_0 - 0.346619405864194*G0_0_1 - 0.346619405864193*G0_1_0 - 0.273420276675480*G0_1_1;
    A[167] = -0.990341159611984*G0_0_0 - 0.727685460758370*G0_0_1 - 0.727685460758368*G0_1_0 - 0.465029761904754*G0_1_1;
    A[168] = -0.015845458553793*G0_0_0 - 0.015845458553793*G0_0_1 + 0.594204695767193*G0_1_0 + 0.594204695767193*G0_1_1;
    A[169] = -0.037977430555556*G0_0_0;
    A[170] = -0.380291005291005*G0_0_1 - 0.449959352954142*G0_1_1;
    A[171] = 0.131327849426809*G0_0_0 + 0.030140817901233*G0_0_1 + 0.030140817901234*G0_1_0;
    A[172] = -0.297102347883602*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941801*G0_1_0 - 0.017223324514991*G0_1_1;
    A[173] = -0.219597387566131*G0_0_0 - 0.157162836199295*G0_0_1 - 0.157162836199290*G0_1_0 - 0.111951609347442*G0_1_1;
    A[174] = -0.895612874779540*G0_0_0 - 0.663097993827156*G0_0_1 - 0.663097993827156*G0_1_0 - 0.359536899250436*G0_1_1;
    A[175] = -0.906377452601403*G0_0_0 - 0.376760223765425*G0_0_1 - 1.702956211419741*G0_1_0 - 2.568428268298045*G0_1_1;
    A[176] = 3.074363425925910*G0_0_0 + 1.898871527777761*G0_0_1 + 1.898871527777762*G0_1_0 + 4.417782738095212*G0_1_1;
    A[177] = -1.804143242945318*G0_0_0 - 2.503840801366827*G0_0_1 - 1.453218005952370*G0_1_0 - 3.957058807319199*G0_1_1;
    A[178] = 0.895612874779540*G0_0_0 + 1.377865961199289*G0_0_1 + 0.663097993827156*G0_1_0 + 1.963458994708984*G0_1_1;
    A[179] = -0.049517057980597*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816576*G0_1_0 + 0.286337770061727*G0_1_1;
    A[180] = 0.103339947089945*G0_0_0 - 0.030140817901235*G0_0_1 - 0.030140817901235*G0_1_0 + 0.103339947089947*G0_1_1;
    A[181] = -0.111951609347442*G0_0_0 + 0.045211226851851*G0_0_1 + 0.045211226851851*G0_1_0 - 0.017223324514995*G0_1_1;
    A[182] = 0.111951609347443*G0_0_0 - 0.030140817901233*G0_0_1 - 0.030140817901233*G0_1_0;
    A[183] = 0.731991291887115*G0_0_0 + 2.040963955026444*G0_0_1 + 2.040963955026438*G0_1_0 - 0.611428020282192*G0_1_1;
    A[184] = 0.387524801587305*G0_0_0 - 0.471488508597877*G0_0_1 - 0.471488508597877*G0_1_0 - 0.318631503527329*G0_1_1;
    A[185] = -0.344466490299827*G0_0_0 + 0.103339947089946*G0_0_1 + 0.103339947089946*G0_1_0 + 0.034446649029983*G0_1_1;
    A[186] = -3.810660548941778*G0_0_0 - 2.409112516534380*G0_0_1 - 2.409112516534371*G0_1_0 + 0.004305831128755*G0_1_1;
    A[187] = 1.033399470899472*G0_0_0 + 0.658792162698408*G0_0_1 + 0.658792162698411*G0_1_0 + 0.327243165784828*G0_1_1;
    A[188] = 2.023740630511448*G0_0_0 + 1.610380842151668*G0_0_1 + 1.610380842151660*G0_1_0 + 0.680321318342143*G0_1_1;
    A[189] = -0.069668347663138*G0_0_0 - 0.069668347663138*G0_0_1 - 0.449959352954142*G0_1_0 - 0.449959352954142*G0_1_1;
    A[190] = -0.037977430555555*G0_0_0;
    A[191] = 0.610050154320986*G0_0_1 + 0.594204695767193*G0_1_1;
    A[192] = 0.172233245149910*G0_0_0 + 0.030140817901236*G0_0_1 + 0.030140817901235*G0_1_0;
    A[193] = -0.219597387566132*G0_0_0 - 0.062434551366843*G0_0_1 - 0.062434551366839*G0_1_0 - 0.017223324514991*G0_1_1;
    A[194] = 0.266961529982358*G0_0_0 + 0.133480764991182*G0_0_1 + 0.133480764991178*G0_1_0 + 0.103339947089949*G0_1_1;
    A[195] = 1.395089285714281*G0_0_0 + 0.865472056878301*G0_0_1 + 0.865472056878302*G0_1_0 + 0.286337770061724*G0_1_1;
    A[196] = 0.818107914462076*G0_0_0 + 0.585593033509694*G0_0_1 + 1.300361000881825*G0_1_0 + 1.963458994708983*G0_1_1;
    A[197] = -1.804143242945318*G0_0_0 - 1.453218005952370*G0_0_1 - 2.503840801366827*G0_1_0 - 3.957058807319199*G0_1_1;
    A[198] = 3.694403108465593*G0_0_0 + 2.518911210317446*G0_0_1 + 2.518911210317446*G0_1_0 + 4.417782738095214*G0_1_1;
    A[199] = -1.395089285714281*G0_0_0 - 2.191668044532619*G0_0_1 - 0.865472056878303*G0_1_0 - 2.568428268298048*G0_1_1;
    A[200] = 0.071046213624337*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576718*G0_1_0 - 0.359536899250438*G0_1_1;
    A[201] = -0.017223324514990*G0_0_0 + 0.045211226851853*G0_0_1 + 0.045211226851852*G0_1_0 - 0.111951609347443*G0_1_1;
    A[202] = -0.017223324514992*G0_0_0 + 0.131327849426810*G0_0_1 + 0.131327849426807*G0_1_0 - 0.017223324514988*G0_1_1;
    A[203] = 0.071046213624337*G0_0_0 - 0.030140817901236*G0_0_1 - 0.030140817901236*G0_1_0;
    A[204] = -0.516699735449729*G0_0_0 - 0.930059523809522*G0_0_1 - 0.930059523809514*G0_1_0 + 0.680321318342152*G0_1_1;
    A[205] = 0.043058311287476*G0_0_0 - 0.331548996913586*G0_0_1 - 0.331548996913581*G0_1_0 + 0.327243165784826*G0_1_1;
    A[206] = -0.516699735449731*G0_0_0 - 0.068893298059966*G0_0_1 - 0.068893298059964*G0_1_0 + 0.034446649029982*G0_1_1;
    A[207] = 1.011870315255722*G0_0_0 + 2.413418347663131*G0_0_1 + 2.413418347663121*G0_1_0 + 0.004305831128744*G0_1_1;
    A[208] = 1.011870315255725*G0_0_0 + 0.152857005070550*G0_0_1 + 0.152857005070542*G0_1_0 - 0.318631503527336*G0_1_1;
    A[209] = -3.961364638447949*G0_0_0 - 2.652391975308629*G0_0_1 - 2.652391975308624*G0_1_0 - 0.611428020282181*G0_1_1;
    A[210] = 0.040819279100529*G0_0_0 + 0.040819279100528*G0_0_1 + 0.202374063051145*G0_1_0 + 0.202374063051145*G0_1_1;
    A[211] = -0.040819279100529*G0_0_0;
    A[212] = -0.850315531305112*G0_0_1 - 0.648027584876541*G0_1_1;
    A[213] = 0.340160659171076*G0_0_0 + 0.071046213624339*G0_0_1 + 0.071046213624339*G0_1_0;
    A[214] = -0.895612874779542*G0_0_0 - 0.232514880952381*G0_0_1 - 0.232514880952383*G0_1_0 + 0.071046213624338*G0_1_1;
    A[215] = 1.395089285714284*G0_0_0 + 0.529617228835976*G0_0_1 + 0.529617228835979*G0_1_0 - 0.049517057980600*G0_1_1;
    A[216] = -2.561969521604929*G0_0_0 - 1.280984760802462*G0_0_1 - 1.280984760802465*G0_1_0 - 0.286337770061726*G0_1_1;
    A[217] = -0.340160659171074*G0_0_0 - 0.269114445546734*G0_0_1 - 0.669556740520279*G0_1_0 - 0.938671186067013*G0_1_1;
    A[218] = 0.895612874779540*G0_0_0 + 0.663097993827156*G0_0_1 + 1.377865961199289*G0_1_0 + 1.963458994708983*G0_1_1;
    A[219] = -1.395089285714281*G0_0_0 - 0.865472056878303*G0_0_1 - 2.191668044532620*G0_1_0 - 2.568428268298048*G0_1_1;
    A[220] = 2.561969521604929*G0_0_0 + 1.280984760802465*G0_0_1 + 1.280984760802465*G0_1_0 + 1.989293981481474*G0_1_1;
    A[221] = -0.071046213624339*G0_0_1 - 0.071046213624338*G0_1_0 + 0.198068231922397*G0_1_1;
    A[222] = -0.030140817901236*G0_0_1 - 0.030140817901235*G0_1_0 + 0.111951609347442*G0_1_1;
    A[223] = -0.030140817901236*G0_0_1 - 0.030140817901234*G0_1_0 + 0.071046213624336*G0_1_1;
    A[224] = -0.071046213624338*G0_0_1 - 0.071046213624338*G0_1_0;
    A[225] = 0.262655698853617*G0_0_1 + 0.262655698853612*G0_1_0 - 0.465029761904759*G0_1_1;
    A[226] = 0.073199129188719*G0_0_1 + 0.073199129188713*G0_1_0 - 0.273420276675479*G0_1_1;
    A[227] = 0.262655698853617*G0_0_1 + 0.262655698853614*G0_1_0 - 0.142092427248675*G0_1_1;
    A[228] = -0.572675540123459*G0_0_1 - 0.572675540123452*G0_1_0 + 0.049517057980597*G0_1_1;
    A[229] = -0.572675540123459*G0_0_1 - 0.572675540123451*G0_1_0 + 0.210985725308640*G0_1_1;
    A[230] = 1.662050815696642*G0_0_1 + 1.662050815696640*G0_1_0 + 0.503782242063490*G0_1_1;
    A[231] = -0.648027584876540*G0_0_0 - 0.648027584876540*G0_0_1 + 0.202287946428571*G0_1_0 + 0.202287946428571*G0_1_1;
    A[232] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_1_0;
    A[233] = -0.040819279100529*G0_1_1;
    A[234] = 0.198068231922397*G0_0_0 + 0.269114445546735*G0_0_1 + 0.269114445546734*G0_1_0 + 0.340160659171072*G0_1_1;
    A[235] = 0.111951609347441*G0_0_0 + 0.142092427248675*G0_0_1 + 0.142092427248677*G0_1_0 + 0.172233245149910*G0_1_1;
    A[236] = 0.071046213624337*G0_0_0 + 0.101187031525572*G0_0_1 + 0.101187031525571*G0_1_0 + 0.131327849426807*G0_1_1;
    A[237] = 0.071046213624337*G0_0_1 + 0.071046213624339*G0_1_0 + 0.142092427248676*G0_1_1;
    A[238] = -0.286337770061728*G0_0_0 + 0.994646990740736*G0_0_1 + 0.994646990740735*G0_1_0 - 0.286337770061728*G0_1_1;
    A[239] = -0.049517057980597*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816575*G0_1_0 + 0.286337770061727*G0_1_1;
    A[240] = 0.071046213624336*G0_0_0 + 0.303561094576718*G0_0_1 + 0.303561094576719*G0_1_0 - 0.359536899250438*G0_1_1;
    A[241] = -0.071046213624338*G0_0_1 - 0.071046213624339*G0_1_0 + 0.198068231922397*G0_1_1;
    A[242] = 1.989293981481470*G0_0_0 + 0.708309220679007*G0_0_1 + 0.708309220679007*G0_1_0 + 1.989293981481468*G0_1_1;
    A[243] = -2.568428268298043*G0_0_0 - 0.376760223765428*G0_0_1 - 1.702956211419741*G0_1_0 - 0.906377452601402*G0_1_1;
    A[244] = 1.963458994708980*G0_0_0 + 0.585593033509695*G0_0_1 + 1.300361000881824*G0_1_0 + 0.818107914462072*G0_1_1;
    A[245] = -0.938671186067013*G0_0_0 - 0.269114445546735*G0_0_1 - 0.669556740520277*G0_1_0 - 0.340160659171071*G0_1_1;
    A[246] = 0.503782242063491*G0_0_0 - 1.158268573633146*G0_0_1 - 1.158268573633146*G0_1_0 - 2.820319389329788*G0_1_1;
    A[247] = 0.049517057980597*G0_0_0 + 0.622192598104045*G0_0_1 + 0.622192598104046*G0_1_0 + 1.194868138227501*G0_1_1;
    A[248] = -0.465029761904758*G0_0_0 - 0.727685460758369*G0_0_1 - 0.727685460758367*G0_1_0 - 0.990341159611983*G0_1_1;
    A[249] = 0.210985725308637*G0_0_0 + 0.783661265432092*G0_0_1 + 0.783661265432094*G0_1_0 + 1.356336805555546*G0_1_1;
    A[250] = -0.273420276675480*G0_0_0 - 0.346619405864193*G0_0_1 - 0.346619405864195*G0_1_0 - 0.419818535052906*G0_1_1;
    A[251] = -0.142092427248674*G0_0_0 - 0.404748126102288*G0_0_1 - 0.404748126102290*G0_1_0 - 0.667403824955904*G0_1_1;
    A[252] = 0.594204695767192*G0_0_0 + 0.594204695767192*G0_0_1 - 0.015845458553792*G0_1_0 - 0.015845458553791*G0_1_1;
    A[253] = -0.449959352954141*G0_0_0 - 0.380291005291001*G0_1_0;
    A[254] = -0.037977430555555*G0_1_1;
    A[255] = -0.359536899250437*G0_0_0 - 0.663097993827153*G0_0_1 - 0.663097993827154*G0_1_0 - 0.895612874779530*G0_1_1;
    A[256] = -0.111951609347441*G0_0_0 - 0.157162836199292*G0_0_1 - 0.157162836199292*G0_1_0 - 0.219597387566136*G0_1_1;
    A[257] = -0.017223324514990*G0_0_0 - 0.148551173941797*G0_0_1 - 0.148551173941798*G0_1_0 - 0.297102347883595*G0_1_1;
    A[258] = 0.030140817901235*G0_0_1 + 0.030140817901236*G0_1_0 + 0.131327849426808*G0_1_1;
    A[259] = 0.286337770061727*G0_0_0 - 0.579134286816574*G0_0_1 - 0.579134286816573*G0_1_0 - 0.049517057980600*G0_1_1;
    A[260] = 0.103339947089945*G0_0_0 - 0.030140817901235*G0_0_1 - 0.030140817901235*G0_1_0 + 0.103339947089947*G0_1_1;
    A[261] = -0.017223324514990*G0_0_0 + 0.045211226851852*G0_0_1 + 0.045211226851853*G0_1_0 - 0.111951609347443*G0_1_1;
    A[262] = -0.030140817901235*G0_0_1 - 0.030140817901236*G0_1_0 + 0.111951609347442*G0_1_1;
    A[263] = -2.568428268298043*G0_0_0 - 1.702956211419741*G0_0_1 - 0.376760223765428*G0_1_0 - 0.906377452601402*G0_1_1;
    A[264] = 4.417782738095207*G0_0_0 + 1.898871527777761*G0_0_1 + 1.898871527777762*G0_1_0 + 3.074363425925902*G0_1_1;
    A[265] = -3.957058807319195*G0_0_0 - 1.453218005952366*G0_0_1 - 2.503840801366823*G0_1_0 - 1.804143242945305*G0_1_1;
    A[266] = 1.963458994708980*G0_0_0 + 0.663097993827153*G0_0_1 + 1.377865961199282*G0_1_0 + 0.895612874779529*G0_1_1;
    A[267] = -0.611428020282187*G0_0_0 + 2.040963955026439*G0_0_1 + 2.040963955026436*G0_1_0 + 0.731991291887114*G0_1_1;
    A[268] = 0.004305831128754*G0_0_0 - 2.409112516534368*G0_0_1 - 2.409112516534365*G0_1_0 - 3.810660548941772*G0_1_1;
    A[269] = 0.680321318342142*G0_0_0 + 1.610380842151657*G0_0_1 + 1.610380842151657*G0_1_0 + 2.023740630511442*G0_1_1;
    A[270] = -0.318631503527332*G0_0_0 - 0.471488508597878*G0_0_1 - 0.471488508597880*G0_1_0 + 0.387524801587306*G0_1_1;
    A[271] = 0.327243165784827*G0_0_0 + 0.658792162698407*G0_0_1 + 0.658792162698408*G0_1_0 + 1.033399470899466*G0_1_1;
    A[272] = 0.034446649029980*G0_0_0 + 0.103339947089945*G0_0_1 + 0.103339947089945*G0_1_0 - 0.344466490299826*G0_1_1;
    A[273] = -0.449959352954141*G0_0_0 - 0.449959352954141*G0_0_1 - 0.069668347663140*G0_1_0 - 0.069668347663140*G0_1_1;
    A[274] = 0.594204695767192*G0_0_0 + 0.610050154320983*G0_1_0;
    A[275] = -0.037977430555555*G0_1_1;
    A[276] = 0.286337770061725*G0_0_0 + 0.865472056878298*G0_0_1 + 0.865472056878300*G0_1_0 + 1.395089285714273*G0_1_1;
    A[277] = 0.103339947089945*G0_0_0 + 0.133480764991180*G0_0_1 + 0.133480764991182*G0_1_0 + 0.266961529982362*G0_1_1;
    A[278] = -0.017223324514992*G0_0_0 - 0.062434551366844*G0_0_1 - 0.062434551366845*G0_1_0 - 0.219597387566138*G0_1_1;
    A[279] = 0.030140817901234*G0_0_1 + 0.030140817901237*G0_1_0 + 0.172233245149911*G0_1_1;
    A[280] = -0.359536899250438*G0_0_0 + 0.303561094576717*G0_0_1 + 0.303561094576717*G0_1_0 + 0.071046213624341*G0_1_1;
    A[281] = -0.111951609347442*G0_0_0 + 0.045211226851851*G0_0_1 + 0.045211226851851*G0_1_0 - 0.017223324514995*G0_1_1;
    A[282] = -0.017223324514992*G0_0_0 + 0.131327849426808*G0_0_1 + 0.131327849426810*G0_1_0 - 0.017223324514988*G0_1_1;
    A[283] = -0.030140817901234*G0_0_1 - 0.030140817901236*G0_1_0 + 0.071046213624336*G0_1_1;
    A[284] = 1.963458994708980*G0_0_0 + 1.300361000881824*G0_0_1 + 0.585593033509695*G0_1_0 + 0.818107914462072*G0_1_1;
    A[285] = -3.957058807319195*G0_0_0 - 2.503840801366823*G0_0_1 - 1.453218005952366*G0_1_0 - 1.804143242945305*G0_1_1;
    A[286] = 4.417782738095206*G0_0_0 + 2.518911210317440*G0_0_1 + 2.518911210317441*G0_1_0 + 3.694403108465583*G0_1_1;
    A[287] = -2.568428268298042*G0_0_0 - 0.865472056878298*G0_0_1 - 2.191668044532614*G0_1_0 - 1.395089285714273*G0_1_1;
    A[288] = 0.680321318342151*G0_0_0 - 0.930059523809514*G0_0_1 - 0.930059523809511*G0_1_0 - 0.516699735449724*G0_1_1;
    A[289] = 0.004305831128741*G0_0_0 + 2.413418347663115*G0_0_1 + 2.413418347663115*G0_1_0 + 1.011870315255709*G0_1_1;
    A[290] = -0.611428020282178*G0_0_0 - 2.652391975308619*G0_0_1 - 2.652391975308621*G0_1_0 - 3.961364638447945*G0_1_1;
    A[291] = 0.327243165784829*G0_0_0 - 0.331548996913582*G0_0_1 - 0.331548996913584*G0_1_0 + 0.043058311287474*G0_1_1;
    A[292] = -0.318631503527332*G0_0_0 + 0.152857005070549*G0_0_1 + 0.152857005070550*G0_1_0 + 1.011870315255734*G0_1_1;
    A[293] = 0.034446649029983*G0_0_0 - 0.068893298059963*G0_0_1 - 0.068893298059964*G0_1_0 - 0.516699735449732*G0_1_1;
    A[294] = 0.202374063051145*G0_0_0 + 0.202374063051145*G0_0_1 + 0.040819279100529*G0_1_0 + 0.040819279100529*G0_1_1;
    A[295] = -0.648027584876540*G0_0_0 - 0.850315531305110*G0_1_0;
    A[296] = -0.040819279100529*G0_1_1;
    A[297] = -0.286337770061726*G0_0_0 - 1.280984760802461*G0_0_1 - 1.280984760802462*G0_1_0 - 2.561969521604922*G0_1_1;
    A[298] = -0.049517057980599*G0_0_0 + 0.529617228835977*G0_0_1 + 0.529617228835978*G0_1_0 + 1.395089285714279*G0_1_1;
    A[299] = 0.071046213624339*G0_0_0 - 0.232514880952380*G0_0_1 - 0.232514880952380*G0_1_0 - 0.895612874779536*G0_1_1;
    A[300] = 0.071046213624338*G0_0_1 + 0.071046213624338*G0_1_0 + 0.340160659171074*G0_1_1;
    A[301] = 0.198068231922397*G0_0_0 - 0.071046213624338*G0_0_1 - 0.071046213624337*G0_1_0;
    A[302] = 0.111951609347443*G0_0_0 - 0.030140817901233*G0_0_1 - 0.030140817901233*G0_1_0;
    A[303] = 0.071046213624337*G0_0_0 - 0.030140817901236*G0_0_1 - 0.030140817901236*G0_1_0;
    A[304] = -0.071046213624338*G0_0_1 - 0.071046213624338*G0_1_0;
    A[305] = -0.938671186067013*G0_0_0 - 0.669556740520277*G0_0_1 - 0.269114445546735*G0_1_0 - 0.340160659171071*G0_1_1;
    A[306] = 1.963458994708980*G0_0_0 + 1.377865961199282*G0_0_1 + 0.663097993827153*G0_1_0 + 0.895612874779529*G0_1_1;
    A[307] = -2.568428268298042*G0_0_0 - 2.191668044532614*G0_0_1 - 0.865472056878298*G0_1_0 - 1.395089285714273*G0_1_1;
    A[308] = 1.989293981481471*G0_0_0 + 1.280984760802461*G0_0_1 + 1.280984760802461*G0_1_0 + 2.561969521604921*G0_1_1;
    A[309] = -0.465029761904762*G0_0_0 + 0.262655698853611*G0_0_1 + 0.262655698853609*G0_1_0;
    A[310] = 0.049517057980604*G0_0_0 - 0.572675540123445*G0_0_1 - 0.572675540123447*G0_1_0;
    A[311] = 0.503782242063487*G0_0_0 + 1.662050815696636*G0_0_1 + 1.662050815696638*G0_1_0;
    A[312] = -0.273420276675483*G0_0_0 + 0.073199129188714*G0_0_1 + 0.073199129188714*G0_1_0;
    A[313] = 0.210985725308638*G0_0_0 - 0.572675540123458*G0_0_1 - 0.572675540123458*G0_1_0;
    A[314] = -0.142092427248676*G0_0_0 + 0.262655698853614*G0_0_1 + 0.262655698853616*G0_1_0;
    A[315] = -0.215291556437389*G0_0_0 - 0.215291556437389*G0_0_1 - 0.215291556437391*G0_1_0 - 0.215291556437392*G0_1_1;
    A[316] = 0.107645778218695*G0_0_0;
    A[317] = 0.107645778218693*G0_1_1;
    A[318] = -0.667403824955902*G0_0_0 - 0.262655698853611*G0_0_1 - 0.262655698853610*G0_1_0;
    A[319] = -0.344466490299821*G0_0_0 - 0.447806437389767*G0_0_1 - 0.447806437389771*G0_1_0 - 0.516699735449730*G0_1_1;
    A[320] = -0.516699735449729*G0_0_0 - 0.447806437389766*G0_0_1 - 0.447806437389762*G0_1_0 - 0.344466490299822*G0_1_1;
    A[321] = -0.262655698853610*G0_0_1 - 0.262655698853617*G0_1_0 - 0.667403824955903*G0_1_1;
    A[322] = -2.820319389329784*G0_0_0 - 1.158268573633147*G0_0_1 - 1.158268573633146*G0_1_0 + 0.503782242063497*G0_1_1;
    A[323] = 0.731991291887115*G0_0_0 + 2.040963955026438*G0_0_1 + 2.040963955026444*G0_1_0 - 0.611428020282192*G0_1_1;
    A[324] = -0.516699735449729*G0_0_0 - 0.930059523809514*G0_0_1 - 0.930059523809522*G0_1_0 + 0.680321318342152*G0_1_1;
    A[325] = 0.262655698853612*G0_0_1 + 0.262655698853617*G0_1_0 - 0.465029761904759*G0_1_1;
    A[326] = 0.503782242063491*G0_0_0 - 1.158268573633146*G0_0_1 - 1.158268573633146*G0_1_0 - 2.820319389329788*G0_1_1;
    A[327] = -0.611428020282187*G0_0_0 + 2.040963955026436*G0_0_1 + 2.040963955026439*G0_1_0 + 0.731991291887114*G0_1_1;
    A[328] = 0.680321318342151*G0_0_0 - 0.930059523809511*G0_0_1 - 0.930059523809514*G0_1_0 - 0.516699735449724*G0_1_1;
    A[329] = -0.465029761904762*G0_0_0 + 0.262655698853609*G0_0_1 + 0.262655698853611*G0_1_0;
    A[330] = 7.061563051146328*G0_0_0 + 3.100198412698385*G0_0_1 + 3.100198412698385*G0_1_0 + 7.061563051146344*G0_1_1;
    A[331] = -6.329571759259205*G0_0_0 - 3.057140101410904*G0_0_1 - 3.057140101410903*G0_1_0 - 1.808449074074050*G0_1_1;
    A[332] = 2.755731922398561*G0_0_0 + 1.377865961199279*G0_0_1 + 1.377865961199273*G0_1_0 + 1.033399470899456*G0_1_1;
    A[333] = -1.808449074074052*G0_0_0 - 3.057140101410909*G0_0_1 - 3.057140101410913*G0_1_0 - 6.329571759259228*G0_1_1;
    A[334] = 1.420924272486760*G0_0_0 + 1.463982583774236*G0_0_1 + 1.463982583774242*G0_1_0 + 1.420924272486758*G0_1_1;
    A[335] = 1.033399470899458*G0_0_0 + 1.377865961199280*G0_0_1 + 1.377865961199284*G0_1_0 + 2.755731922398576*G0_1_1;
    A[336] = -0.053822889109348*G0_0_0 - 0.053822889109348*G0_0_1 - 0.053822889109345*G0_1_0 - 0.053822889109345*G0_1_1;
    A[337] = -0.053822889109348*G0_0_0;
    A[338] = 0.107645778218692*G0_1_1;
    A[339] = 1.356336805555544*G0_0_0 + 0.572675540123448*G0_0_1 + 0.572675540123448*G0_1_0;
    A[340] = 0.387524801587296*G0_0_0 + 0.859013310185176*G0_0_1 + 0.859013310185176*G0_1_0 + 1.011870315255723*G0_1_1;
    A[341] = 0.043058311287473*G0_0_0 + 0.374607308201054*G0_0_1 + 0.374607308201058*G0_1_0 + 1.033399470899467*G0_1_1;
    A[342] = -0.073199129188716*G0_0_1 - 0.073199129188719*G0_1_0 - 0.419818535052914*G0_1_1;
    A[343] = 1.356336805555540*G0_0_0 + 0.783661265432093*G0_0_1 + 0.783661265432090*G0_1_0 + 0.210985725308635*G0_1_1;
    A[344] = 0.387524801587305*G0_0_0 - 0.471488508597877*G0_0_1 - 0.471488508597877*G0_1_0 - 0.318631503527329*G0_1_1;
    A[345] = 0.043058311287476*G0_0_0 - 0.331548996913581*G0_0_1 - 0.331548996913586*G0_1_0 + 0.327243165784826*G0_1_1;
    A[346] = 0.073199129188713*G0_0_1 + 0.073199129188719*G0_1_0 - 0.273420276675479*G0_1_1;
    A[347] = 0.049517057980597*G0_0_0 + 0.622192598104045*G0_0_1 + 0.622192598104045*G0_1_0 + 1.194868138227501*G0_1_1;
    A[348] = 0.004305831128755*G0_0_0 - 2.409112516534365*G0_0_1 - 2.409112516534368*G0_1_0 - 3.810660548941772*G0_1_1;
    A[349] = 0.004305831128741*G0_0_0 + 2.413418347663114*G0_0_1 + 2.413418347663115*G0_1_0 + 1.011870315255709*G0_1_1;
    A[350] = 0.049517057980604*G0_0_0 - 0.572675540123447*G0_0_1 - 0.572675540123445*G0_1_0;
    A[351] = -6.329571759259205*G0_0_0 - 3.057140101410903*G0_0_1 - 3.057140101410904*G0_1_0 - 1.808449074074050*G0_1_1;
    A[352] = 9.946469907407328*G0_0_0 + 4.973234953703654*G0_0_1 + 4.973234953703654*G0_1_0 + 8.654720568783018*G0_1_1;
    A[353] = -6.329571759259211*G0_0_0 - 3.272431657848292*G0_0_1 - 3.272431657848290*G0_1_0 - 2.023740630511431*G0_1_1;
    A[354] = -0.387524801587315*G0_0_0 + 2.551204943783046*G0_0_1 + 2.551204943783056*G0_1_0 - 0.387524801587316*G0_1_1;
    A[355] = -0.387524801587290*G0_0_0 - 2.938729745370347*G0_0_1 - 2.938729745370356*G0_1_0 - 5.877459490740724*G0_1_1;
    A[356] = -0.086116622574949*G0_0_0 - 0.043058311287470*G0_0_1 - 0.043058311287472*G0_1_0 + 1.420924272486778*G0_1_1;
    A[357] = 0.107645778218695*G0_0_0 + 0.107645778218695*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218693*G0_1_1;
    A[358] = -0.215291556437389*G0_0_0;
    A[359] = 0.107645778218694*G0_1_1;
    A[360] = -2.820319389329791*G0_0_0 - 1.662050815696639*G0_0_1 - 1.662050815696638*G0_1_0;
    A[361] = 0.731991291887125*G0_0_0 - 1.308972663139319*G0_0_1 - 1.308972663139327*G0_1_0 - 3.961364638447955*G0_1_1;
    A[362] = -0.516699735449732*G0_0_0 + 0.413359788359787*G0_0_1 + 0.413359788359791*G0_1_0 + 2.023740630511455*G0_1_1;
    A[363] = -0.262655698853611*G0_0_1 - 0.262655698853617*G0_1_0 - 0.990341159611988*G0_1_1;
    A[364] = -0.667403824955900*G0_0_0 - 0.404748126102292*G0_0_1 - 0.404748126102291*G0_1_0 - 0.142092427248677*G0_1_1;
    A[365] = -0.344466490299826*G0_0_0 + 0.103339947089946*G0_0_1 + 0.103339947089946*G0_1_0 + 0.034446649029983*G0_1_1;
    A[366] = -0.516699735449731*G0_0_0 - 0.068893298059964*G0_0_1 - 0.068893298059966*G0_1_0 + 0.034446649029982*G0_1_1;
    A[367] = 0.262655698853614*G0_0_1 + 0.262655698853617*G0_1_0 - 0.142092427248675*G0_1_1;
    A[368] = -0.465029761904758*G0_0_0 - 0.727685460758367*G0_0_1 - 0.727685460758369*G0_1_0 - 0.990341159611983*G0_1_1;
    A[369] = 0.680321318342142*G0_0_0 + 1.610380842151657*G0_0_1 + 1.610380842151657*G0_1_0 + 2.023740630511442*G0_1_1;
    A[370] = -0.611428020282179*G0_0_0 - 2.652391975308620*G0_0_1 - 2.652391975308619*G0_1_0 - 3.961364638447944*G0_1_1;
    A[371] = 0.503782242063487*G0_0_0 + 1.662050815696638*G0_0_1 + 1.662050815696636*G0_1_0;
    A[372] = 2.755731922398561*G0_0_0 + 1.377865961199273*G0_0_1 + 1.377865961199279*G0_1_0 + 1.033399470899456*G0_1_1;
    A[373] = -6.329571759259211*G0_0_0 - 3.272431657848290*G0_0_1 - 3.272431657848292*G0_1_0 - 2.023740630511431*G0_1_1;
    A[374] = 7.061563051146342*G0_0_0 + 3.961364638447941*G0_0_1 + 3.961364638447942*G0_1_0 + 7.922729276895899*G0_1_1;
    A[375] = 1.420924272486778*G0_0_0 - 0.043058311287466*G0_0_1 - 0.043058311287471*G0_1_0 - 0.086116622574950*G0_1_1;
    A[376] = -1.808449074074074*G0_0_0 + 1.248691027336849*G0_0_1 + 1.248691027336853*G0_1_0 - 2.023740630511464*G0_1_1;
    A[377] = 1.033399470899462*G0_0_0 - 0.344466490299829*G0_0_1 - 0.344466490299826*G0_1_0 + 1.033399470899463*G0_1_1;
    A[378] = -0.053822889109345*G0_0_0 - 0.053822889109344*G0_0_1 - 0.053822889109345*G0_1_0 - 0.053822889109345*G0_1_1;
    A[379] = 0.107645778218695*G0_0_0;
    A[380] = -0.053822889109345*G0_1_1;
    A[381] = -0.419818535052912*G0_0_0 - 0.073199129188713*G0_0_1 - 0.073199129188718*G0_1_0;
    A[382] = 1.033399470899471*G0_0_0 + 0.374607308201056*G0_0_1 + 0.374607308201062*G0_1_0 + 0.043058311287475*G0_1_1;
    A[383] = 1.011870315255721*G0_0_0 + 0.859013310185182*G0_0_1 + 0.859013310185171*G0_1_0 + 0.387524801587299*G0_1_1;
    A[384] = 0.572675540123449*G0_0_1 + 0.572675540123458*G0_1_0 + 1.356336805555546*G0_1_1;
    A[385] = 1.194868138227503*G0_0_0 + 0.622192598104044*G0_0_1 + 0.622192598104048*G0_1_0 + 0.049517057980592*G0_1_1;
    A[386] = -3.810660548941778*G0_0_0 - 2.409112516534371*G0_0_1 - 2.409112516534381*G0_1_0 + 0.004305831128755*G0_1_1;
    A[387] = 1.011870315255722*G0_0_0 + 2.413418347663121*G0_0_1 + 2.413418347663131*G0_1_0 + 0.004305831128745*G0_1_1;
    A[388] = -0.572675540123452*G0_0_1 - 0.572675540123459*G0_1_0 + 0.049517057980597*G0_1_1;
    A[389] = 0.210985725308637*G0_0_0 + 0.783661265432094*G0_0_1 + 0.783661265432092*G0_1_0 + 1.356336805555546*G0_1_1;
    A[390] = -0.318631503527332*G0_0_0 - 0.471488508597880*G0_0_1 - 0.471488508597878*G0_1_0 + 0.387524801587306*G0_1_1;
    A[391] = 0.327243165784829*G0_0_0 - 0.331548996913584*G0_0_1 - 0.331548996913582*G0_1_0 + 0.043058311287474*G0_1_1;
    A[392] = -0.273420276675483*G0_0_0 + 0.073199129188714*G0_0_1 + 0.073199129188714*G0_1_0;
    A[393] = -1.808449074074052*G0_0_0 - 3.057140101410913*G0_0_1 - 3.057140101410909*G0_1_0 - 6.329571759259229*G0_1_1;
    A[394] = -0.387524801587315*G0_0_0 + 2.551204943783056*G0_0_1 + 2.551204943783046*G0_1_0 - 0.387524801587316*G0_1_1;
    A[395] = 1.420924272486777*G0_0_0 - 0.043058311287471*G0_0_1 - 0.043058311287466*G0_1_0 - 0.086116622574950*G0_1_1;
    A[396] = 8.654720568783029*G0_0_0 + 4.973234953703671*G0_0_1 + 4.973234953703671*G0_1_0 + 9.946469907407362*G0_1_1;
    A[397] = -5.877459490740724*G0_0_0 - 2.938729745370362*G0_0_1 - 2.938729745370356*G0_1_0 - 0.387524801587289*G0_1_1;
    A[398] = -2.023740630511443*G0_0_0 - 3.272431657848301*G0_0_1 - 3.272431657848301*G0_1_0 - 6.329571759259228*G0_1_1;
    A[399] = 0.107645778218693*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218694*G0_1_1;
    A[400] = -0.053822889109346*G0_0_0;
    A[401] = -0.053822889109347*G0_1_1;
    A[402] = 1.194868138227510*G0_0_0 + 0.572675540123458*G0_0_1 + 0.572675540123456*G0_1_0;
    A[403] = -3.810660548941786*G0_0_0 - 1.401548032407407*G0_0_1 - 1.401548032407399*G0_1_0 + 1.011870315255728*G0_1_1;
    A[404] = 1.011870315255731*G0_0_0 - 1.401548032407398*G0_0_1 - 1.401548032407405*G0_1_0 - 3.810660548941784*G0_1_1;
    A[405] = 0.572675540123454*G0_0_1 + 0.572675540123459*G0_1_0 + 1.194868138227511*G0_1_1;
    A[406] = -0.419818535052909*G0_0_0 - 0.346619405864193*G0_0_1 - 0.346619405864194*G0_1_0 - 0.273420276675480*G0_1_1;
    A[407] = 1.033399470899472*G0_0_0 + 0.658792162698411*G0_0_1 + 0.658792162698408*G0_1_0 + 0.327243165784828*G0_1_1;
    A[408] = 1.011870315255725*G0_0_0 + 0.152857005070542*G0_0_1 + 0.152857005070550*G0_1_0 - 0.318631503527336*G0_1_1;
    A[409] = -0.572675540123451*G0_0_1 - 0.572675540123459*G0_1_0 + 0.210985725308640*G0_1_1;
    A[410] = -0.273420276675480*G0_0_0 - 0.346619405864195*G0_0_1 - 0.346619405864193*G0_1_0 - 0.419818535052906*G0_1_1;
    A[411] = 0.327243165784827*G0_0_0 + 0.658792162698408*G0_0_1 + 0.658792162698407*G0_1_0 + 1.033399470899466*G0_1_1;
    A[412] = -0.318631503527332*G0_0_0 + 0.152857005070550*G0_0_1 + 0.152857005070549*G0_1_0 + 1.011870315255735*G0_1_1;
    A[413] = 0.210985725308638*G0_0_0 - 0.572675540123458*G0_0_1 - 0.572675540123458*G0_1_0;
    A[414] = 1.420924272486760*G0_0_0 + 1.463982583774242*G0_0_1 + 1.463982583774236*G0_1_0 + 1.420924272486759*G0_1_1;
    A[415] = -0.387524801587290*G0_0_0 - 2.938729745370356*G0_0_1 - 2.938729745370347*G0_1_0 - 5.877459490740724*G0_1_1;
    A[416] = -1.808449074074073*G0_0_0 + 1.248691027336853*G0_0_1 + 1.248691027336849*G0_1_0 - 2.023740630511464*G0_1_1;
    A[417] = -5.877459490740724*G0_0_0 - 2.938729745370356*G0_0_1 - 2.938729745370362*G0_1_0 - 0.387524801587289*G0_1_1;
    A[418] = 8.654720568783038*G0_0_0 + 3.681485615079354*G0_0_1 + 3.681485615079354*G0_1_0 + 8.654720568783047*G0_1_1;
    A[419] = -2.023740630511456*G0_0_0 + 1.248691027336855*G0_0_1 + 1.248691027336855*G0_1_0 - 1.808449074074072*G0_1_1;
    A[420] = 0.107645778218692*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218692*G0_1_1;
    A[421] = 0.107645778218693*G0_0_0;
    A[422] = -0.215291556437390*G0_1_1;
    A[423] = -0.990341159611986*G0_0_0 - 0.262655698853617*G0_0_1 - 0.262655698853611*G0_1_0;
    A[424] = 2.023740630511452*G0_0_0 + 0.413359788359790*G0_0_1 + 0.413359788359781*G0_1_0 - 0.516699735449731*G0_1_1;
    A[425] = -3.961364638447952*G0_0_0 - 1.308972663139327*G0_0_1 - 1.308972663139316*G0_1_0 + 0.731991291887121*G0_1_1;
    A[426] = -1.662050815696636*G0_0_1 - 1.662050815696642*G0_1_0 - 2.820319389329788*G0_1_1;
    A[427] = -0.990341159611984*G0_0_0 - 0.727685460758368*G0_0_1 - 0.727685460758370*G0_1_0 - 0.465029761904754*G0_1_1;
    A[428] = 2.023740630511449*G0_0_0 + 1.610380842151659*G0_0_1 + 1.610380842151668*G0_1_0 + 0.680321318342143*G0_1_1;
    A[429] = -3.961364638447949*G0_0_0 - 2.652391975308624*G0_0_1 - 2.652391975308629*G0_1_0 - 0.611428020282181*G0_1_1;
    A[430] = 1.662050815696640*G0_0_1 + 1.662050815696642*G0_1_0 + 0.503782242063490*G0_1_1;
    A[431] = -0.142092427248674*G0_0_0 - 0.404748126102290*G0_0_1 - 0.404748126102288*G0_1_0 - 0.667403824955905*G0_1_1;
    A[432] = 0.034446649029980*G0_0_0 + 0.103339947089945*G0_0_1 + 0.103339947089945*G0_1_0 - 0.344466490299826*G0_1_1;
    A[433] = 0.034446649029983*G0_0_0 - 0.068893298059964*G0_0_1 - 0.068893298059963*G0_1_0 - 0.516699735449732*G0_1_1;
    A[434] = -0.142092427248676*G0_0_0 + 0.262655698853616*G0_0_1 + 0.262655698853614*G0_1_0;
    A[435] = 1.033399470899458*G0_0_0 + 1.377865961199284*G0_0_1 + 1.377865961199279*G0_1_0 + 2.755731922398576*G0_1_1;
    A[436] = -0.086116622574949*G0_0_0 - 0.043058311287472*G0_0_1 - 0.043058311287470*G0_1_0 + 1.420924272486778*G0_1_1;
    A[437] = 1.033399470899462*G0_0_0 - 0.344466490299826*G0_0_1 - 0.344466490299829*G0_1_0 + 1.033399470899463*G0_1_1;
    A[438] = -2.023740630511443*G0_0_0 - 3.272431657848301*G0_0_1 - 3.272431657848301*G0_1_0 - 6.329571759259228*G0_1_1;
    A[439] = -2.023740630511455*G0_0_0 + 1.248691027336855*G0_0_1 + 1.248691027336854*G0_1_0 - 1.808449074074072*G0_1_1;
    A[440] = 7.922729276895899*G0_0_0 + 3.961364638447944*G0_0_1 + 3.961364638447944*G0_1_0 + 7.061563051146344*G0_1_1;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson2d_5_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson2d_5_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    21
    // Number of operations (multiply-add pairs) for tensor contraction: 430
    // Total number of operations (multiply-add pairs):                  460
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    
    // Compute element tensor
    A[0] = 0.001389452561328*G0_0 + 0.000123877456777*G0_1 + 0.000123877456777*G0_2 + 0.000363647010782*G0_3 + 0.000207201813105*G0_4 + 0.000207201813105*G0_5 + 0.000363647010782*G0_6 + 0.001181363486051*G0_7 - 0.000958243145743*G0_8 + 0.000462681126744*G0_9 - 0.000022964432687*G0_10 + 0.001181363486051*G0_11 - 0.000958243145743*G0_12 + 0.000462681126744*G0_13 - 0.000022964432687*G0_14 + 0.000892481361231*G0_15 - 0.000974683591871*G0_16 + 0.000879433388114*G0_17 - 0.000974683591871*G0_18 + 0.000649789061247*G0_19 + 0.000879433388114*G0_20;
    A[1] = 0.000123877456777*G0_0 + 0.001389452561328*G0_1 + 0.000123877456777*G0_2 + 0.001181363486051*G0_3 - 0.000958243145743*G0_4 + 0.000462681126744*G0_5 - 0.000022964432687*G0_6 + 0.000363647010782*G0_7 + 0.000207201813105*G0_8 + 0.000207201813105*G0_9 + 0.000363647010782*G0_10 - 0.000022964432687*G0_11 + 0.000462681126744*G0_12 - 0.000958243145743*G0_13 + 0.001181363486051*G0_14 + 0.000879433388114*G0_15 - 0.000974683591871*G0_16 + 0.000892481361231*G0_17 + 0.000649789061247*G0_18 - 0.000974683591871*G0_19 + 0.000879433388114*G0_20;
    A[2] = 0.000123877456777*G0_0 + 0.000123877456777*G0_1 + 0.001389452561328*G0_2 - 0.000022964432687*G0_3 + 0.000462681126744*G0_4 - 0.000958243145743*G0_5 + 0.001181363486051*G0_6 - 0.000022964432687*G0_7 + 0.000462681126744*G0_8 - 0.000958243145743*G0_9 + 0.001181363486051*G0_10 + 0.000363647010782*G0_11 + 0.000207201813105*G0_12 + 0.000207201813105*G0_13 + 0.000363647010782*G0_14 + 0.000879433388114*G0_15 + 0.000649789061247*G0_16 + 0.000879433388114*G0_17 - 0.000974683591871*G0_18 - 0.000974683591871*G0_19 + 0.000892481361231*G0_20;
    A[3] = 0.000363647010782*G0_0 + 0.001181363486051*G0_1 - 0.000022964432687*G0_2 + 0.014705065703330*G0_3 - 0.009583736254744*G0_4 + 0.007704828125835*G0_5 - 0.003969845820974*G0_6 - 0.000411011153199*G0_7 - 0.001448325016033*G0_8 - 0.000045667905911*G0_9 - 0.002482376885589*G0_10 - 0.002482376885589*G0_11 + 0.005760680131340*G0_12 - 0.007352532851665*G0_13 + 0.007352532851665*G0_14 + 0.000782878387045*G0_15 - 0.003816532136845*G0_16 + 0.010242658897173*G0_17 - 0.001370037177329*G0_18 + 0.000097859798381*G0_19 - 0.002805314220245*G0_20;
    A[4] = 0.000207201813105*G0_0 - 0.000958243145743*G0_1 + 0.000462681126744*G0_2 - 0.009583736254744*G0_3 + 0.022077170514671*G0_4 - 0.013478556230293*G0_5 + 0.007704828125835*G0_6 - 0.001448325016033*G0_7 + 0.002818362193362*G0_8 - 0.001356989204211*G0_9 + 0.005760680131340*G0_10 - 0.000045667905911*G0_11 - 0.001356989204211*G0_12 + 0.002948841924536*G0_13 - 0.007352532851665*G0_14 + 0.003131513548180*G0_15 - 0.005480148709316*G0_16 - 0.001435277042916*G0_17 - 0.000587158790284*G0_18 + 0.005284429112554*G0_19 + 0.005088709515793*G0_20;
    A[5] = 0.000207201813105*G0_0 + 0.000462681126744*G0_1 - 0.000958243145743*G0_2 + 0.007704828125835*G0_3 - 0.013478556230293*G0_4 + 0.022077170514671*G0_5 - 0.009583736254744*G0_6 - 0.000045667905911*G0_7 - 0.001356989204211*G0_8 + 0.002948841924536*G0_9 - 0.007352532851665*G0_10 - 0.001448325016033*G0_11 + 0.002818362193362*G0_12 - 0.001356989204211*G0_13 + 0.005760680131340*G0_14 + 0.003131513548180*G0_15 - 0.000587158790284*G0_16 + 0.005088709515793*G0_17 - 0.005480148709316*G0_18 + 0.005284429112554*G0_19 - 0.001435277042916*G0_20;
    A[6] = 0.000363647010782*G0_0 - 0.000022964432687*G0_1 + 0.001181363486051*G0_2 - 0.003969845820974*G0_3 + 0.007704828125835*G0_4 - 0.009583736254744*G0_5 + 0.014705065703330*G0_6 - 0.002482376885589*G0_7 + 0.005760680131340*G0_8 - 0.007352532851665*G0_9 + 0.007352532851665*G0_10 - 0.000411011153199*G0_11 - 0.001448325016033*G0_12 - 0.000045667905911*G0_13 - 0.002482376885589*G0_14 + 0.000782878387045*G0_15 - 0.001370037177329*G0_16 - 0.002805314220245*G0_17 - 0.003816532136845*G0_18 + 0.000097859798381*G0_19 + 0.010242658897173*G0_20;
    A[7] = 0.001181363486051*G0_0 + 0.000363647010782*G0_1 - 0.000022964432687*G0_2 - 0.000411011153199*G0_3 - 0.001448325016033*G0_4 - 0.000045667905911*G0_5 - 0.002482376885589*G0_6 + 0.014705065703330*G0_7 - 0.009583736254744*G0_8 + 0.007704828125835*G0_9 - 0.003969845820974*G0_10 + 0.007352532851665*G0_11 - 0.007352532851665*G0_12 + 0.005760680131340*G0_13 - 0.002482376885589*G0_14 + 0.010242658897173*G0_15 - 0.003816532136845*G0_16 + 0.000782878387045*G0_17 + 0.000097859798381*G0_18 - 0.001370037177329*G0_19 - 0.002805314220245*G0_20;
    A[8] = -0.000958243145743*G0_0 + 0.000207201813105*G0_1 + 0.000462681126744*G0_2 - 0.001448325016033*G0_3 + 0.002818362193362*G0_4 - 0.001356989204211*G0_5 + 0.005760680131340*G0_6 - 0.009583736254744*G0_7 + 0.022077170514671*G0_8 - 0.013478556230293*G0_9 + 0.007704828125835*G0_10 - 0.007352532851665*G0_11 + 0.002948841924536*G0_12 - 0.001356989204211*G0_13 - 0.000045667905911*G0_14 - 0.001435277042916*G0_15 - 0.005480148709316*G0_16 + 0.003131513548180*G0_17 + 0.005284429112554*G0_18 - 0.000587158790284*G0_19 + 0.005088709515793*G0_20;
    A[9] = 0.000462681126744*G0_0 + 0.000207201813105*G0_1 - 0.000958243145743*G0_2 - 0.000045667905911*G0_3 - 0.001356989204211*G0_4 + 0.002948841924536*G0_5 - 0.007352532851665*G0_6 + 0.007704828125835*G0_7 - 0.013478556230293*G0_8 + 0.022077170514671*G0_9 - 0.009583736254744*G0_10 + 0.005760680131340*G0_11 - 0.001356989204211*G0_12 + 0.002818362193362*G0_13 - 0.001448325016033*G0_14 + 0.005088709515793*G0_15 - 0.000587158790284*G0_16 + 0.003131513548180*G0_17 + 0.005284429112554*G0_18 - 0.005480148709316*G0_19 - 0.001435277042916*G0_20;
    A[10] = -0.000022964432687*G0_0 + 0.000363647010782*G0_1 + 0.001181363486051*G0_2 - 0.002482376885589*G0_3 + 0.005760680131340*G0_4 - 0.007352532851665*G0_5 + 0.007352532851665*G0_6 - 0.003969845820974*G0_7 + 0.007704828125835*G0_8 - 0.009583736254744*G0_9 + 0.014705065703330*G0_10 - 0.002482376885589*G0_11 - 0.000045667905911*G0_12 - 0.001448325016033*G0_13 - 0.000411011153199*G0_14 - 0.002805314220245*G0_15 - 0.001370037177329*G0_16 + 0.000782878387045*G0_17 + 0.000097859798381*G0_18 - 0.003816532136845*G0_19 + 0.010242658897173*G0_20;
    A[11] = 0.001181363486051*G0_0 - 0.000022964432687*G0_1 + 0.000363647010782*G0_2 - 0.002482376885589*G0_3 - 0.000045667905911*G0_4 - 0.001448325016033*G0_5 - 0.000411011153199*G0_6 + 0.007352532851665*G0_7 - 0.007352532851665*G0_8 + 0.005760680131340*G0_9 - 0.002482376885589*G0_10 + 0.014705065703330*G0_11 - 0.009583736254744*G0_12 + 0.007704828125835*G0_13 - 0.003969845820974*G0_14 + 0.010242658897173*G0_15 + 0.000097859798381*G0_16 - 0.002805314220245*G0_17 - 0.003816532136845*G0_18 - 0.001370037177329*G0_19 + 0.000782878387045*G0_20;
    A[12] = -0.000958243145743*G0_0 + 0.000462681126744*G0_1 + 0.000207201813105*G0_2 + 0.005760680131340*G0_3 - 0.001356989204211*G0_4 + 0.002818362193362*G0_5 - 0.001448325016033*G0_6 - 0.007352532851665*G0_7 + 0.002948841924536*G0_8 - 0.001356989204211*G0_9 - 0.000045667905911*G0_10 - 0.009583736254744*G0_11 + 0.022077170514671*G0_12 - 0.013478556230293*G0_13 + 0.007704828125835*G0_14 - 0.001435277042916*G0_15 + 0.005284429112554*G0_16 + 0.005088709515793*G0_17 - 0.005480148709316*G0_18 - 0.000587158790284*G0_19 + 0.003131513548180*G0_20;
    A[13] = 0.000462681126744*G0_0 - 0.000958243145743*G0_1 + 0.000207201813105*G0_2 - 0.007352532851665*G0_3 + 0.002948841924536*G0_4 - 0.001356989204211*G0_5 - 0.000045667905911*G0_6 + 0.005760680131340*G0_7 - 0.001356989204211*G0_8 + 0.002818362193362*G0_9 - 0.001448325016033*G0_10 + 0.007704828125835*G0_11 - 0.013478556230293*G0_12 + 0.022077170514671*G0_13 - 0.009583736254744*G0_14 + 0.005088709515793*G0_15 + 0.005284429112554*G0_16 - 0.001435277042916*G0_17 - 0.000587158790284*G0_18 - 0.005480148709316*G0_19 + 0.003131513548180*G0_20;
    A[14] = -0.000022964432687*G0_0 + 0.001181363486051*G0_1 + 0.000363647010782*G0_2 + 0.007352532851665*G0_3 - 0.007352532851665*G0_4 + 0.005760680131340*G0_5 - 0.002482376885589*G0_6 - 0.002482376885589*G0_7 - 0.000045667905911*G0_8 - 0.001448325016033*G0_9 - 0.000411011153199*G0_10 - 0.003969845820974*G0_11 + 0.007704828125835*G0_12 - 0.009583736254744*G0_13 + 0.014705065703330*G0_14 - 0.002805314220245*G0_15 + 0.000097859798381*G0_16 + 0.010242658897173*G0_17 - 0.001370037177329*G0_18 - 0.003816532136845*G0_19 + 0.000782878387045*G0_20;
    A[15] = 0.000892481361231*G0_0 + 0.000879433388114*G0_1 + 0.000879433388114*G0_2 + 0.000782878387045*G0_3 + 0.003131513548180*G0_4 + 0.003131513548180*G0_5 + 0.000782878387045*G0_6 + 0.010242658897173*G0_7 - 0.001435277042916*G0_8 + 0.005088709515793*G0_9 - 0.002805314220245*G0_10 + 0.010242658897173*G0_11 - 0.001435277042916*G0_12 + 0.005088709515793*G0_13 - 0.002805314220245*G0_14 + 0.070459054834057*G0_15 - 0.015657567740902*G0_16 + 0.011743175805676*G0_17 - 0.015657567740902*G0_18 + 0.003914391935225*G0_19 + 0.011743175805676*G0_20;
    A[16] = -0.000974683591871*G0_0 - 0.000974683591871*G0_1 + 0.000649789061247*G0_2 - 0.003816532136845*G0_3 - 0.005480148709316*G0_4 - 0.000587158790284*G0_5 - 0.001370037177329*G0_6 - 0.003816532136845*G0_7 - 0.005480148709316*G0_8 - 0.000587158790284*G0_9 - 0.001370037177329*G0_10 + 0.000097859798381*G0_11 + 0.005284429112554*G0_12 + 0.005284429112554*G0_13 + 0.000097859798381*G0_14 - 0.015657567740902*G0_15 + 0.076330642736895*G0_16 - 0.015657567740902*G0_17 - 0.011743175805676*G0_18 - 0.011743175805676*G0_19 + 0.003914391935225*G0_20;
    A[17] = 0.000879433388114*G0_0 + 0.000892481361231*G0_1 + 0.000879433388114*G0_2 + 0.010242658897173*G0_3 - 0.001435277042916*G0_4 + 0.005088709515793*G0_5 - 0.002805314220245*G0_6 + 0.000782878387045*G0_7 + 0.003131513548180*G0_8 + 0.003131513548180*G0_9 + 0.000782878387045*G0_10 - 0.002805314220245*G0_11 + 0.005088709515793*G0_12 - 0.001435277042916*G0_13 + 0.010242658897173*G0_14 + 0.011743175805676*G0_15 - 0.015657567740902*G0_16 + 0.070459054834057*G0_17 + 0.003914391935225*G0_18 - 0.015657567740902*G0_19 + 0.011743175805676*G0_20;
    A[18] = -0.000974683591871*G0_0 + 0.000649789061247*G0_1 - 0.000974683591871*G0_2 - 0.001370037177329*G0_3 - 0.000587158790284*G0_4 - 0.005480148709316*G0_5 - 0.003816532136845*G0_6 + 0.000097859798381*G0_7 + 0.005284429112554*G0_8 + 0.005284429112554*G0_9 + 0.000097859798381*G0_10 - 0.003816532136845*G0_11 - 0.005480148709316*G0_12 - 0.000587158790284*G0_13 - 0.001370037177329*G0_14 - 0.015657567740902*G0_15 - 0.011743175805676*G0_16 + 0.003914391935225*G0_17 + 0.076330642736895*G0_18 - 0.011743175805676*G0_19 - 0.015657567740902*G0_20;
    A[19] = 0.000649789061247*G0_0 - 0.000974683591871*G0_1 - 0.000974683591871*G0_2 + 0.000097859798381*G0_3 + 0.005284429112554*G0_4 + 0.005284429112554*G0_5 + 0.000097859798381*G0_6 - 0.001370037177329*G0_7 - 0.000587158790284*G0_8 - 0.005480148709316*G0_9 - 0.003816532136845*G0_10 - 0.001370037177329*G0_11 - 0.000587158790284*G0_12 - 0.005480148709316*G0_13 - 0.003816532136845*G0_14 + 0.003914391935225*G0_15 - 0.011743175805676*G0_16 - 0.015657567740902*G0_17 - 0.011743175805676*G0_18 + 0.076330642736895*G0_19 - 0.015657567740902*G0_20;
    A[20] = 0.000879433388114*G0_0 + 0.000879433388114*G0_1 + 0.000892481361231*G0_2 - 0.002805314220245*G0_3 + 0.005088709515793*G0_4 - 0.001435277042916*G0_5 + 0.010242658897173*G0_6 - 0.002805314220245*G0_7 + 0.005088709515793*G0_8 - 0.001435277042916*G0_9 + 0.010242658897173*G0_10 + 0.000782878387045*G0_11 + 0.003131513548180*G0_12 + 0.003131513548180*G0_13 + 0.000782878387045*G0_14 + 0.011743175805676*G0_15 + 0.003914391935225*G0_16 + 0.011743175805676*G0_17 - 0.015657567740902*G0_18 - 0.015657567740902*G0_19 + 0.070459054834057*G0_20;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson2d_5_form_0: public ufc::form
{
public:

  /// Constructor
  poisson2d_5_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5), 0), MultiIndex((Index(0),), {Index(0): 2})), SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5), 1), MultiIndex((Index(0),), {Index(0): 2}))), MultiIndex((Index(0),), {Index(0): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson2d_5_form_1: public ufc::form
{
public:

  /// Constructor
  poisson2d_5_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 5), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace Poisson2D_5
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson2d_5_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_1 LinearForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
