/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.SaxonIterate;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;

public class SaxonFinally
extends StyleElement {
    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            this.checkUnknownAttribute(nc);
        }
    }

    public void validate() throws XPathException {
        NodeInfo sib;
        StyleElement parent = (StyleElement)this.getParent();
        if (!(parent instanceof SaxonIterate)) {
            this.compileError("saxon:finally is not allowed as a child of " + parent.getDisplayName(), "XTSE0010");
        }
        AxisIterator sibs = this.iterateAxis((byte)7, NodeKindTest.ELEMENT);
        while ((sib = (NodeInfo)sibs.next()) != null) {
            if (sib instanceof XSLFallback) continue;
            this.compileError("saxon:finally must be the last child of saxon:iterate", "XTSE0010");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
    }
}

