/* Generated By:JJTree: Do not edit this line. SimpleNode.java */

package org.incava.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.incava.log.Log;


public class SimpleNode implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;

    protected Token first, last;
    protected JavadocNode javadoc;
    protected boolean javadocParsed;

    public SimpleNode(int i) {
        id = i;
        javadocParsed = false;
        javadoc = null;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        parser = p;
    }

    public JavadocNode getJavadoc()
    {
        if (!javadocParsed) {
            javadocParsed = true;

            Token st = first.specialToken;
            while (javadoc == null && st != null) {
                javadoc = JavadocNode.parse(st.image, st.beginLine, st.beginColumn);
                st = st.specialToken;
            }
        }
        return javadoc;
    }

    public void jjtOpen() {
        first = parser.getToken(1);	// new
    }

    public void jjtClose() {
        last = parser.getToken(0);	// new
    }

    public Token getFirstToken() { return first; } // new
    public Token getLastToken() { return last; }   // new
  
    public void jjtSetParent(Node n) { parent = n; }
    public Node jjtGetParent() { return parent; }

    public void jjtAddChild(Node n, int i) {
        if (children == null) {
            children = new Node[i + 1];
        } else if (i >= children.length) {
            Node c[] = new Node[i + 1];
            System.arraycopy(children, 0, c, 0, children.length);
            children = c;
        }
        children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return children[i];
    }

    public int jjtGetNumChildren() {
        return (children == null) ? 0 : children.length;
    }

    /** Accept the visitor. **/
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    /** Accept the visitor. **/
    public Object childrenAccept(JavaParserVisitor visitor, Object data) {
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    /* You can override these two methods in subclasses of SimpleNode to
       customize the way the node appears when the tree is dumped.  If
       your output uses more than one line you should override
       toString(String), otherwise overriding toString() is probably all
       you need to do. */

    public String toString() { 
        return Java14ParserTreeConstants.jjtNodeName[id];
    }
    
    public void dump() 
    {
        dump("");
    }

    /**
     * Returns a list of children, both nodes and tokens.
     */
    public List getChildren() 
    {
        List list = new ArrayList();
        Token t1 = getFirstToken();
        Token t = new Token();
        t.next = t1;
        
        SimpleNode n;
        for (int ord = 0; ord < jjtGetNumChildren(); ord++) {
            n = (SimpleNode)jjtGetChild(ord);
            while (true) {
                t = t.next;
                if (t == n.getFirstToken()) 
                    break;
                list.add(t);
            }
            list.add(n);
            t = n.getLastToken();
        }

        while (t != getLastToken()) {
            t = t.next;
            list.add(t);
        }
        return list;
    }

    /**
     * Override this method if you want to customize how the node dumps out its
     * children.
     */
    protected void dump(String prefix) 
    {
        Token t1 = getFirstToken();
        Token t = new Token();
        t.next = t1;

        System.out.println(prefix + "<" + toString() + ">" + "[" + first.beginLine + ":" + first.beginColumn + ":" + last.endLine + ":" + last.endColumn + "] ");
        List children = getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Token) {
                print(prefix, (Token)obj);
            }
            else {
                ((SimpleNode)obj).dump(prefix + "    ");
            }
        }
    }  
  
    protected void print(String prefix, Token t) 
    {
        Token st = t.specialToken;
        if (st != null) {
            while (st.specialToken != null) {
                st = st.specialToken;
            }
            
            while (st != null) {
                String s = st.toString().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                System.out.println(prefix + "    s[" + st.beginLine + ":" + st.beginColumn + ":" + st.endLine + ":" + st.endColumn + "] \"" + s + "\"");
                st = st.next;
            }
        }
        System.out.println(prefix + "    t[" + t.beginLine + ":" + t.beginColumn + ":" + t.endLine + ":" + t.endColumn + "] \"" + t + "\" (" + parser.getTokenKind(t) + ")");
    }

    public boolean hasPublicAccess()
    {
        return hasLeadingToken(Java14ParserConstants.PUBLIC);
    }

    public boolean isAbstract()
    {
        return hasLeadingToken(Java14ParserConstants.ABSTRACT);
    }

    public boolean hasProtectedAccess()
    {
        return hasLeadingToken(Java14ParserConstants.PROTECTED);
    }

    public boolean hasPackageAccess()
    {
        return !hasPublicAccess() && !hasProtectedAccess() && !hasPrivateAccess();
    }

    public boolean hasPrivateAccess()
    {
        return hasLeadingToken(Java14ParserConstants.PRIVATE);
    }

    /**
     * Returns whether this node has a matching token, occurring prior to any
     * non-tokens (i.e., before any child nodes).
     */
    public boolean hasLeadingToken(int tokenType)
    {
        List     children = getChildren();
        Iterator cit      = children.iterator();
        
        while (cit.hasNext()) {
            Object childObj = cit.next();
            if (childObj instanceof Token) {
                if (((Token)childObj).kind == tokenType) {
                    return true;
                }
            }
            else {
                break;
            }
        }
        return false;
    }

}
