#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef yagol_unistd_h
#define yagol_unistd_h
#include <unistd.h>
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

#include <sys/types.h>
#include <sys/stat.h>

using namespace std;

class YagolOptionOutputFileTest : public Test 
{
public:
    YagolOptionOutputFileTest();
    virtual void run();
};

YagolOptionOutputFileTest::YagolOptionOutputFileTest() : Test(true)
{
}

void YagolOptionOutputFileTest::run() 
{
    string filename("defaultName.txt");

    // test for a file that exists
    {
        yagol::OptionOutputFile opt("file", "file name", &filename);
        char*     name   = "/tmp/writable.txt";
        ofstream  nw(name, ios::out);
        chmod(name, 0664);
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            int nArgs = opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            TESTEQ(nArgs, 2, "proper number of arguments consumed");
            TESTEQ(filename, name, "file name set");
        }
        catch (const yagol::Exception& e) {
            FAIL("caught exception: " + e.message());
        }
        unlink(name);
    }

    // a non file (e.g., a directory)
    {
        yagol::OptionOutputFile opt("file", "file name", &filename);
        char*     name   = "/tmp";
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            FAIL("should have thrown exception");
        }
        catch (const yagol::NotAFileException& e) {
            // expected
        }
        catch (const yagol::Exception& e) {
            cout << "got exception: " << e << endl;
            FAIL("wrong exception thrown--expecting Not A File Exception");
        }
    }

    // a nonwritable file
    {
        yagol::OptionOutputFile opt("file", "file name", &filename);
        char*     name   = "/tmp/nonwritable.txt";
        ofstream  nw(name, ios::out);
        chmod(name, 0444);
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            FAIL("should have thrown exception");
        }
        catch (const yagol::FileNotWritableException& e) {
            // expected
        }
        catch (const yagol::Exception& e) {
            cout << "got exception: " << e << endl;
            FAIL("wrong exception thrown--expecting File Not Writable Exception");
        }
        unlink(name);
    }
}

int main(int argc, char** argv) 
{
    YagolOptionOutputFileTest t;
    t.run();
    cout << "yagol option boolean test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
