#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

class YagolOptionIntegerTest : public Test 
{
public:
    YagolOptionIntegerTest();
    virtual void run();
};

YagolOptionIntegerTest::YagolOptionIntegerTest() : Test(true)
{
}

void YagolOptionIntegerTest::run() 
{
    int i(4);
    yagol::OptionGeneric<int> goi("goi1", "yagol option integer #1", &i);
    TESTEQ(goi.defaultValue(), i, "default value appropriately set");

    {
        char* args[] = { "--goi1", "11" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        int nArgs = goi.consume("goi1", pos, NARGS, args);
        TESTEQ(nArgs, 2, "proper number of arguments consumed");
        TESTEQ(i, 11, "integer set to 11");
    }

    {
        char* args[] = { "--goi1" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            goi.consume("goi1", pos, NARGS, args);
            FAIL("exception should have been thrown by integer argument without value");
        }
        catch (const yagol::Exception& e) {
            // as expected
        }
    }

    {
        char* args[] = { "dummy", "--goi1", "17" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        bool match = goi.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, false, "unsuccessful match of argument");

        pos = 1;
        int nArgs = goi.consume("goi1", pos, NARGS, args);
        TESTEQ(nArgs, 2, "proper number of arguments consume");
        TESTEQ(i, 17, "integer set to 17");
    }
}

int main(int argc, char** argv) 
{
    YagolOptionIntegerTest t;
    t.run();
    cout << "yagol option integer test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
