#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#ifndef yagol_unistd_h
#define yagol_unistd_h
#include <unistd.h>
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

#include <sys/types.h>

#include <sys/stat.h>

using namespace std;

class YagolOptionInputFileTest : public Test 
{
public:
    YagolOptionInputFileTest();
    virtual void run();
};

YagolOptionInputFileTest::YagolOptionInputFileTest() : Test(true)
{
}

void YagolOptionInputFileTest::run() 
{
    string filename("defaultName.txt");

    // test for a file that exists
    {
        yagol::OptionInputFile opt("file", "file name", &filename);
        char*     name   = "Makefile";
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            int nArgs = opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            TESTEQ(nArgs, 2, "proper number of arguments consumed");
            TESTEQ(filename, name, "file name set");
        }
        catch (const yagol::Exception& e) {
            FAIL("caught exception: " + e.message());
        }
    }

    // test for a file that does not exist
    {
        yagol::OptionInputFile opt("file", "file name", &filename);
        char*     name   = "nonexisting.txt";
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            FAIL("should have thrown exception");
        }
        catch (const yagol::NoSuchFileException& e) {
            // expected
        }
        catch (const yagol::Exception& e) {
            cout << "got exception: " << e << endl;
            FAIL("wrong exception thrown--expecting No Such File Exception");
        }
    }

    // a nonreadable file
    {
        yagol::OptionInputFile opt("file", "file name", &filename);

        // write the file ...
        char*     name = "/tmp/nonreadable.txt";
        ofstream  nr(name, ios::out);
        nr.close();

        if (doctorj::Platform::isRegularFile(name)) {
            // ... then make it unreadable ...
            chmod(name, 0000);

            // ... then try to use it.
            char*     args[] = { "--file", name };
            const int NARGS  = sizeof(args) / sizeof(args[0]);
            int       pos    = 0;
            try {
                opt.consume("file", pos, NARGS, args);
                opt.validate(opt.value());
                FAIL("should have thrown exception");
            }
            catch (const yagol::FileNotReadableException& e) {
                // expected
            }
            catch (const yagol::Exception& e) {
                cout << "got exception: " << e << endl;
                FAIL("wrong exception thrown--expecting File Not Readable Exception");
            }
            unlink(name);
        }
        else {
            cout << "skipping nonreadable test" << endl;
        }
    }

    // a non file (e.g., a directory)
    {
        yagol::OptionInputFile opt("file", "not a file", &filename);
        char*     name   = "/tmp";
        char*     args[] = { "--file", name };
        const int NARGS  = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            opt.consume("file", pos, NARGS, args);
            opt.validate(opt.value());
            FAIL("should have thrown exception");
        }
        catch (const yagol::NotAFileException& e) {
            // expected
        }
        catch (const yagol::Exception& e) {
            cout << "got exception: " << e << endl;
            FAIL("wrong exception thrown--expecting Not A File Exception");
        }
    }
}

int main(int argc, char** argv) 
{
    YagolOptionInputFileTest t;
    t.run();
    cout << "yagol option boolean test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
