#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_iterator
#define std_iterator
#include <iterator>
#endif

#ifndef yagol_unistd_h
#define yagol_unistd_h
#include <unistd.h>
#endif

using namespace std;

class ConfigurationFileTest : public Test 
{
public:
    ConfigurationFileTest();
    virtual void run();
};

ConfigurationFileTest::ConfigurationFileTest() : Test(true)
{
}

void ConfigurationFileTest::run() 
{
    char* name = "cfgfile.rc";
    ofstream out(name);
    out << "# properties for the configuration file" << endl;
    out << "" << endl;
    out << "vec.field = hello" << endl;
    out << "vec.field += world" << endl;
    out.close();

    vector<string> vecField;

    yagol::AppOptionSet opts("cfg", "configuration file test");
    yagol::Option* vfo = opts.addOption("vec.field",
                                        "vector of strings",
                                        &vecField);
    vfo->setConfigOnly(true);
    opts.addConfigFile("cfgfile.rc");

    opts.process(0, NULL);

    cout << "-----vec.field-----" << endl;
    copy(vecField.begin(), vecField.end(), ostream_iterator<string>(cout, "--"));
    cout << endl;

    TESTEQ(vecField.size(), 2, "size of vector field");
    if (vecField.size() > 1) {
        TESTEQ(vecField[0], "hello", "value of first element of vector field");
        if (vecField.size() > 2) {
            TESTEQ(vecField[1], "world", "value of first element of vector field");
        }
    }
}

int main(int argc, char** argv) 
{
    ConfigurationFileTest t;
    t.run();
    cout << "configuration file test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
