#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

using namespace doctorj;

class StringEditorTest : public Test 
{
public:
    StringEditorTest();
    virtual void run();
};

StringEditorTest::StringEditorTest() : Test(true)
{
}

void StringEditorTest::run() 
{
#if 0
    char* orig = "* the DocumentType class. Specifically, it offers control over the mime";
    cout << "orig = " << orig << endl;

    StringEditor editor(orig);
    editor.add(new StringEditReplace("MIME", orig + 67, 4));
    editor.execute();
    cout << "editor.str() = '" << editor.str() << "'" << endl;
    TESTEQ("* the DocumentType class. Specifically, it offers control over the MIME", editor.str(), "execute after replace");
#endif

#if 0
    char* orig = "01234567890123456789";
    cout << "orig = " << orig << endl;

    StringEditor editor(orig);
    editor.add(new StringEditInsert("xyz", orig));
    editor.execute();
    TESTEQ("xyz01234567890123456789", editor.str(), "execute after insert");
#endif

#if 0
    char* orig = "01234567890123456789";
    StringEditor editor(orig);
    editor.add(new StringEditDelete(orig + 4, 5));
    cout << "first execution" << endl;
    editor.execute();
    TESTEQ("012390123456789", editor.str(), "execute after delete");

    editor.add(new StringEditInsert("xyz", orig + 9));
    cout << "second execution" << endl;
    editor.execute();
    TESTEQ("0123xyz90123456789", editor.str(), "execute after insert");

    editor.add(new StringEditReplace("new", orig + 10, 5));
    cout << "third execution" << endl;
    editor.execute();
    TESTEQ("0123xyz9new56789", editor.str(), "execute after replace");
#endif

#if 0
    char* orig = "/**\n"
        " * This description prevents an error message.\n"
        " */\n"
        "public class ErrorExceptionMismatchWithCode {\n"
        "\n"
        "    /**\n"
        "     * This description prevents an error message.\n"
        "     *\n"
        "     * @throws ArrayIndexOutOfBoundsException This describes the exception.\n"
        "     */\n"
        "    public void m1() throws NullPointerException {\n"
        "    }\n"
        "\n"
        "    /**\n"
        "     * This description prevents an error message.\n"
        "     *\n"
        "     * @throws NullPointerException This describes the exception.\n"
        "     */\n"
        "    public void m2() {\n"
        "    }\n"
        "\n"
        "}\n";
    cout << "orig = " << orig << endl;

    StringEditor editor(orig);
#endif

#if 0
    char*  orig = "this is the source string."; 
    StringEditor editor(orig);
    StringEditReplace* edit0 = new StringEditReplace("that", orig + 0, 4);
    editor.add(edit0);

    StringEditReplace* edit1 = new StringEditReplace("a", orig + 8, 3);
    editor.add(edit1);

#if 1
    StringEditReplace* edit2 = new StringEditInsert("and ", orig, 0);
    editor.add(edit2);

    StringEditReplace* edit3 = new StringEditReplace("in addition, ", orig, 0);
    editor.add(edit3);

    editor.add(new StringEditReplace("!", orig + strlen(orig) - 1, 1));
    editor.execute();
    TESTEQ("in addition, and that is a source string!", editor.str(), "execute");
    cout << endl;

    StringEditReplace* edit4 = new StringEditReplace(", too", orig + strlen(orig) - 1, 0);
    editor.add(edit4);
    editor.execute();
    TESTEQ("in addition, and that is a source string, too!", editor.str(), "execute");
    cout << endl;
#endif

    StringEditReplace edit5("PREVIEW: ", orig, 0);
    string prev5 = editor.preview(edit5);
    TESTEQ("PREVIEW: in addition, and that is a source string, too!", prev5, "preview");
    TESTEQ("in addition, and that is a source string, too!", editor.str(), "unchanged from preview");
    cout << endl;

    StringEditDelete* edit6 = new StringEditDelete(orig + 12, orig + 19, orig, orig + strlen(orig));
    editor.add(edit6);
    editor.execute();
    TESTEQ("in addition, and that is a string, too!", editor.str(), "execute");
    cout << endl;
#endif
}

int main(int argc, char** argv) 
{
    StringEditorTest t;
    t.run();
    cout << "string editor test results: " << t << endl;
    return t.nerrors();
}
