#ifndef ZipFile_h
#define ZipFile_h

#ifndef FileByteStream_h
#include "FileByteStream.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#include <stdio.h>

namespace doctorj
{
    class ZipEntry;
    
    class ZipFile
    {
    public:
        ZipFile(const string& name);

        virtual ~ZipFile();

        /**
         * Returns a list of name of the entries in this zip file.
         */
        vector<string> entryNames() const;

        /**
         * Extracts the bytes for the given file name. Returns the number of
         * bytes, or -1 on error. The caller is responsible for deleting the
         * bytes.
         */
        int getBytes(const string& name, char** bytes);

    protected:

        /**
         * Reads an entry from the list within the zip file.
         */
        void readEntry();

    private:
        string name_;

        vector<ZipEntry*> entries_;

        FileByteStreamLittleEndian stream_;

        FILE* zipfile_;
        
    };

}

#endif //! ZipFile_h
