#ifndef Writer_h
#define Writer_h

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;

namespace doctorj
{
    /**
     * Maintains the level of what it is writing, so that output can be
     * formatted with an appropriate level of indentation, especially useful for
     * XML.
     */
    class Writer
    {
    public:

        static int INDENT_SPACES;

        static int PAGE_WIDTH;

        static char PERIOD;
        
        Writer(ostream& os);

        virtual ~Writer();

    protected:

        void incrementLevel();

        void decrementLevel();

        int level();

        void setLevel(int l);

        void indent();

        template <typename T>
        void write(const string& label, T v);

        void write(const string& label, double v);

        /**
         * Writes the label on the left, and fills the remaining columns with
         * the fill character.
         */
        void writeLeft(const string& label);

        /**
         * Fills the columns with the character.
         */
        void fill(char ch);

        /**
         * Writes an empty line.
         */
        void blankLine();

    protected:

        ostream& stream();

        virtual void writeString(const string& label, const string& value) = 0;

        int level_;
        
        ostream& os_;
        
    };
    
    template <typename T>
    void Writer::write(const string& label, T v)
    {
        string str(StringUtilities::toString(v));
        writeString(label, str);
    }

}

#endif //! Writer_h
