#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef yagol_algorithm
#define yagol_algorithm
#include <algorithm>
#endif

#ifndef std_functional
#define std_functional
#include <functional>
#endif

#ifndef yagol_ctype_h
#define yagol_ctype_h
#include <ctype.h>
#endif

using namespace std;

struct dropcase : public unary_function<int, int> 
{
    int operator()(int ch) const { return tolower(ch); }
};  

struct upcase : public unary_function<int, int> 
{
    int operator()(int ch) const { return toupper(ch); }
};  

string doctorj::StringUtilities::join(const string& delim, string parts[], int nparts)
{
    string joined = parts[0];
    for (int i = 1; i < nparts; ++i) {
        joined += delim + parts[i];
    }
    return joined;
}

string doctorj::StringUtilities::toLower(const string& str)
{
    string newstr = str;
    transform(newstr.begin(), newstr.end(), newstr.begin(), dropcase());
    return newstr;
}

string doctorj::StringUtilities::toUpper(const string& str)
{
    string newstr = str;
    transform(newstr.begin(), newstr.end(), newstr.begin(), upcase());
    return newstr;
}

void doctorj::StringUtilities::subst(string* const str, const string& lhs, const string& rhs)
{
    unsigned int i = 0;
    while (i < str->length()) {
        unsigned int idx = str->find(lhs, i);
        if (idx == string::npos) {
            // we're at the end
            break;
        }
        else {
            str->replace(idx, lhs.length(), rhs);
            i = idx + rhs.length();
        }
    }
}

int doctorj::StringUtilities::count(const string& str, char ch)
{   
    int ct = 0;
    for (unsigned int i = 0, len = str.length(); i < len; ++i) {
        if (str[i] == ch) {
            ct++;
        }
    }
    return ct;
}

int doctorj::StringUtilities::countWords(const string& str)
{
    // a "word" is a chunk of text followed by whitespace
    int count = 0;
    bool inWord = false;
    int p = 0;
    int len = str.length();
    for (; p < len; ++p) {
        if (isspace(str[p])) {
            if (inWord) {
                ++count;
            }
            inWord = false;
        }
        else if (!isspace(str[p])) {
            inWord = true;
        }
    }

    // did we end with a word?
    if (len > 0 && inWord && !isspace(str[p - 1])) {
        ++count;
    }

    return count;
}

vector<string> doctorj::StringUtilities::split(const string& str, 
                                               const string& del, 
                                               int limit)
{
    vector<string> result;
    
    // very inspired by Ruby and Perl
    long pos = 0;
    long len = str.length();
    long epos = pos + len;
    unsigned long beg, end;
    long n = 1;
    long dlen = del.length();

    if (limit == 1) {
        result.push_back(str);
        return result;
    }

    if (del == " ") {
        // AWK emulation, i.e., skip multiple spaces
        bool skip = true;

        for (end = beg = 0; pos < epos; ++pos) {
            if (skip) {
                if (isspace(str[pos])) {
                    ++beg;
                }
                else {
                    end = beg + 1;
                    skip = false;
                }
            }
            else {
                if (isspace(str[pos])) {
                    result.push_back(str.substr(beg, end - beg));
                    skip = true;
                    beg = end + 1;
                    if (limit >= 0 && limit <= ++n) {
                        break;
                    }
                }
                else {
                    ++end;
                }
            }
        }
    }
    else {
        for (end = beg = 0; pos < epos; ) {
//             cout << "comparing '" 
//                  << str.substr(pos, dlen)
//                  << "' and '"
//                  << del
//                  << "'" << endl;
//             cout << "    pos = " << pos << endl;
            if (str.substr(pos, dlen) == del) {
//                 cout << "got a match" << endl;
                string s(str.substr(beg, end - beg));
//                 cout << "    ss  = '" << ss << "'" << endl;
//                 cout << "    beg = " << beg << endl;
//                 cout << "    end = " << end << endl;
//                 cout << "    pos = " << pos << endl;
//                 cout << "    e-b = " << (end - beg) << endl;

                result.push_back(s);
                end += dlen;
                beg = end;
                pos += dlen;
                // cout << "    beg = " << beg << endl;
                // cout << "    end = " << end << endl;
                // cout << "    pos = " << pos << endl;
                if (limit >= 0 && limit <= ++n) {
                    break;
                }
            }
            
            ++pos;
            ++end;
        }
    }

//     cout << "before the end:" << endl;
//     cout << "    str.length: " << str.length() << endl;
//     cout << "    beg: " << beg << endl;

    if (str.length() >= beg) {
//         cout << "at the end..." << endl;
//         cout << "    beg = " << beg << endl;
        string s = str.length() == beg ? "" : str.substr(beg);
//         cout << "    tmp = '" << beg << "'" << endl;;

        result.push_back(s);
    }

    return result;
}

bool doctorj::StringUtilities::startsWith(const string& s, const string& t)
{
    return s.length() >= t.length() && s.substr(0, t.length()) == t;
}


bool doctorj::StringUtilities::endsWith(const string& s, const string& t)
{
    return s.length() >= t.length() && s.substr(s.length() - t.length()) == t;
}

void doctorj::StringUtilities::trimFront(string* const str)
{
    while (true) {
        if (isspace((*str)[0])) {
            str->erase(0, 1);
        }
        else {
            break;
        }
    }
}

void doctorj::StringUtilities::trimRear(string* const str)
{
    while (true) {
        int pos = str->length() - 1;
        if (isspace((*str)[pos])) {
            str->erase(pos, 1);
        }
        else {
            break;
        }
    }
}

void doctorj::StringUtilities::trim(string* const str)
{
    trimFront(str);
    trimRear(str);
}

void doctorj::StringUtilities::getWords(const string& str, 
                                      vector<string>* const words)
{
    string s = str;             // copy

    bool inWord = false;        // whether we're in a word
    string word;                // current word
    for (int i = 0, len = s.length(); i < len; ++i) {
        char ch = s[i];
        if (inWord) {
            if (isspace(ch)) {
                words->push_back(word);
                word = "";
                inWord = false;
            }
            else {
                word += ch;
            }
        }
        else if (!isspace(ch)) {
            word += ch;
            inWord = true;
        }
    }
    
    // grab the last one, if any.
    if (inWord) {
        words->push_back(word);
    }
}

template <class T>
T convertFromString(const string& s)
{
    T v;
    if (s.length() > 0) {
#ifdef HAVE_SSTREAM
        istringstream iss(s.c_str());
#else
        istrstream iss(s.c_str());
#endif
        iss >> v;
    }
    return v;
}

void doctorj::StringUtilities::fromString(const string& str, bool& v)
{
    v = convertFromString<bool>(str);
}

void doctorj::StringUtilities::fromString(const string& str, char& v)
{
    v = convertFromString<char>(str);
}

void doctorj::StringUtilities::fromString(const string& str, char* v)
{
    v = convertFromString<char*>(str);
}

void doctorj::StringUtilities::fromString(const string& str, double& v)
{
    v = convertFromString<double>(str);
}

void doctorj::StringUtilities::fromString(const string& str, float& v)
{
    v = convertFromString<float>(str);
}

void doctorj::StringUtilities::fromString(const string& str, int& v)
{
    v = convertFromString<int>(str);
}

void doctorj::StringUtilities::fromString(const string& str, long double& v)
{
    v = convertFromString<long double>(str);
}

void doctorj::StringUtilities::fromString(const string& str, long& v)
{
    v = convertFromString<long>(str);
}

void doctorj::StringUtilities::fromString(const string& str, short& v)
{
    v = convertFromString<short>(str);
}

void doctorj::StringUtilities::fromString(const string& str, signed char& v)
{
    v = convertFromString<signed char>(str);
}

void doctorj::StringUtilities::fromString(const string& str, signed char* v)
{
    v = convertFromString<signed char* >(str);
}

void doctorj::StringUtilities::fromString(const string& str, unsigned char& v)
{
    v = convertFromString<unsigned char>(str);
}

void doctorj::StringUtilities::fromString(const string& str, unsigned char* v)
{
    v = convertFromString<unsigned char* >(str);
}

void doctorj::StringUtilities::fromString(const string& str, unsigned int& v)
{
    v = convertFromString<unsigned int>(str);
}

void doctorj::StringUtilities::fromString(const string& str, unsigned long& v)
{
    v = convertFromString<unsigned long>(str);
}

void doctorj::StringUtilities::fromString(const string& str, unsigned short& v)
{
    v = convertFromString<unsigned short>(str);
}

void doctorj::StringUtilities::fromString(const string& str, string& v)
{
    v = str;
}
