#ifndef ByteArray_h
#include "ByteArray.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#include <string.h>
#include <stdio.h>

using namespace doctorj;
using namespace std;

ByteArray::ByteArray(char* const bytes, int nBytes) : buffer_(bytes), bufptr_(bytes), bufend_(bytes + nBytes)
{
}

ByteArray::~ByteArray()
{
}

u1 ByteArray::getU1()
{
    return *bufptr_++;
}

void ByteArray::skip(int n)
{
    bufptr_ += n;
}

char* ByteArray::position() const
{
    return bufptr_;
}

char* ByteArray::getBytes(int nBytes)
{
    char* bytes = new char[nBytes];
    int   nCopy = bufend_ - bufptr_ < nBytes ? bufend_ - bufptr_ : nBytes;

    memcpy(bytes, bufptr_, nCopy);
    bufptr_ += nCopy;

    return bytes;
}


ByteArrayBigEndian::ByteArrayBigEndian(char* const bytes, int nBytes) : ByteArray(bytes, nBytes)
{
}

ByteArrayBigEndian::~ByteArrayBigEndian()
{
}

u2 ByteArrayBigEndian::getU2()
{
    u4 hi = getU1();
    u4 lo = getU1();
    return (hi << 8) + lo;
}

u4 ByteArrayBigEndian::getU4()
{
    u4 val = getU1();
    val = (val << 8) + getU1();
    val = (val << 8) + getU1();
    val = (val << 8) + getU1();
    return val;
}
