#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleUselessThisInMethodInvocation_h
#include "RuleUselessThisInMethodInvocation.h"
#endif

#ifndef ErrorUselessThisInMethodInvocation_h
#include "ErrorUselessThisInMethodInvocation.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleUselessThisInMethodInvocation";

class RuleUselessThisInMethodInvocationTest : 
    public RuleTest<ruleName, RuleUselessThisInMethodInvocation, ErrorUselessThisInMethodInvocation>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUselessThisInMethodInvocation {");
            vec.push_back("    void f() {");
            vec.push_back("        this.g();"); 
            vec.push_back("    }");
            vec.push_back("");
            vec.push_back("    void g() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleUselessThisInMethodInvocation {");
            vec.push_back("    RuleUselessThisInMethodInvocation() {");
            vec.push_back("        while (false) {"); 
            vec.push_back("            // nothing"); 
            vec.push_back("        }");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleUselessThisInMethodInvocationTest t;
    t.run();
    cout << "useless this in method invocation rule test results: " << t << endl;
    return t.nerrors();
}
