#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleFieldPackageAccess_h
#include "RuleFieldPackageAccess.h"
#endif

#ifndef ErrorFieldPackageAccess_h
#include "ErrorFieldPackageAccess.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleFieldPackageAccess";

class RuleFieldPackageAccessTest : 
    public RuleTest<ruleName, RuleFieldPackageAccess, ErrorFieldPackageAccess>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleFieldPackageAccess {");
        vec0.push_back("    int foo;");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleFieldPackageAccess {");
        vec1.push_back("    interface InnnerRuleFieldPackageAccess {");
        vec1.push_back("        int foo;"); 
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);

        std::vector<std::string> vec2;
        vec2.push_back("class RuleFieldPackageAccess {");
        vec2.push_back("    interface InnnerRuleFieldPackageAccess {");
        vec2.push_back("        static int foo;"); 
        vec2.push_back("    }");
        vec2.push_back("}");
        contents->push_back(vec2);
    }

    virtual int errorsExpected(int num) const { 
        // return num == 0 ? 1 : 0; 
        return 1;
    }

};

int main(int argc, char** argv) 
{
    RuleFieldPackageAccessTest t;
    t.run();
    cout << "field package access rule test results: " << t << endl;
    return t.nerrors();
}
