#ifndef Test_h
#include "Test.h"
#endif

#ifndef ErrorTest_h
#include "ErrorTest.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace doctorj;

class MyErrorTest : public ErrorTest
{
public:
    MyErrorTest() {}
    
    virtual ~MyErrorTest() {}

    virtual string name() const {
        return "MyErrorTest";
    }

    int testCount() const { 
        return 0; 
    }

    virtual void getContents(vector<string>* const vec, int num) {
    }
    
    virtual Rule* getRule(NullReporter* const rep) { 
        return NULL; 
    }

    virtual void checkError(NullReporter* const rep, int num) {
    }
};


class ErrorTestTest : public Test 
{
public:
    ErrorTestTest();
    
    virtual ~ErrorTestTest();

    virtual void run();
};


ErrorTestTest::ErrorTestTest() : Test(true)
{
}

ErrorTestTest::~ErrorTestTest()
{
}

void ErrorTestTest::run() 
{
    MyErrorTest met;
    TESTEQ("MyErrorTest", met.name(), "file");
    TESTEQ(Platform::isReadableFile("/tmp/MyErrorTest.java"), false, "file should not exist yet");
    met.run();
    TESTEQ(Platform::isReadableFile("/tmp/MyErrorTest.java"), false, "file should not exist any longer");
}

int main(int argc, char** argv) 
{
    Log::setEnabled();
    
    ErrorTestTest t;
    t.run();
    cout << "error test results: " << t << endl;
    return t.nerrors();
}
