#ifndef SynDebug_h
#define SynDebug_h

#ifndef Debug_h
#include "Debug.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

#ifndef stdio_h
#include "stdio.h"
#endif

#ifdef DEBUGGING
#    define DEBUG_SYNTAX_ANALYZER(a)   if (DebugOptions::get()->isEnabled('s')) { a;                  }
#    define SYNLOG(str)                if (DebugOptions::get()->isEnabled('s')) { LOG(5, str);        }
#    define SYNLOGF(fmt, args...)      if (DebugOptions::get()->isEnabled('s')) { LOGF(5, fmt, args); }
#else
#    define DEBUG_SYNTAX_ANALYZER(a)   
#    define SYNLOG(a)                  
#    define SYNLOGF(fmt, args...)
#endif

#endif //! SynDebug_h
