#ifndef SequenceChecker_h
#define SequenceChecker_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class SequenceOrder;
    class AstItem;

    class SequenceChecker
    {
    public:

        /**
         * Singleton accessor.
         */
        static SequenceChecker* get();

        virtual ~SequenceChecker();

        /**
         * Returns whether it is valid that the current object should follow the
         * previous one, according to the user preferences. If the previous one
         * is NULL, true is returned.
         */
        virtual bool shouldFollow(AstItem* const current, AstItem* const previous);

        /**
         * Returns the "preferred order" for the given item.
         */
        virtual int order(AstItem* const item) const;

    protected:
        SequenceChecker();

    private:
        static SequenceChecker* instance_;

        /**
         * The preferences, in order.
         */
        vector<SequenceOrder*> preferences_;

    };
}

#endif //! SequenceChecker_h
