#ifndef RulePublicField_h
#include "RulePublicField.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorPublicField_h
#include "ErrorPublicField.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RulePublicField::RulePublicField(Reporter* const reporter) : Rule(reporter)
{
}

RulePublicField::~RulePublicField()
{
}

void RulePublicField::process(AstFieldDeclarationMods* const fd)
{
    SYNLOG("");

    JavaModifierList mods(fd);

    // warn against public non-static fields (but OK if final?)
    bool isStatic = mods.containsStatic();
    bool isFinal  = mods.containsFinal();
    AstLeaf* access = mods.getAccess();
    if (access && dynamic_cast<AstPublic*>(access) && !isStatic) {
        JavaFieldDeclaration::complainAboutVariableList<ErrorPublicField>(reporter(), fd);
    }

}

