#ifndef RuleIfStatementsReversed_h
#include "RuleIfStatementsReversed.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorIfStatementsReversed_h
#include "ErrorIfStatementsReversed.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleIfStatementsReversed::RuleIfStatementsReversed(Reporter* const reporter) : Rule(reporter)
{
}

RuleIfStatementsReversed::~RuleIfStatementsReversed()
{
}

void RuleIfStatementsReversed::process(AstIfThenElseStatement* const i)
{
    SYNLOG("");

    AstItem* cond = i->getExpression();
    if (dynamic_cast<AstEqualityExpressionNe*>(cond) ||
        dynamic_cast<AstUnaryExpressionNot*>(cond)) {
        ErrorIfStatementsReversed* err = new ErrorIfStatementsReversed(reporter(), i);
        err->process();
    }

    traverse(i);
}

