#ifndef RuleGenericExceptionSpecification_h
#include "RuleGenericExceptionSpecification.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorGenericExceptionSpecification_h
#include "ErrorGenericExceptionSpecification.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleGenericExceptionSpecification::RuleGenericExceptionSpecification(Reporter* const reporter) : Rule(reporter)
{
}

RuleGenericExceptionSpecification::~RuleGenericExceptionSpecification()
{
}

void RuleGenericExceptionSpecification::process(AstThrowsNameList* const tnl)
{
    SYNLOG("");

    // see if they're saying "throws Exception" or "throws Throwable"
    AstNameList* nameList = tnl->getNameList();
    
    if (nameList->getNameCount() == 1) {
        AstName* name = nameList->getName(0);
        string fname = name->fullName();
        if (fname == "java.lang.Throwable" ||
            fname == "java.lang.Exception" ||
            fname == "Throwable" ||
            fname == "Exception") {
            ErrorGenericExceptionSpecification* err = new ErrorGenericExceptionSpecification(reporter(), tnl);
            err->process();
        }
    }

    traverse(tnl);
}

