#ifndef RuleGenericCatch_h
#include "RuleGenericCatch.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorGenericCatch_h
#include "ErrorGenericCatch.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleGenericCatch::RuleGenericCatch(Reporter* const reporter) : Rule(reporter)
{
}

RuleGenericCatch::~RuleGenericCatch()
{
}

void RuleGenericCatch::process(AstCatchClause* const cc)
{
    // catch (Exception e) or catch (Throwable t) are generic
    
    AstFormalParameter* fp = cc->getFormalParameter();
    AstItem*            t  = fp->getType();

    string type = t->text();
    
    SYNLOG("testing " + type);
    
    if (type == "java.lang.Throwable" ||
        type == "java.lang.Exception" ||
        type == "Throwable" ||
        type == "Exception") {
        ErrorGenericCatch* err = new ErrorGenericCatch(reporter(), cc);
        err->process();
    }

    traverse(cc);
}

