#ifndef RuleFieldPackageAccess_h
#include "RuleFieldPackageAccess.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorFieldPackageAccess_h
#include "ErrorFieldPackageAccess.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

int RuleFieldPackageAccess::maxLength = -2;

RuleFieldPackageAccess::RuleFieldPackageAccess(Reporter* const reporter) : Rule(reporter)
{
    SYNLOG("");
}

RuleFieldPackageAccess::~RuleFieldPackageAccess()
{
}

void RuleFieldPackageAccess::process(AstFieldDeclarationMods* const fd)
{
    JavaModifierList mods(fd);
    AstLeaf* access = mods.getAccess();
    if (!access) {
        JavaFieldDeclaration::complainAboutVariableList<ErrorFieldPackageAccess>(reporter(), fd);
    }
    
    // no need to traverse
}

void RuleFieldPackageAccess::process(AstFieldDeclarationNoMods* const fd)
{
    JavaFieldDeclaration::complainAboutVariableList<ErrorFieldPackageAccess>(reporter(), fd);

    // no need to traverse
}
