#ifndef RuleAbstractModifierUsedForInterface_h
#include "RuleAbstractModifierUsedForInterface.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorAbstractMethodModifierUsedInInterface_h
#include "ErrorAbstractMethodModifierUsedInInterface.h"
#endif

#ifndef ErrorAbstractModifierUsedForInterface_h
#include "ErrorAbstractModifierUsedForInterface.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleAbstractModifierUsedForInterface::RuleAbstractModifierUsedForInterface(Reporter* const reporter) : Rule(reporter)
{
}

RuleAbstractModifierUsedForInterface::~RuleAbstractModifierUsedForInterface()
{
}

void RuleAbstractModifierUsedForInterface::process(AstInterfaceDeclarationModsExtends* const id)
{
    doCheck(id);
}

void RuleAbstractModifierUsedForInterface::process(AstInterfaceDeclarationModsNoExtends* const id)
{
    doCheck(id);
}

void RuleAbstractModifierUsedForInterface::doCheck(AstInterfaceDeclaration* const id)
{
    AstModifierList* modlist = id->getModifierList();
    if (modlist && JavaModifierList::getAbstractModifier(id->getModifierList())) {
        ErrorAbstractModifierUsedForInterface* err = new ErrorAbstractModifierUsedForInterface(reporter(), id);
        err->process();
    }
    traverse(id);
}
