#ifndef ImportList_h
#define ImportList_h

#ifndef ReferencedImport_h
#include "ReferencedImport.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

namespace doctorj
{
    class AstImportDeclarationOnDemand;
    class AstImportDeclarationSingle;

    class ImportList 
    {
    public:
        ImportList();

        virtual ~ImportList();

        /**
         * Returns the first import in the list that matches the given full
         * name.
         */
        ReferencedImport* findByFullName(const string& fullName) const;

        /**
         * Returns the first import in the list that is an exact match for the
         * given type name. If there is no exact match, returns the first import
         * that is an approximate match.
         */
        ReferencedImport* findBestMatch(const string& typeName) const;

        /**
         * Returns the first import that is an explicit (single) match for the
         * given name.
         */
        ReferencedImport* findExplicitMatch(const string& typeName) const;
        
        /**
         * Returns the first import that is an implicit (on-demand) match for
         * the given name.
         */
        ReferencedImport* findImplicitMatch(const string& typeName) const;
        
        /**
         * Finds the first import that is an implicit (on-demand) match for the
         * given name, and adds a reference to it.
         */
        void checkForMatch(const string& typeName) const;
        
        /**
         * Adds the single import to the list.
         */
        void add(AstImportDeclarationSingle* const id);

        /**
         * Adds the on-demand import to the list.
         */
        void add(AstImportDeclarationOnDemand* const id);

        /**
         * Clears the list.
         */
        void clear();

        /**
         * Returns a list of unused imports.
         */
        vector<AstImportDeclaration*> getUnusedImports() const;

        /**
         * Adds that the given import was referenced.
         */

    private:
        vector<ReferencedImport*> imports_;

    };
    
}

#endif //! ImportList_h
