#ifndef ErrorUselessSuperInMethodInvocation_h
#include "ErrorUselessSuperInMethodInvocation.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorUselessSuperInMethodInvocation);

ErrorUselessSuperInMethodInvocation::ErrorUselessSuperInMethodInvocation()
{
}

ErrorUselessSuperInMethodInvocation::ErrorUselessSuperInMethodInvocation(Reporter* const reporter, AstMethodInvocationSuper* const mi) :
        SyntaxError(reporter, mi), name_(mi->getIdentifier()->text())
{
}

ErrorUselessSuperInMethodInvocation::~ErrorUselessSuperInMethodInvocation()
{
}

string ErrorUselessSuperInMethodInvocation::title() const
{
    return "Useless Use of Super in Method Invocation";
}

void ErrorUselessSuperInMethodInvocation::writeDescription(ostream& os) const
{
    os << "Useless use of super in method invocation. The method does not exist" << endl;
    os << "in the containing class, so the statement has no effect." << endl;
}

string ErrorUselessSuperInMethodInvocation::message() const
{
    return "method '" + name_ + "' does not exist in the containing class; the super is useless";
}
