#ifndef ErrorUnreferencedImport_h
#include "ErrorUnreferencedImport.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorUnreferencedImport);

ErrorUnreferencedImport::ErrorUnreferencedImport()
{
}

ErrorUnreferencedImport::ErrorUnreferencedImport(Reporter* const reporter, AstImportDeclaration* const id) :
        SyntaxError(reporter, id)
{
}

ErrorUnreferencedImport::~ErrorUnreferencedImport()
{
}

string ErrorUnreferencedImport::title() const
{
    return "Unreferenced Import";
}

void ErrorUnreferencedImport::writeDescription(ostream& os) const
{
    os << "The import declaration is not referenced within the compilation unit." << endl;
}

string ErrorUnreferencedImport::message() const
{
    return "the import declaration is not referenced";
}
