#ifndef ErrorReturnFromVoidMethod_h
#define ErrorReturnFromVoidMethod_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    
    class AstReturnStatement;
    
    class ErrorReturnFromVoidMethod : public SyntaxError 
    {
    public:
        
        ErrorReturnFromVoidMethod();

        /**
         * Creates the error.
         */
        ErrorReturnFromVoidMethod(Reporter* const reporter, AstReturnStatement* const rs, const string& method);

        virtual ~ErrorReturnFromVoidMethod();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        string method_;

    };

}

#endif //! ErrorReturnFromVoidMethod_h
