#ifndef ErrorRepeatedImportStatement_h
#include "ErrorRepeatedImportStatement.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorRepeatedImportStatement);

ErrorRepeatedImportStatement::ErrorRepeatedImportStatement()
{
}

ErrorRepeatedImportStatement::ErrorRepeatedImportStatement(Reporter* const reporter, AstImportDeclaration* const id) :
        SyntaxError(reporter, id)
{
}

ErrorRepeatedImportStatement::~ErrorRepeatedImportStatement()
{
}

string ErrorRepeatedImportStatement::title() const
{
    return "Repeated Import Declaration";
}

void ErrorRepeatedImportStatement::writeDescription(ostream& os) const
{
    os << "The import declaration is the same as a previous one." << endl;
}

string ErrorRepeatedImportStatement::message() const
{
    return "the import declaration repeats a previous one";
}
