#ifndef ErrorPublicField_h
#include "ErrorPublicField.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorPublicField);

ErrorPublicField::ErrorPublicField()
{
}

ErrorPublicField::ErrorPublicField(Reporter* const reporter, AstItem* const item, const string& name) :
        SyntaxError(reporter, item), name_(name)
{
}

ErrorPublicField::~ErrorPublicField()
{
}

string ErrorPublicField::title() const
{
    return "Public Non-Static Field";
}

void ErrorPublicField::writeDescription(ostream& os) const
{
    os << "Field is public and is not static." << endl;
}

string ErrorPublicField::message() const
{
    return "field '" + name_ + "' is public and is not static";
}
