#ifndef ErrorPackageAccess_h
#include "ErrorPackageAccess.h"
#endif

using namespace doctorj;

ErrorPackageAccess::ErrorPackageAccess()
{
}

ErrorPackageAccess::ErrorPackageAccess(Reporter* const reporter, AstItem* const item, const string& name) :
        SyntaxError(reporter, item), name_(name)
{
}

ErrorPackageAccess::~ErrorPackageAccess()
{
}

string ErrorPackageAccess::title() const
{
    return typeAsCapitalized() + " Has Default (Package) Access";
}

void ErrorPackageAccess::writeDescription(ostream& os) const
{
    os << typeAsCapitalized() + " access is unspecified, defaulting to package." << endl;
}

string ErrorPackageAccess::message() const
{
    return typeAsLowercase() + " '" + name_ + "' has unspecified (package) access";
}
