#ifndef ErrorImproperSequence_h
#include "ErrorImproperSequence.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorImproperSequence);

ErrorImproperSequence::ErrorImproperSequence()
{
}

ErrorImproperSequence::ErrorImproperSequence(Reporter* const reporter, AstItem* const item, AstItem* const previous, AstItem* const current) :
        SyntaxError(reporter, item), previous_(previous), current_(current)
{
}

ErrorImproperSequence::~ErrorImproperSequence()
{
}

string ErrorImproperSequence::title() const
{
    return "Type Violates Preferred Declaration Order";
}

void ErrorImproperSequence::writeDescription(ostream& os) const
{
    os << "The type declaration is not in the preferred order." << endl;
}

static string nameString(AstItem* const item)
{
    vector<string> names = JavaItem::namesOf(item);
    string str;
    if (names.size() <= 0) {
        str = "<<huh?>>";
    }
    else if (names.size() == 1) {
        str = names[0];
    }
    else {
        str = StringUtilities::join(", ", names.begin(), names.end() - 1) + " and " + *(names.end() - 1);
    }
    return str;
}

static string descriptionString(AstItem* const item)
{
    AstModifierList* mods = JavaItem::getModifierList(item);
    string a = JavaModifierList::accessOf(mods);
    string t = JavaItem::typeOf(item);
    string n = nameString(item);
    if (t == "ctor") {
        return a + " " + t + " '" + n + "'";
    }
    else {
        string f = JavaModifierList::finalityOf(mods);
        string o = JavaModifierList::ownershipOf(mods);
        return a + " " + f + " " + o + " " + t + " '" + n + "'";
    }
    
}

string ErrorImproperSequence::message() const
{
    string cdesc = descriptionString(current_);
    string pdesc = descriptionString(previous_);

    return "declaration of " + cdesc + " should not follow " + pdesc;
}
