#ifndef ErrorIfStatementsReversed_h
#include "ErrorIfStatementsReversed.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorIfStatementsReversed);

ErrorIfStatementsReversed::ErrorIfStatementsReversed()
{
}

ErrorIfStatementsReversed::ErrorIfStatementsReversed(Reporter* const reporter, 
                                                     AstIfThenElseStatement* const stmt)
        :  SyntaxError(reporter, stmt)
{
}

ErrorIfStatementsReversed::~ErrorIfStatementsReversed()
{
}

string ErrorIfStatementsReversed::title() const
{
    return "If Statements Reversed";
}

void ErrorIfStatementsReversed::writeDescription(ostream& os) const
{
    os << "The if-then-else sequence:" << endl;
    os << "    if (negative) { " << endl;
    os << "        one();" << endl;
    os << "    }" << endl;
    os << "    else {" << endl;
    os << "        two();" << endl;
    os << "    }" << endl;
    os << endl;
    os << "might be clearer as:" << endl;
    os << "    if (positive) { " << endl;
    os << "        two();" << endl;
    os << "    }" << endl;
    os << "    else {" << endl;
    os << "        one();" << endl;
    os << "    }" << endl;
}

string ErrorIfStatementsReversed::message() const
{
    //$$$ improve this description
    return "if (negative) then {} else {} is logically confusing";
}
