#ifndef ErrorGenericExceptionSpecification_h
#include "ErrorGenericExceptionSpecification.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorGenericExceptionSpecification);

ErrorGenericExceptionSpecification::ErrorGenericExceptionSpecification()
{
}

ErrorGenericExceptionSpecification::ErrorGenericExceptionSpecification(Reporter* const reporter, AstThrowsNameList* const tnl) :
        SyntaxError(reporter, tnl), throwsList_(tnl)
{
}

ErrorGenericExceptionSpecification::~ErrorGenericExceptionSpecification()
{
}

string ErrorGenericExceptionSpecification::title() const
{
    return "Overly General Exception Specification";
}

void ErrorGenericExceptionSpecification::writeDescription(ostream& os) const
{
    os << "the catch clause is overly general" << endl;
}

string ErrorGenericExceptionSpecification::message() const
{
    AstNameList* nlist = throwsList_->getNameList();
    AstName*     name  = nlist->getName(0);
    string       fname = name->fullName();
    return "the exception specification '" + fname + "' is overly general";
}
