#ifndef ErrorExplicitSuperCall_h
#define ErrorExplicitSuperCall_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstExplicitConstructorInvocationSuper;
    
    class ErrorExplicitSuperCall : public SyntaxError 
    {
    public:
        
        ErrorExplicitSuperCall();

        /**
         * Creates the error.
         */
        ErrorExplicitSuperCall(Reporter* const reporter, AstExplicitConstructorInvocationSuper* const ec);

        virtual ~ErrorExplicitSuperCall();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    };

}

#endif //! ErrorExplicitSuperCall_h
