#ifndef ErrorEmptyFor_h
#include "ErrorEmptyFor.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorEmptyFor);

ErrorEmptyFor::ErrorEmptyFor()
{
}

ErrorEmptyFor::ErrorEmptyFor(Reporter* const reporter, 
                             AstForStatementNoInitNoConditionNoUpdate* const fs)
        : SyntaxError(reporter, fs)
{
}

ErrorEmptyFor::~ErrorEmptyFor()
{
}

string ErrorEmptyFor::title() const
{
    return "Empty For Condition";
}

void ErrorEmptyFor::writeDescription(ostream& os) const
{
    os << "for (;;) could also be written as while (true)." << endl;
}

string ErrorEmptyFor::message() const
{
    return "for (;;) could instead be written as while (true)";
}
