#ifndef ErrorAbstractModifierUsedForInterface_h
#define ErrorAbstractModifierUsedForInterface_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstInterfaceDeclaration;

    class ErrorAbstractModifierUsedForInterface : public SyntaxError 
    {
    public:
        
        ErrorAbstractModifierUsedForInterface();

        /**
         * Creates the error.
         */
        ErrorAbstractModifierUsedForInterface(Reporter* const reporter, AstInterfaceDeclaration* const id);
        
        virtual ~ErrorAbstractModifierUsedForInterface();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        string interface_;

    };

}

#endif //! ErrorAbstractModifierUsedForInterface_h
